/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMalwareProtectionPlanResponse extends GuardDutyResponse implements
        ToCopyableBuilder<GetMalwareProtectionPlanResponse.Builder, GetMalwareProtectionPlanResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetMalwareProtectionPlanResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(GetMalwareProtectionPlanResponse::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final SdkField<CreateProtectedResource> PROTECTED_RESOURCE_FIELD = SdkField
            .<CreateProtectedResource> builder(MarshallingType.SDK_POJO).memberName("ProtectedResource")
            .getter(getter(GetMalwareProtectionPlanResponse::protectedResource)).setter(setter(Builder::protectedResource))
            .constructor(CreateProtectedResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protectedResource").build()).build();

    private static final SdkField<MalwareProtectionPlanActions> ACTIONS_FIELD = SdkField
            .<MalwareProtectionPlanActions> builder(MarshallingType.SDK_POJO).memberName("Actions")
            .getter(getter(GetMalwareProtectionPlanResponse::actions)).setter(setter(Builder::actions))
            .constructor(MalwareProtectionPlanActions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(GetMalwareProtectionPlanResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetMalwareProtectionPlanResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<MalwareProtectionPlanStatusReason>> STATUS_REASONS_FIELD = SdkField
            .<List<MalwareProtectionPlanStatusReason>> builder(MarshallingType.LIST)
            .memberName("StatusReasons")
            .getter(getter(GetMalwareProtectionPlanResponse::statusReasons))
            .setter(setter(Builder::statusReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MalwareProtectionPlanStatusReason> builder(MarshallingType.SDK_POJO)
                                            .constructor(MalwareProtectionPlanStatusReason::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetMalwareProtectionPlanResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ROLE_FIELD,
            PROTECTED_RESOURCE_FIELD, ACTIONS_FIELD, CREATED_AT_FIELD, STATUS_FIELD, STATUS_REASONS_FIELD, TAGS_FIELD));

    private final String arn;

    private final String role;

    private final CreateProtectedResource protectedResource;

    private final MalwareProtectionPlanActions actions;

    private final Instant createdAt;

    private final String status;

    private final List<MalwareProtectionPlanStatusReason> statusReasons;

    private final Map<String, String> tags;

    private GetMalwareProtectionPlanResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.role = builder.role;
        this.protectedResource = builder.protectedResource;
        this.actions = builder.actions;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.statusReasons = builder.statusReasons;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the protected resource.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the protected resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the IAM role that includes the permissions to scan and add tags to the associated
     * protected resource.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the IAM role that includes the permissions to scan and add tags to the
     *         associated protected resource.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * Information about the protected resource that is associated with the created Malware Protection plan. Presently,
     * <code>S3Bucket</code> is the only supported protected resource.
     * </p>
     * 
     * @return Information about the protected resource that is associated with the created Malware Protection plan.
     *         Presently, <code>S3Bucket</code> is the only supported protected resource.
     */
    public final CreateProtectedResource protectedResource() {
        return protectedResource;
    }

    /**
     * <p>
     * Information about whether the tags will be added to the S3 object after scanning.
     * </p>
     * 
     * @return Information about whether the tags will be added to the S3 object after scanning.
     */
    public final MalwareProtectionPlanActions actions() {
        return actions;
    }

    /**
     * <p>
     * The timestamp when the Malware Protection plan resource was created.
     * </p>
     * 
     * @return The timestamp when the Malware Protection plan resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Malware Protection plan status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MalwareProtectionPlanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Malware Protection plan status.
     * @see MalwareProtectionPlanStatus
     */
    public final MalwareProtectionPlanStatus status() {
        return MalwareProtectionPlanStatus.fromValue(status);
    }

    /**
     * <p>
     * Malware Protection plan status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MalwareProtectionPlanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Malware Protection plan status.
     * @see MalwareProtectionPlanStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusReasons() {
        return statusReasons != null && !(statusReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the issue code and message associated to the status of your Malware Protection plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusReasons} method.
     * </p>
     * 
     * @return Information about the issue code and message associated to the status of your Malware Protection plan.
     */
    public final List<MalwareProtectionPlanStatusReason> statusReasons() {
        return statusReasons;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags added to the Malware Protection plan resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags added to the Malware Protection plan resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(protectedResource());
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusReasons() ? statusReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMalwareProtectionPlanResponse)) {
            return false;
        }
        GetMalwareProtectionPlanResponse other = (GetMalwareProtectionPlanResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(role(), other.role())
                && Objects.equals(protectedResource(), other.protectedResource()) && Objects.equals(actions(), other.actions())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasStatusReasons() == other.hasStatusReasons() && Objects.equals(statusReasons(), other.statusReasons())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMalwareProtectionPlanResponse").add("Arn", arn()).add("Role", role())
                .add("ProtectedResource", protectedResource()).add("Actions", actions()).add("CreatedAt", createdAt())
                .add("Status", statusAsString()).add("StatusReasons", hasStatusReasons() ? statusReasons() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "ProtectedResource":
            return Optional.ofNullable(clazz.cast(protectedResource()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReasons":
            return Optional.ofNullable(clazz.cast(statusReasons()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMalwareProtectionPlanResponse, T> g) {
        return obj -> g.apply((GetMalwareProtectionPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMalwareProtectionPlanResponse> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the protected resource.
         * </p>
         * 
         * @param arn
         *        Amazon Resource Name (ARN) of the protected resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the IAM role that includes the permissions to scan and add tags to the
         * associated protected resource.
         * </p>
         * 
         * @param role
         *        Amazon Resource Name (ARN) of the IAM role that includes the permissions to scan and add tags to the
         *        associated protected resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * Information about the protected resource that is associated with the created Malware Protection plan.
         * Presently, <code>S3Bucket</code> is the only supported protected resource.
         * </p>
         * 
         * @param protectedResource
         *        Information about the protected resource that is associated with the created Malware Protection plan.
         *        Presently, <code>S3Bucket</code> is the only supported protected resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedResource(CreateProtectedResource protectedResource);

        /**
         * <p>
         * Information about the protected resource that is associated with the created Malware Protection plan.
         * Presently, <code>S3Bucket</code> is the only supported protected resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateProtectedResource.Builder} avoiding
         * the need to create one manually via {@link CreateProtectedResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateProtectedResource.Builder#build()} is called immediately
         * and its result is passed to {@link #protectedResource(CreateProtectedResource)}.
         * 
         * @param protectedResource
         *        a consumer that will call methods on {@link CreateProtectedResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protectedResource(CreateProtectedResource)
         */
        default Builder protectedResource(Consumer<CreateProtectedResource.Builder> protectedResource) {
            return protectedResource(CreateProtectedResource.builder().applyMutation(protectedResource).build());
        }

        /**
         * <p>
         * Information about whether the tags will be added to the S3 object after scanning.
         * </p>
         * 
         * @param actions
         *        Information about whether the tags will be added to the S3 object after scanning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(MalwareProtectionPlanActions actions);

        /**
         * <p>
         * Information about whether the tags will be added to the S3 object after scanning.
         * </p>
         * This is a convenience method that creates an instance of the {@link MalwareProtectionPlanActions.Builder}
         * avoiding the need to create one manually via {@link MalwareProtectionPlanActions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MalwareProtectionPlanActions.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(MalwareProtectionPlanActions)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link MalwareProtectionPlanActions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(MalwareProtectionPlanActions)
         */
        default Builder actions(Consumer<MalwareProtectionPlanActions.Builder> actions) {
            return actions(MalwareProtectionPlanActions.builder().applyMutation(actions).build());
        }

        /**
         * <p>
         * The timestamp when the Malware Protection plan resource was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the Malware Protection plan resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Malware Protection plan status.
         * </p>
         * 
         * @param status
         *        Malware Protection plan status.
         * @see MalwareProtectionPlanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MalwareProtectionPlanStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Malware Protection plan status.
         * </p>
         * 
         * @param status
         *        Malware Protection plan status.
         * @see MalwareProtectionPlanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MalwareProtectionPlanStatus
         */
        Builder status(MalwareProtectionPlanStatus status);

        /**
         * <p>
         * Information about the issue code and message associated to the status of your Malware Protection plan.
         * </p>
         * 
         * @param statusReasons
         *        Information about the issue code and message associated to the status of your Malware Protection plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReasons(Collection<MalwareProtectionPlanStatusReason> statusReasons);

        /**
         * <p>
         * Information about the issue code and message associated to the status of your Malware Protection plan.
         * </p>
         * 
         * @param statusReasons
         *        Information about the issue code and message associated to the status of your Malware Protection plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReasons(MalwareProtectionPlanStatusReason... statusReasons);

        /**
         * <p>
         * Information about the issue code and message associated to the status of your Malware Protection plan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.MalwareProtectionPlanStatusReason.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.MalwareProtectionPlanStatusReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.MalwareProtectionPlanStatusReason.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #statusReasons(List<MalwareProtectionPlanStatusReason>)}.
         * 
         * @param statusReasons
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.MalwareProtectionPlanStatusReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusReasons(java.util.Collection<MalwareProtectionPlanStatusReason>)
         */
        Builder statusReasons(Consumer<MalwareProtectionPlanStatusReason.Builder>... statusReasons);

        /**
         * <p>
         * Tags added to the Malware Protection plan resource.
         * </p>
         * 
         * @param tags
         *        Tags added to the Malware Protection plan resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private String arn;

        private String role;

        private CreateProtectedResource protectedResource;

        private MalwareProtectionPlanActions actions;

        private Instant createdAt;

        private String status;

        private List<MalwareProtectionPlanStatusReason> statusReasons = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMalwareProtectionPlanResponse model) {
            super(model);
            arn(model.arn);
            role(model.role);
            protectedResource(model.protectedResource);
            actions(model.actions);
            createdAt(model.createdAt);
            status(model.status);
            statusReasons(model.statusReasons);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final CreateProtectedResource.Builder getProtectedResource() {
            return protectedResource != null ? protectedResource.toBuilder() : null;
        }

        public final void setProtectedResource(CreateProtectedResource.BuilderImpl protectedResource) {
            this.protectedResource = protectedResource != null ? protectedResource.build() : null;
        }

        @Override
        public final Builder protectedResource(CreateProtectedResource protectedResource) {
            this.protectedResource = protectedResource;
            return this;
        }

        public final MalwareProtectionPlanActions.Builder getActions() {
            return actions != null ? actions.toBuilder() : null;
        }

        public final void setActions(MalwareProtectionPlanActions.BuilderImpl actions) {
            this.actions = actions != null ? actions.build() : null;
        }

        @Override
        public final Builder actions(MalwareProtectionPlanActions actions) {
            this.actions = actions;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MalwareProtectionPlanStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<MalwareProtectionPlanStatusReason.Builder> getStatusReasons() {
            List<MalwareProtectionPlanStatusReason.Builder> result = MalwareProtectionPlanStatusReasonsListCopier
                    .copyToBuilder(this.statusReasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatusReasons(Collection<MalwareProtectionPlanStatusReason.BuilderImpl> statusReasons) {
            this.statusReasons = MalwareProtectionPlanStatusReasonsListCopier.copyFromBuilder(statusReasons);
        }

        @Override
        public final Builder statusReasons(Collection<MalwareProtectionPlanStatusReason> statusReasons) {
            this.statusReasons = MalwareProtectionPlanStatusReasonsListCopier.copy(statusReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(MalwareProtectionPlanStatusReason... statusReasons) {
            statusReasons(Arrays.asList(statusReasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(Consumer<MalwareProtectionPlanStatusReason.Builder>... statusReasons) {
            statusReasons(Stream.of(statusReasons).map(c -> MalwareProtectionPlanStatusReason.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetMalwareProtectionPlanResponse build() {
            return new GetMalwareProtectionPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
