/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFindingsRequest extends GuardDutyRequest implements
        ToCopyableBuilder<ListFindingsRequest.Builder, ListFindingsRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(ListFindingsRequest::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<FindingCriteria> FINDING_CRITERIA_FIELD = SdkField
            .<FindingCriteria> builder(MarshallingType.SDK_POJO).memberName("FindingCriteria")
            .getter(getter(ListFindingsRequest::findingCriteria)).setter(setter(Builder::findingCriteria))
            .constructor(FindingCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingCriteria").build()).build();

    private static final SdkField<SortCriteria> SORT_CRITERIA_FIELD = SdkField.<SortCriteria> builder(MarshallingType.SDK_POJO)
            .memberName("SortCriteria").getter(getter(ListFindingsRequest::sortCriteria)).setter(setter(Builder::sortCriteria))
            .constructor(SortCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortCriteria").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListFindingsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFindingsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            FINDING_CRITERIA_FIELD, SORT_CRITERIA_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String detectorId;

    private final FindingCriteria findingCriteria;

    private final SortCriteria sortCriteria;

    private final Integer maxResults;

    private final String nextToken;

    private ListFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.findingCriteria = builder.findingCriteria;
        this.sortCriteria = builder.sortCriteria;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the detector that specifies the GuardDuty service whose findings you want to list.
     * </p>
     * 
     * @return The ID of the detector that specifies the GuardDuty service whose findings you want to list.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * Represents the criteria used for querying findings. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * JSON field name
     * </p>
     * </li>
     * <li>
     * <p>
     * accountId
     * </p>
     * </li>
     * <li>
     * <p>
     * region
     * </p>
     * </li>
     * <li>
     * <p>
     * confidence
     * </p>
     * </li>
     * <li>
     * <p>
     * id
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.accessKeyDetails.accessKeyId
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.accessKeyDetails.principalId
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.accessKeyDetails.userName
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.accessKeyDetails.userType
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.iamInstanceProfile.id
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.imageId
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.instanceId
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.networkInterfaces.ipv6Addresses
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.networkInterfaces.publicDnsName
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.networkInterfaces.publicIp
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.networkInterfaces.securityGroups.groupId
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.networkInterfaces.securityGroups.groupName
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.networkInterfaces.subnetId
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.networkInterfaces.vpcId
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.tags.key
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.instanceDetails.tags.value
     * </p>
     * </li>
     * <li>
     * <p>
     * resource.resourceType
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.actionType
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.awsApiCallAction.api
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.awsApiCallAction.callerType
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.awsApiCallAction.remoteIpDetails.city.cityName
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.awsApiCallAction.remoteIpDetails.country.countryName
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.awsApiCallAction.remoteIpDetails.organization.asn
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.awsApiCallAction.serviceName
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.dnsRequestAction.domain
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.dnsRequestAction.domainWithSuffix
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.blocked
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.connectionDirection
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.localPortDetails.port
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.protocol
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.remoteIpDetails.country.countryName
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.remoteIpDetails.organization.asn
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
     * </p>
     * </li>
     * <li>
     * <p>
     * service.action.networkConnectionAction.remotePortDetails.port
     * </p>
     * </li>
     * <li>
     * <p>
     * service.additionalInfo.threatListName
     * </p>
     * </li>
     * <li>
     * <p>
     * service.archived
     * </p>
     * <p>
     * When this attribute is set to 'true', only archived findings are listed. When it's set to 'false', only
     * unarchived findings are listed. When this attribute is not set, all existing findings are listed.
     * </p>
     * </li>
     * <li>
     * <p>
     * service.ebsVolumeScanDetails.scanId
     * </p>
     * </li>
     * <li>
     * <p>
     * service.resourceRole
     * </p>
     * </li>
     * <li>
     * <p>
     * severity
     * </p>
     * </li>
     * <li>
     * <p>
     * type
     * </p>
     * </li>
     * <li>
     * <p>
     * updatedAt
     * </p>
     * <p>
     * Type: Timestamp in Unix Epoch millisecond format: 1486685375000
     * </p>
     * </li>
     * </ul>
     * 
     * @return Represents the criteria used for querying findings. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         JSON field name
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         accountId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         region
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         confidence
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         id
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.accessKeyDetails.accessKeyId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.accessKeyDetails.principalId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.accessKeyDetails.userName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.accessKeyDetails.userType
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.iamInstanceProfile.id
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.imageId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.instanceId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.networkInterfaces.ipv6Addresses
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.networkInterfaces.publicDnsName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.networkInterfaces.publicIp
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.networkInterfaces.securityGroups.groupId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.networkInterfaces.securityGroups.groupName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.networkInterfaces.subnetId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.networkInterfaces.vpcId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.tags.key
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.instanceDetails.tags.value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resource.resourceType
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.actionType
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.awsApiCallAction.api
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.awsApiCallAction.callerType
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.awsApiCallAction.remoteIpDetails.city.cityName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.awsApiCallAction.remoteIpDetails.country.countryName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.awsApiCallAction.remoteIpDetails.organization.asn
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.awsApiCallAction.serviceName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.dnsRequestAction.domain
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.dnsRequestAction.domainWithSuffix
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.blocked
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.connectionDirection
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.localPortDetails.port
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.protocol
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.remoteIpDetails.country.countryName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.remoteIpDetails.organization.asn
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.action.networkConnectionAction.remotePortDetails.port
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.additionalInfo.threatListName
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.archived
     *         </p>
     *         <p>
     *         When this attribute is set to 'true', only archived findings are listed. When it's set to 'false', only
     *         unarchived findings are listed. When this attribute is not set, all existing findings are listed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.ebsVolumeScanDetails.scanId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         service.resourceRole
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         severity
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         type
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         updatedAt
     *         </p>
     *         <p>
     *         Type: Timestamp in Unix Epoch millisecond format: 1486685375000
     *         </p>
     *         </li>
     */
    public final FindingCriteria findingCriteria() {
        return findingCriteria;
    }

    /**
     * <p>
     * Represents the criteria used for sorting findings.
     * </p>
     * 
     * @return Represents the criteria used for sorting findings.
     */
    public final SortCriteria sortCriteria() {
        return sortCriteria;
    }

    /**
     * <p>
     * You can use this parameter to indicate the maximum number of items you want in the response. The default value is
     * 50. The maximum value is 50.
     * </p>
     * 
     * @return You can use this parameter to indicate the maximum number of items you want in the response. The default
     *         value is 50. The maximum value is 50.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * You can use this parameter when paginating results. Set the value of this parameter to null on your first call to
     * the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken
     * from the previous response to continue listing data.
     * </p>
     * 
     * @return You can use this parameter when paginating results. Set the value of this parameter to null on your first
     *         call to the list action. For subsequent calls to the action, fill nextToken in the request with the value
     *         of NextToken from the previous response to continue listing data.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(findingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(sortCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingsRequest)) {
            return false;
        }
        ListFindingsRequest other = (ListFindingsRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(findingCriteria(), other.findingCriteria())
                && Objects.equals(sortCriteria(), other.sortCriteria()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFindingsRequest").add("DetectorId", detectorId()).add("FindingCriteria", findingCriteria())
                .add("SortCriteria", sortCriteria()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "FindingCriteria":
            return Optional.ofNullable(clazz.cast(findingCriteria()));
        case "SortCriteria":
            return Optional.ofNullable(clazz.cast(sortCriteria()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFindingsRequest, T> g) {
        return obj -> g.apply((ListFindingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListFindingsRequest> {
        /**
         * <p>
         * The ID of the detector that specifies the GuardDuty service whose findings you want to list.
         * </p>
         * 
         * @param detectorId
         *        The ID of the detector that specifies the GuardDuty service whose findings you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * Represents the criteria used for querying findings. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * JSON field name
         * </p>
         * </li>
         * <li>
         * <p>
         * accountId
         * </p>
         * </li>
         * <li>
         * <p>
         * region
         * </p>
         * </li>
         * <li>
         * <p>
         * confidence
         * </p>
         * </li>
         * <li>
         * <p>
         * id
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.accessKeyDetails.accessKeyId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.accessKeyDetails.principalId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.accessKeyDetails.userName
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.accessKeyDetails.userType
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.iamInstanceProfile.id
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.imageId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.instanceId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.ipv6Addresses
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.publicDnsName
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.publicIp
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.securityGroups.groupId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.securityGroups.groupName
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.subnetId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.vpcId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.tags.key
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.tags.value
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.resourceType
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.actionType
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.api
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.callerType
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.city.cityName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.country.countryName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.organization.asn
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.serviceName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.dnsRequestAction.domain
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.dnsRequestAction.domainWithSuffix
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.blocked
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.connectionDirection
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.localPortDetails.port
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.protocol
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remoteIpDetails.country.countryName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remoteIpDetails.organization.asn
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remotePortDetails.port
         * </p>
         * </li>
         * <li>
         * <p>
         * service.additionalInfo.threatListName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.archived
         * </p>
         * <p>
         * When this attribute is set to 'true', only archived findings are listed. When it's set to 'false', only
         * unarchived findings are listed. When this attribute is not set, all existing findings are listed.
         * </p>
         * </li>
         * <li>
         * <p>
         * service.ebsVolumeScanDetails.scanId
         * </p>
         * </li>
         * <li>
         * <p>
         * service.resourceRole
         * </p>
         * </li>
         * <li>
         * <p>
         * severity
         * </p>
         * </li>
         * <li>
         * <p>
         * type
         * </p>
         * </li>
         * <li>
         * <p>
         * updatedAt
         * </p>
         * <p>
         * Type: Timestamp in Unix Epoch millisecond format: 1486685375000
         * </p>
         * </li>
         * </ul>
         * 
         * @param findingCriteria
         *        Represents the criteria used for querying findings. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        JSON field name
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        accountId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        region
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        confidence
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        id
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.accessKeyDetails.accessKeyId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.accessKeyDetails.principalId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.accessKeyDetails.userName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.accessKeyDetails.userType
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.iamInstanceProfile.id
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.imageId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.instanceId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.networkInterfaces.ipv6Addresses
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.networkInterfaces.publicDnsName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.networkInterfaces.publicIp
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.networkInterfaces.securityGroups.groupId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.networkInterfaces.securityGroups.groupName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.networkInterfaces.subnetId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.networkInterfaces.vpcId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.tags.key
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.instanceDetails.tags.value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resource.resourceType
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.actionType
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.awsApiCallAction.api
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.awsApiCallAction.callerType
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.awsApiCallAction.remoteIpDetails.city.cityName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.awsApiCallAction.remoteIpDetails.country.countryName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.awsApiCallAction.remoteIpDetails.organization.asn
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.awsApiCallAction.serviceName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.dnsRequestAction.domain
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.dnsRequestAction.domainWithSuffix
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.blocked
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.connectionDirection
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.localPortDetails.port
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.protocol
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.remoteIpDetails.country.countryName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.remoteIpDetails.organization.asn
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.action.networkConnectionAction.remotePortDetails.port
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.additionalInfo.threatListName
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.archived
         *        </p>
         *        <p>
         *        When this attribute is set to 'true', only archived findings are listed. When it's set to 'false',
         *        only unarchived findings are listed. When this attribute is not set, all existing findings are listed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.ebsVolumeScanDetails.scanId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        service.resourceRole
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        severity
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        type
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        updatedAt
         *        </p>
         *        <p>
         *        Type: Timestamp in Unix Epoch millisecond format: 1486685375000
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingCriteria(FindingCriteria findingCriteria);

        /**
         * <p>
         * Represents the criteria used for querying findings. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * JSON field name
         * </p>
         * </li>
         * <li>
         * <p>
         * accountId
         * </p>
         * </li>
         * <li>
         * <p>
         * region
         * </p>
         * </li>
         * <li>
         * <p>
         * confidence
         * </p>
         * </li>
         * <li>
         * <p>
         * id
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.accessKeyDetails.accessKeyId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.accessKeyDetails.principalId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.accessKeyDetails.userName
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.accessKeyDetails.userType
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.iamInstanceProfile.id
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.imageId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.instanceId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.ipv6Addresses
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.publicDnsName
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.publicIp
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.securityGroups.groupId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.securityGroups.groupName
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.subnetId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.networkInterfaces.vpcId
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.tags.key
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.instanceDetails.tags.value
         * </p>
         * </li>
         * <li>
         * <p>
         * resource.resourceType
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.actionType
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.api
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.callerType
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.city.cityName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.country.countryName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.organization.asn
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.awsApiCallAction.serviceName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.dnsRequestAction.domain
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.dnsRequestAction.domainWithSuffix
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.blocked
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.connectionDirection
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.localPortDetails.port
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.protocol
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remoteIpDetails.country.countryName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remoteIpDetails.organization.asn
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
         * </p>
         * </li>
         * <li>
         * <p>
         * service.action.networkConnectionAction.remotePortDetails.port
         * </p>
         * </li>
         * <li>
         * <p>
         * service.additionalInfo.threatListName
         * </p>
         * </li>
         * <li>
         * <p>
         * service.archived
         * </p>
         * <p>
         * When this attribute is set to 'true', only archived findings are listed. When it's set to 'false', only
         * unarchived findings are listed. When this attribute is not set, all existing findings are listed.
         * </p>
         * </li>
         * <li>
         * <p>
         * service.ebsVolumeScanDetails.scanId
         * </p>
         * </li>
         * <li>
         * <p>
         * service.resourceRole
         * </p>
         * </li>
         * <li>
         * <p>
         * severity
         * </p>
         * </li>
         * <li>
         * <p>
         * type
         * </p>
         * </li>
         * <li>
         * <p>
         * updatedAt
         * </p>
         * <p>
         * Type: Timestamp in Unix Epoch millisecond format: 1486685375000
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link FindingCriteria.Builder} avoiding the
         * need to create one manually via {@link FindingCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FindingCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #findingCriteria(FindingCriteria)}.
         * 
         * @param findingCriteria
         *        a consumer that will call methods on {@link FindingCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingCriteria(FindingCriteria)
         */
        default Builder findingCriteria(Consumer<FindingCriteria.Builder> findingCriteria) {
            return findingCriteria(FindingCriteria.builder().applyMutation(findingCriteria).build());
        }

        /**
         * <p>
         * Represents the criteria used for sorting findings.
         * </p>
         * 
         * @param sortCriteria
         *        Represents the criteria used for sorting findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCriteria(SortCriteria sortCriteria);

        /**
         * <p>
         * Represents the criteria used for sorting findings.
         * </p>
         * This is a convenience method that creates an instance of the {@link SortCriteria.Builder} avoiding the need
         * to create one manually via {@link SortCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SortCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #sortCriteria(SortCriteria)}.
         * 
         * @param sortCriteria
         *        a consumer that will call methods on {@link SortCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortCriteria(SortCriteria)
         */
        default Builder sortCriteria(Consumer<SortCriteria.Builder> sortCriteria) {
            return sortCriteria(SortCriteria.builder().applyMutation(sortCriteria).build());
        }

        /**
         * <p>
         * You can use this parameter to indicate the maximum number of items you want in the response. The default
         * value is 50. The maximum value is 50.
         * </p>
         * 
         * @param maxResults
         *        You can use this parameter to indicate the maximum number of items you want in the response. The
         *        default value is 50. The maximum value is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * You can use this parameter when paginating results. Set the value of this parameter to null on your first
         * call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of
         * NextToken from the previous response to continue listing data.
         * </p>
         * 
         * @param nextToken
         *        You can use this parameter when paginating results. Set the value of this parameter to null on your
         *        first call to the list action. For subsequent calls to the action, fill nextToken in the request with
         *        the value of NextToken from the previous response to continue listing data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private FindingCriteria findingCriteria;

        private SortCriteria sortCriteria;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingsRequest model) {
            super(model);
            detectorId(model.detectorId);
            findingCriteria(model.findingCriteria);
            sortCriteria(model.sortCriteria);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final FindingCriteria.Builder getFindingCriteria() {
            return findingCriteria != null ? findingCriteria.toBuilder() : null;
        }

        public final void setFindingCriteria(FindingCriteria.BuilderImpl findingCriteria) {
            this.findingCriteria = findingCriteria != null ? findingCriteria.build() : null;
        }

        @Override
        public final Builder findingCriteria(FindingCriteria findingCriteria) {
            this.findingCriteria = findingCriteria;
            return this;
        }

        public final SortCriteria.Builder getSortCriteria() {
            return sortCriteria != null ? sortCriteria.toBuilder() : null;
        }

        public final void setSortCriteria(SortCriteria.BuilderImpl sortCriteria) {
            this.sortCriteria = sortCriteria != null ? sortCriteria.build() : null;
        }

        @Override
        public final Builder sortCriteria(SortCriteria sortCriteria) {
            this.sortCriteria = sortCriteria;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFindingsRequest build() {
            return new ListFindingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
