/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.HostPath;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Volume
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Volume> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Volume.getter(Volume::name)).setter(Volume.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<HostPath> HOST_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HostPath").getter(Volume.getter(Volume::hostPath)).setter(Volume.setter(Builder::hostPath)).constructor(HostPath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, HOST_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("hostPath", HOST_PATH_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final HostPath hostPath;

    private Volume(BuilderImpl builder) {
        this.name = builder.name;
        this.hostPath = builder.hostPath;
    }

    public final String name() {
        return this.name;
    }

    public final HostPath hostPath() {
        return this.hostPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.hostPath(), other.hostPath());
    }

    public final String toString() {
        return ToString.builder((String)"Volume").add("Name", (Object)this.name()).add("HostPath", (Object)this.hostPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "HostPath": {
                return Optional.ofNullable(clazz.cast(this.hostPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Volume, T> g) {
        return obj -> g.apply((Volume)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private HostPath hostPath;

        private BuilderImpl() {
        }

        private BuilderImpl(Volume model) {
            this.name(model.name);
            this.hostPath(model.hostPath);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final HostPath.Builder getHostPath() {
            return this.hostPath != null ? this.hostPath.toBuilder() : null;
        }

        public final void setHostPath(HostPath.BuilderImpl hostPath) {
            this.hostPath = hostPath != null ? hostPath.build() : null;
        }

        @Override
        public final Builder hostPath(HostPath hostPath) {
            this.hostPath = hostPath;
            return this;
        }

        public Volume build() {
            return new Volume(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Volume> {
        public Builder name(String var1);

        public Builder hostPath(HostPath var1);

        default public Builder hostPath(Consumer<HostPath.Builder> hostPath) {
            return this.hostPath((HostPath)((HostPath.Builder)HostPath.builder().applyMutation(hostPath)).build());
        }
    }
}

