/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.Ipv6AddressesCopier;
import software.amazon.awssdk.services.guardduty.model.PrivateIpAddressDetails;
import software.amazon.awssdk.services.guardduty.model.PrivateIpAddressesCopier;
import software.amazon.awssdk.services.guardduty.model.SecurityGroup;
import software.amazon.awssdk.services.guardduty.model.SecurityGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ec2NetworkInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ec2NetworkInterface> {
    private static final SdkField<List<String>> IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Addresses").getter(Ec2NetworkInterface.getter(Ec2NetworkInterface::ipv6Addresses)).setter(Ec2NetworkInterface.setter(Builder::ipv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv6Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PrivateIpAddressDetails>> PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrivateIpAddresses").getter(Ec2NetworkInterface.getter(Ec2NetworkInterface::privateIpAddresses)).setter(Ec2NetworkInterface.setter(Builder::privateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateIpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrivateIpAddressDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIp").getter(Ec2NetworkInterface.getter(Ec2NetworkInterface::publicIp)).setter(Ec2NetworkInterface.setter(Builder::publicIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicIp").build()}).build();
    private static final SdkField<List<SecurityGroup>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(Ec2NetworkInterface.getter(Ec2NetworkInterface::securityGroups)).setter(Ec2NetworkInterface.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUB_NET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubNetId").getter(Ec2NetworkInterface.getter(Ec2NetworkInterface::subNetId)).setter(Ec2NetworkInterface.setter(Builder::subNetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subNetId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(Ec2NetworkInterface.getter(Ec2NetworkInterface::vpcId)).setter(Ec2NetworkInterface.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_ADDRESSES_FIELD, PRIVATE_IP_ADDRESSES_FIELD, PUBLIC_IP_FIELD, SECURITY_GROUPS_FIELD, SUB_NET_ID_FIELD, VPC_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ipv6Addresses", IPV6_ADDRESSES_FIELD);
            this.put("privateIpAddresses", PRIVATE_IP_ADDRESSES_FIELD);
            this.put("publicIp", PUBLIC_IP_FIELD);
            this.put("securityGroups", SECURITY_GROUPS_FIELD);
            this.put("subNetId", SUB_NET_ID_FIELD);
            this.put("vpcId", VPC_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> ipv6Addresses;
    private final List<PrivateIpAddressDetails> privateIpAddresses;
    private final String publicIp;
    private final List<SecurityGroup> securityGroups;
    private final String subNetId;
    private final String vpcId;

    private Ec2NetworkInterface(BuilderImpl builder) {
        this.ipv6Addresses = builder.ipv6Addresses;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.publicIp = builder.publicIp;
        this.securityGroups = builder.securityGroups;
        this.subNetId = builder.subNetId;
        this.vpcId = builder.vpcId;
    }

    public final boolean hasIpv6Addresses() {
        return this.ipv6Addresses != null && !(this.ipv6Addresses instanceof SdkAutoConstructList);
    }

    public final List<String> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public final boolean hasPrivateIpAddresses() {
        return this.privateIpAddresses != null && !(this.privateIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<PrivateIpAddressDetails> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public final String publicIp() {
        return this.publicIp;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<SecurityGroup> securityGroups() {
        return this.securityGroups;
    }

    public final String subNetId() {
        return this.subNetId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Addresses() ? this.ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subNetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2NetworkInterface)) {
            return false;
        }
        Ec2NetworkInterface other = (Ec2NetworkInterface)obj;
        return this.hasIpv6Addresses() == other.hasIpv6Addresses() && Objects.equals(this.ipv6Addresses(), other.ipv6Addresses()) && this.hasPrivateIpAddresses() == other.hasPrivateIpAddresses() && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses()) && Objects.equals(this.publicIp(), other.publicIp()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.subNetId(), other.subNetId()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"Ec2NetworkInterface").add("Ipv6Addresses", this.hasIpv6Addresses() ? this.ipv6Addresses() : null).add("PrivateIpAddresses", this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null).add("PublicIp", (Object)this.publicIp()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("SubNetId", (Object)this.subNetId()).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ipv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv6Addresses()));
            }
            case "PrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddresses()));
            }
            case "PublicIp": {
                return Optional.ofNullable(clazz.cast(this.publicIp()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "SubNetId": {
                return Optional.ofNullable(clazz.cast(this.subNetId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Ec2NetworkInterface, T> g) {
        return obj -> g.apply((Ec2NetworkInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private List<PrivateIpAddressDetails> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private String publicIp;
        private List<SecurityGroup> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String subNetId;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2NetworkInterface model) {
            this.ipv6Addresses(model.ipv6Addresses);
            this.privateIpAddresses(model.privateIpAddresses);
            this.publicIp(model.publicIp);
            this.securityGroups(model.securityGroups);
            this.subNetId(model.subNetId);
            this.vpcId(model.vpcId);
        }

        public final Collection<String> getIpv6Addresses() {
            if (this.ipv6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipv6Addresses;
        }

        public final void setIpv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressesCopier.copy(ipv6Addresses);
        }

        @Override
        public final Builder ipv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressesCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(String ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final List<PrivateIpAddressDetails.Builder> getPrivateIpAddresses() {
            List<PrivateIpAddressDetails.Builder> result = PrivateIpAddressesCopier.copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpAddresses(Collection<PrivateIpAddressDetails.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressesCopier.copyFromBuilder(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<PrivateIpAddressDetails> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressesCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(PrivateIpAddressDetails ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<PrivateIpAddressDetails.Builder> ... privateIpAddresses) {
            this.privateIpAddresses(Stream.of(privateIpAddresses).map(c -> (PrivateIpAddressDetails)((PrivateIpAddressDetails.Builder)PrivateIpAddressDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final List<SecurityGroup.Builder> getSecurityGroups() {
            List<SecurityGroup.Builder> result = SecurityGroupsCopier.copyToBuilder(this.securityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroups(Collection<SecurityGroup.BuilderImpl> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copyFromBuilder(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<SecurityGroup> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(SecurityGroup ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<SecurityGroup.Builder> ... securityGroups) {
            this.securityGroups(Stream.of(securityGroups).map(c -> (SecurityGroup)((SecurityGroup.Builder)SecurityGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSubNetId() {
            return this.subNetId;
        }

        public final void setSubNetId(String subNetId) {
            this.subNetId = subNetId;
        }

        @Override
        public final Builder subNetId(String subNetId) {
            this.subNetId = subNetId;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public Ec2NetworkInterface build() {
            return new Ec2NetworkInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ec2NetworkInterface> {
        public Builder ipv6Addresses(Collection<String> var1);

        public Builder ipv6Addresses(String ... var1);

        public Builder privateIpAddresses(Collection<PrivateIpAddressDetails> var1);

        public Builder privateIpAddresses(PrivateIpAddressDetails ... var1);

        public Builder privateIpAddresses(Consumer<PrivateIpAddressDetails.Builder> ... var1);

        public Builder publicIp(String var1);

        public Builder securityGroups(Collection<SecurityGroup> var1);

        public Builder securityGroups(SecurityGroup ... var1);

        public Builder securityGroups(Consumer<SecurityGroup.Builder> ... var1);

        public Builder subNetId(String var1);

        public Builder vpcId(String var1);
    }
}

