/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the Autonomous System (AS) associated with the network endpoints involved in an attack
 * sequence.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutonomousSystem implements SdkPojo, Serializable,
        ToCopyableBuilder<AutonomousSystem.Builder, AutonomousSystem> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AutonomousSystem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Number").getter(getter(AutonomousSystem::number)).setter(setter(Builder::number))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("number").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer number;

    private AutonomousSystem(BuilderImpl builder) {
        this.name = builder.name;
        this.number = builder.number;
    }

    /**
     * <p>
     * Name associated with the Autonomous System (AS).
     * </p>
     * 
     * @return Name associated with the Autonomous System (AS).
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique number that identifies the Autonomous System (AS).
     * </p>
     * 
     * @return The unique number that identifies the Autonomous System (AS).
     */
    public final Integer number() {
        return number;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(number());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutonomousSystem)) {
            return false;
        }
        AutonomousSystem other = (AutonomousSystem) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(number(), other.number());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutonomousSystem").add("Name", name()).add("Number", number()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Number":
            return Optional.ofNullable(clazz.cast(number()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("number", NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutonomousSystem, T> g) {
        return obj -> g.apply((AutonomousSystem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutonomousSystem> {
        /**
         * <p>
         * Name associated with the Autonomous System (AS).
         * </p>
         * 
         * @param name
         *        Name associated with the Autonomous System (AS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique number that identifies the Autonomous System (AS).
         * </p>
         * 
         * @param number
         *        The unique number that identifies the Autonomous System (AS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder number(Integer number);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer number;

        private BuilderImpl() {
        }

        private BuilderImpl(AutonomousSystem model) {
            name(model.name);
            number(model.number);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getNumber() {
            return number;
        }

        public final void setNumber(Integer number) {
            this.number = number;
        }

        @Override
        public final Builder number(Integer number) {
            this.number = number;
            return this;
        }

        @Override
        public AutonomousSystem build() {
            return new AutonomousSystem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
