/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the DNS_REQUEST action described in this finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DnsRequestAction implements SdkPojo, Serializable,
        ToCopyableBuilder<DnsRequestAction.Builder, DnsRequestAction> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(DnsRequestAction::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(DnsRequestAction::protocol)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<Boolean> BLOCKED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Blocked").getter(getter(DnsRequestAction::blocked)).setter(setter(Builder::blocked))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blocked").build()).build();

    private static final SdkField<String> DOMAIN_WITH_SUFFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainWithSuffix").getter(getter(DnsRequestAction::domainWithSuffix))
            .setter(setter(Builder::domainWithSuffix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainWithSuffix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, PROTOCOL_FIELD,
            BLOCKED_FIELD, DOMAIN_WITH_SUFFIX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domain;

    private final String protocol;

    private final Boolean blocked;

    private final String domainWithSuffix;

    private DnsRequestAction(BuilderImpl builder) {
        this.domain = builder.domain;
        this.protocol = builder.protocol;
        this.blocked = builder.blocked;
        this.domainWithSuffix = builder.domainWithSuffix;
    }

    /**
     * <p>
     * The domain information for the DNS query.
     * </p>
     * 
     * @return The domain information for the DNS query.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The network connection protocol observed in the activity that prompted GuardDuty to generate the finding.
     * </p>
     * 
     * @return The network connection protocol observed in the activity that prompted GuardDuty to generate the finding.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * Indicates whether the targeted port is blocked.
     * </p>
     * 
     * @return Indicates whether the targeted port is blocked.
     */
    public final Boolean blocked() {
        return blocked;
    }

    /**
     * <p>
     * The second and top level domain involved in the activity that potentially prompted GuardDuty to generate this
     * finding. For a list of top-level and second-level domains, see <a href="https://publicsuffix.org/">public suffix
     * list</a>.
     * </p>
     * 
     * @return The second and top level domain involved in the activity that potentially prompted GuardDuty to generate
     *         this finding. For a list of top-level and second-level domains, see <a
     *         href="https://publicsuffix.org/">public suffix list</a>.
     */
    public final String domainWithSuffix() {
        return domainWithSuffix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(blocked());
        hashCode = 31 * hashCode + Objects.hashCode(domainWithSuffix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsRequestAction)) {
            return false;
        }
        DnsRequestAction other = (DnsRequestAction) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(blocked(), other.blocked()) && Objects.equals(domainWithSuffix(), other.domainWithSuffix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DnsRequestAction").add("Domain", domain()).add("Protocol", protocol()).add("Blocked", blocked())
                .add("DomainWithSuffix", domainWithSuffix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "Blocked":
            return Optional.ofNullable(clazz.cast(blocked()));
        case "DomainWithSuffix":
            return Optional.ofNullable(clazz.cast(domainWithSuffix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domain", DOMAIN_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("blocked", BLOCKED_FIELD);
        map.put("domainWithSuffix", DOMAIN_WITH_SUFFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DnsRequestAction, T> g) {
        return obj -> g.apply((DnsRequestAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DnsRequestAction> {
        /**
         * <p>
         * The domain information for the DNS query.
         * </p>
         * 
         * @param domain
         *        The domain information for the DNS query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The network connection protocol observed in the activity that prompted GuardDuty to generate the finding.
         * </p>
         * 
         * @param protocol
         *        The network connection protocol observed in the activity that prompted GuardDuty to generate the
         *        finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * Indicates whether the targeted port is blocked.
         * </p>
         * 
         * @param blocked
         *        Indicates whether the targeted port is blocked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocked(Boolean blocked);

        /**
         * <p>
         * The second and top level domain involved in the activity that potentially prompted GuardDuty to generate this
         * finding. For a list of top-level and second-level domains, see <a href="https://publicsuffix.org/">public
         * suffix list</a>.
         * </p>
         * 
         * @param domainWithSuffix
         *        The second and top level domain involved in the activity that potentially prompted GuardDuty to
         *        generate this finding. For a list of top-level and second-level domains, see <a
         *        href="https://publicsuffix.org/">public suffix list</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainWithSuffix(String domainWithSuffix);
    }

    static final class BuilderImpl implements Builder {
        private String domain;

        private String protocol;

        private Boolean blocked;

        private String domainWithSuffix;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsRequestAction model) {
            domain(model.domain);
            protocol(model.protocol);
            blocked(model.blocked);
            domainWithSuffix(model.domainWithSuffix);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final Boolean getBlocked() {
            return blocked;
        }

        public final void setBlocked(Boolean blocked) {
            this.blocked = blocked;
        }

        @Override
        public final Builder blocked(Boolean blocked) {
            this.blocked = blocked;
            return this;
        }

        public final String getDomainWithSuffix() {
            return domainWithSuffix;
        }

        public final void setDomainWithSuffix(String domainWithSuffix) {
            this.domainWithSuffix = domainWithSuffix;
        }

        @Override
        public final Builder domainWithSuffix(String domainWithSuffix) {
            this.domainWithSuffix = domainWithSuffix;
            return this;
        }

        @Override
        public DnsRequestAction build() {
            return new DnsRequestAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
