/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about Amazon Web Services Fargate details associated with an Amazon ECS cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FargateDetails implements SdkPojo, Serializable, ToCopyableBuilder<FargateDetails.Builder, FargateDetails> {
    private static final SdkField<List<String>> ISSUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Issues")
            .getter(getter(FargateDetails::issues))
            .setter(setter(Builder::issues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MANAGEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagementType").getter(getter(FargateDetails::managementTypeAsString))
            .setter(setter(Builder::managementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managementType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUES_FIELD,
            MANAGEMENT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> issues;

    private final String managementType;

    private FargateDetails(BuilderImpl builder) {
        this.issues = builder.issues;
        this.managementType = builder.managementType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Issues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIssues() {
        return issues != null && !(issues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Runtime coverage issues identified for the resource running on Amazon Web Services Fargate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIssues} method.
     * </p>
     * 
     * @return Runtime coverage issues identified for the resource running on Amazon Web Services Fargate.
     */
    public final List<String> issues() {
        return issues;
    }

    /**
     * <p>
     * Indicates how the GuardDuty security agent is managed for this resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AUTO_MANAGED</code> indicates that GuardDuty deploys and manages updates for this resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> indicates that the deployment of the GuardDuty security agent is disabled for this
     * resource.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>MANUAL</code> status doesn't apply to the Amazon Web Services Fargate (Amazon ECS only) woprkloads.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #managementType}
     * will return {@link ManagementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #managementTypeAsString}.
     * </p>
     * 
     * @return Indicates how the GuardDuty security agent is managed for this resource.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AUTO_MANAGED</code> indicates that GuardDuty deploys and manages updates for this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> indicates that the deployment of the GuardDuty security agent is disabled for this
     *         resource.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>MANUAL</code> status doesn't apply to the Amazon Web Services Fargate (Amazon ECS only)
     *         woprkloads.
     *         </p>
     * @see ManagementType
     */
    public final ManagementType managementType() {
        return ManagementType.fromValue(managementType);
    }

    /**
     * <p>
     * Indicates how the GuardDuty security agent is managed for this resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AUTO_MANAGED</code> indicates that GuardDuty deploys and manages updates for this resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> indicates that the deployment of the GuardDuty security agent is disabled for this
     * resource.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>MANUAL</code> status doesn't apply to the Amazon Web Services Fargate (Amazon ECS only) woprkloads.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #managementType}
     * will return {@link ManagementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #managementTypeAsString}.
     * </p>
     * 
     * @return Indicates how the GuardDuty security agent is managed for this resource.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AUTO_MANAGED</code> indicates that GuardDuty deploys and manages updates for this resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> indicates that the deployment of the GuardDuty security agent is disabled for this
     *         resource.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>MANUAL</code> status doesn't apply to the Amazon Web Services Fargate (Amazon ECS only)
     *         woprkloads.
     *         </p>
     * @see ManagementType
     */
    public final String managementTypeAsString() {
        return managementType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIssues() ? issues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(managementTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FargateDetails)) {
            return false;
        }
        FargateDetails other = (FargateDetails) obj;
        return hasIssues() == other.hasIssues() && Objects.equals(issues(), other.issues())
                && Objects.equals(managementTypeAsString(), other.managementTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FargateDetails").add("Issues", hasIssues() ? issues() : null)
                .add("ManagementType", managementTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Issues":
            return Optional.ofNullable(clazz.cast(issues()));
        case "ManagementType":
            return Optional.ofNullable(clazz.cast(managementTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("issues", ISSUES_FIELD);
        map.put("managementType", MANAGEMENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FargateDetails, T> g) {
        return obj -> g.apply((FargateDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FargateDetails> {
        /**
         * <p>
         * Runtime coverage issues identified for the resource running on Amazon Web Services Fargate.
         * </p>
         * 
         * @param issues
         *        Runtime coverage issues identified for the resource running on Amazon Web Services Fargate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issues(Collection<String> issues);

        /**
         * <p>
         * Runtime coverage issues identified for the resource running on Amazon Web Services Fargate.
         * </p>
         * 
         * @param issues
         *        Runtime coverage issues identified for the resource running on Amazon Web Services Fargate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issues(String... issues);

        /**
         * <p>
         * Indicates how the GuardDuty security agent is managed for this resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AUTO_MANAGED</code> indicates that GuardDuty deploys and manages updates for this resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> indicates that the deployment of the GuardDuty security agent is disabled for this
         * resource.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>MANUAL</code> status doesn't apply to the Amazon Web Services Fargate (Amazon ECS only) woprkloads.
         * </p>
         * </note>
         * 
         * @param managementType
         *        Indicates how the GuardDuty security agent is managed for this resource.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AUTO_MANAGED</code> indicates that GuardDuty deploys and manages updates for this resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> indicates that the deployment of the GuardDuty security agent is disabled for
         *        this resource.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>MANUAL</code> status doesn't apply to the Amazon Web Services Fargate (Amazon ECS only)
         *        woprkloads.
         *        </p>
         * @see ManagementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagementType
         */
        Builder managementType(String managementType);

        /**
         * <p>
         * Indicates how the GuardDuty security agent is managed for this resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AUTO_MANAGED</code> indicates that GuardDuty deploys and manages updates for this resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> indicates that the deployment of the GuardDuty security agent is disabled for this
         * resource.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>MANUAL</code> status doesn't apply to the Amazon Web Services Fargate (Amazon ECS only) woprkloads.
         * </p>
         * </note>
         * 
         * @param managementType
         *        Indicates how the GuardDuty security agent is managed for this resource.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AUTO_MANAGED</code> indicates that GuardDuty deploys and manages updates for this resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> indicates that the deployment of the GuardDuty security agent is disabled for
         *        this resource.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>MANUAL</code> status doesn't apply to the Amazon Web Services Fargate (Amazon ECS only)
         *        woprkloads.
         *        </p>
         * @see ManagementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagementType
         */
        Builder managementType(ManagementType managementType);
    }

    static final class BuilderImpl implements Builder {
        private List<String> issues = DefaultSdkAutoConstructList.getInstance();

        private String managementType;

        private BuilderImpl() {
        }

        private BuilderImpl(FargateDetails model) {
            issues(model.issues);
            managementType(model.managementType);
        }

        public final Collection<String> getIssues() {
            if (issues instanceof SdkAutoConstructList) {
                return null;
            }
            return issues;
        }

        public final void setIssues(Collection<String> issues) {
            this.issues = IssuesCopier.copy(issues);
        }

        @Override
        public final Builder issues(Collection<String> issues) {
            this.issues = IssuesCopier.copy(issues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issues(String... issues) {
            issues(Arrays.asList(issues));
            return this;
        }

        public final String getManagementType() {
            return managementType;
        }

        public final void setManagementType(String managementType) {
            this.managementType = managementType;
        }

        @Override
        public final Builder managementType(String managementType) {
            this.managementType = managementType;
            return this;
        }

        @Override
        public final Builder managementType(ManagementType managementType) {
            this.managementType(managementType == null ? null : managementType.toString());
            return this;
        }

        @Override
        public FargateDetails build() {
            return new FargateDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
