/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFindingsRequest extends GuardDutyRequest implements
        ToCopyableBuilder<GetFindingsRequest.Builder, GetFindingsRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(GetFindingsRequest::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<List<String>> FINDING_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FindingIds")
            .getter(getter(GetFindingsRequest::findingIds))
            .setter(setter(Builder::findingIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SortCriteria> SORT_CRITERIA_FIELD = SdkField.<SortCriteria> builder(MarshallingType.SDK_POJO)
            .memberName("SortCriteria").getter(getter(GetFindingsRequest::sortCriteria)).setter(setter(Builder::sortCriteria))
            .constructor(SortCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            FINDING_IDS_FIELD, SORT_CRITERIA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String detectorId;

    private final List<String> findingIds;

    private final SortCriteria sortCriteria;

    private GetFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.findingIds = builder.findingIds;
        this.sortCriteria = builder.sortCriteria;
    }

    /**
     * <p>
     * The ID of the detector that specifies the GuardDuty service whose findings you want to retrieve.
     * </p>
     * <p>
     * To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty console, or run
     * the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
     * API.
     * </p>
     * 
     * @return The ID of the detector that specifies the GuardDuty service whose findings you want to retrieve.</p>
     *         <p>
     *         To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty
     *         console, or run the <a
     *         href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
     *         API.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFindingIds() {
        return findingIds != null && !(findingIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the findings that you want to retrieve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingIds} method.
     * </p>
     * 
     * @return The IDs of the findings that you want to retrieve.
     */
    public final List<String> findingIds() {
        return findingIds;
    }

    /**
     * <p>
     * Represents the criteria used for sorting findings.
     * </p>
     * 
     * @return Represents the criteria used for sorting findings.
     */
    public final SortCriteria sortCriteria() {
        return sortCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingIds() ? findingIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sortCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingsRequest)) {
            return false;
        }
        GetFindingsRequest other = (GetFindingsRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && hasFindingIds() == other.hasFindingIds()
                && Objects.equals(findingIds(), other.findingIds()) && Objects.equals(sortCriteria(), other.sortCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFindingsRequest").add("DetectorId", detectorId())
                .add("FindingIds", hasFindingIds() ? findingIds() : null).add("SortCriteria", sortCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "FindingIds":
            return Optional.ofNullable(clazz.cast(findingIds()));
        case "SortCriteria":
            return Optional.ofNullable(clazz.cast(sortCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("findingIds", FINDING_IDS_FIELD);
        map.put("sortCriteria", SORT_CRITERIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFindingsRequest, T> g) {
        return obj -> g.apply((GetFindingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetFindingsRequest> {
        /**
         * <p>
         * The ID of the detector that specifies the GuardDuty service whose findings you want to retrieve.
         * </p>
         * <p>
         * To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty console, or
         * run the <a
         * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
         * API.
         * </p>
         * 
         * @param detectorId
         *        The ID of the detector that specifies the GuardDuty service whose findings you want to retrieve.</p>
         *        <p>
         *        To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty
         *        console, or run the <a
         *        href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html"
         *        >ListDetectors</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The IDs of the findings that you want to retrieve.
         * </p>
         * 
         * @param findingIds
         *        The IDs of the findings that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIds(Collection<String> findingIds);

        /**
         * <p>
         * The IDs of the findings that you want to retrieve.
         * </p>
         * 
         * @param findingIds
         *        The IDs of the findings that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIds(String... findingIds);

        /**
         * <p>
         * Represents the criteria used for sorting findings.
         * </p>
         * 
         * @param sortCriteria
         *        Represents the criteria used for sorting findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCriteria(SortCriteria sortCriteria);

        /**
         * <p>
         * Represents the criteria used for sorting findings.
         * </p>
         * This is a convenience method that creates an instance of the {@link SortCriteria.Builder} avoiding the need
         * to create one manually via {@link SortCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SortCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #sortCriteria(SortCriteria)}.
         * 
         * @param sortCriteria
         *        a consumer that will call methods on {@link SortCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortCriteria(SortCriteria)
         */
        default Builder sortCriteria(Consumer<SortCriteria.Builder> sortCriteria) {
            return sortCriteria(SortCriteria.builder().applyMutation(sortCriteria).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private List<String> findingIds = DefaultSdkAutoConstructList.getInstance();

        private SortCriteria sortCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingsRequest model) {
            super(model);
            detectorId(model.detectorId);
            findingIds(model.findingIds);
            sortCriteria(model.sortCriteria);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final Collection<String> getFindingIds() {
            if (findingIds instanceof SdkAutoConstructList) {
                return null;
            }
            return findingIds;
        }

        public final void setFindingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdsCopier.copy(findingIds);
        }

        @Override
        public final Builder findingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdsCopier.copy(findingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIds(String... findingIds) {
            findingIds(Arrays.asList(findingIds));
            return this;
        }

        public final SortCriteria.Builder getSortCriteria() {
            return sortCriteria != null ? sortCriteria.toBuilder() : null;
        }

        public final void setSortCriteria(SortCriteria.BuilderImpl sortCriteria) {
            this.sortCriteria = sortCriteria != null ? sortCriteria.build() : null;
        }

        @Override
        public final Builder sortCriteria(SortCriteria sortCriteria) {
            this.sortCriteria = sortCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFindingsRequest build() {
            return new GetFindingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
