/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInvitationsResponse extends GuardDutyResponse implements
        ToCopyableBuilder<ListInvitationsResponse.Builder, ListInvitationsResponse> {
    private static final SdkField<List<Invitation>> INVITATIONS_FIELD = SdkField
            .<List<Invitation>> builder(MarshallingType.LIST)
            .memberName("Invitations")
            .getter(getter(ListInvitationsResponse::invitations))
            .setter(setter(Builder::invitations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invitations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Invitation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Invitation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInvitationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVITATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Invitation> invitations;

    private final String nextToken;

    private ListInvitationsResponse(BuilderImpl builder) {
        super(builder);
        this.invitations = builder.invitations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Invitations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInvitations() {
        return invitations != null && !(invitations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of invitation descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvitations} method.
     * </p>
     * 
     * @return A list of invitation descriptions.
     */
    public final List<Invitation> invitations() {
        return invitations;
    }

    /**
     * <p>
     * The pagination parameter to be used on the next list operation to retrieve more items.
     * </p>
     * 
     * @return The pagination parameter to be used on the next list operation to retrieve more items.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInvitations() ? invitations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvitationsResponse)) {
            return false;
        }
        ListInvitationsResponse other = (ListInvitationsResponse) obj;
        return hasInvitations() == other.hasInvitations() && Objects.equals(invitations(), other.invitations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInvitationsResponse").add("Invitations", hasInvitations() ? invitations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Invitations":
            return Optional.ofNullable(clazz.cast(invitations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invitations", INVITATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInvitationsResponse, T> g) {
        return obj -> g.apply((ListInvitationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListInvitationsResponse> {
        /**
         * <p>
         * A list of invitation descriptions.
         * </p>
         * 
         * @param invitations
         *        A list of invitation descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitations(Collection<Invitation> invitations);

        /**
         * <p>
         * A list of invitation descriptions.
         * </p>
         * 
         * @param invitations
         *        A list of invitation descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitations(Invitation... invitations);

        /**
         * <p>
         * A list of invitation descriptions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.Invitation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.guardduty.model.Invitation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.Invitation.Builder#build()} is called immediately and
         * its result is passed to {@link #invitations(List<Invitation>)}.
         * 
         * @param invitations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.Invitation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invitations(java.util.Collection<Invitation>)
         */
        Builder invitations(Consumer<Invitation.Builder>... invitations);

        /**
         * <p>
         * The pagination parameter to be used on the next list operation to retrieve more items.
         * </p>
         * 
         * @param nextToken
         *        The pagination parameter to be used on the next list operation to retrieve more items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private List<Invitation> invitations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvitationsResponse model) {
            super(model);
            invitations(model.invitations);
            nextToken(model.nextToken);
        }

        public final List<Invitation.Builder> getInvitations() {
            List<Invitation.Builder> result = InvitationsCopier.copyToBuilder(this.invitations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvitations(Collection<Invitation.BuilderImpl> invitations) {
            this.invitations = InvitationsCopier.copyFromBuilder(invitations);
        }

        @Override
        public final Builder invitations(Collection<Invitation> invitations) {
            this.invitations = InvitationsCopier.copy(invitations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invitations(Invitation... invitations) {
            invitations(Arrays.asList(invitations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invitations(Consumer<Invitation.Builder>... invitations) {
            invitations(Stream.of(invitations).map(c -> Invitation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInvitationsResponse build() {
            return new ListInvitationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
