/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the login attempts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoginAttribute implements SdkPojo, Serializable, ToCopyableBuilder<LoginAttribute.Builder, LoginAttribute> {
    private static final SdkField<String> USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("User")
            .getter(getter(LoginAttribute::user)).setter(setter(Builder::user))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()).build();

    private static final SdkField<String> APPLICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Application").getter(getter(LoginAttribute::application)).setter(setter(Builder::application))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()).build();

    private static final SdkField<Integer> FAILED_LOGIN_ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FailedLoginAttempts").getter(getter(LoginAttribute::failedLoginAttempts))
            .setter(setter(Builder::failedLoginAttempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedLoginAttempts").build())
            .build();

    private static final SdkField<Integer> SUCCESSFUL_LOGIN_ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SuccessfulLoginAttempts").getter(getter(LoginAttribute::successfulLoginAttempts))
            .setter(setter(Builder::successfulLoginAttempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successfulLoginAttempts").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_FIELD, APPLICATION_FIELD,
            FAILED_LOGIN_ATTEMPTS_FIELD, SUCCESSFUL_LOGIN_ATTEMPTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String user;

    private final String application;

    private final Integer failedLoginAttempts;

    private final Integer successfulLoginAttempts;

    private LoginAttribute(BuilderImpl builder) {
        this.user = builder.user;
        this.application = builder.application;
        this.failedLoginAttempts = builder.failedLoginAttempts;
        this.successfulLoginAttempts = builder.successfulLoginAttempts;
    }

    /**
     * <p>
     * Indicates the user name which attempted to log in.
     * </p>
     * 
     * @return Indicates the user name which attempted to log in.
     */
    public final String user() {
        return user;
    }

    /**
     * <p>
     * Indicates the application name used to attempt log in.
     * </p>
     * 
     * @return Indicates the application name used to attempt log in.
     */
    public final String application() {
        return application;
    }

    /**
     * <p>
     * Represents the sum of failed (unsuccessful) login attempts made to establish a connection to the database
     * instance.
     * </p>
     * 
     * @return Represents the sum of failed (unsuccessful) login attempts made to establish a connection to the database
     *         instance.
     */
    public final Integer failedLoginAttempts() {
        return failedLoginAttempts;
    }

    /**
     * <p>
     * Represents the sum of successful connections (a correct combination of login attributes) made to the database
     * instance by the actor.
     * </p>
     * 
     * @return Represents the sum of successful connections (a correct combination of login attributes) made to the
     *         database instance by the actor.
     */
    public final Integer successfulLoginAttempts() {
        return successfulLoginAttempts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(application());
        hashCode = 31 * hashCode + Objects.hashCode(failedLoginAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(successfulLoginAttempts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoginAttribute)) {
            return false;
        }
        LoginAttribute other = (LoginAttribute) obj;
        return Objects.equals(user(), other.user()) && Objects.equals(application(), other.application())
                && Objects.equals(failedLoginAttempts(), other.failedLoginAttempts())
                && Objects.equals(successfulLoginAttempts(), other.successfulLoginAttempts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoginAttribute").add("User", user()).add("Application", application())
                .add("FailedLoginAttempts", failedLoginAttempts()).add("SuccessfulLoginAttempts", successfulLoginAttempts())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        case "Application":
            return Optional.ofNullable(clazz.cast(application()));
        case "FailedLoginAttempts":
            return Optional.ofNullable(clazz.cast(failedLoginAttempts()));
        case "SuccessfulLoginAttempts":
            return Optional.ofNullable(clazz.cast(successfulLoginAttempts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("user", USER_FIELD);
        map.put("application", APPLICATION_FIELD);
        map.put("failedLoginAttempts", FAILED_LOGIN_ATTEMPTS_FIELD);
        map.put("successfulLoginAttempts", SUCCESSFUL_LOGIN_ATTEMPTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoginAttribute, T> g) {
        return obj -> g.apply((LoginAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoginAttribute> {
        /**
         * <p>
         * Indicates the user name which attempted to log in.
         * </p>
         * 
         * @param user
         *        Indicates the user name which attempted to log in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(String user);

        /**
         * <p>
         * Indicates the application name used to attempt log in.
         * </p>
         * 
         * @param application
         *        Indicates the application name used to attempt log in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder application(String application);

        /**
         * <p>
         * Represents the sum of failed (unsuccessful) login attempts made to establish a connection to the database
         * instance.
         * </p>
         * 
         * @param failedLoginAttempts
         *        Represents the sum of failed (unsuccessful) login attempts made to establish a connection to the
         *        database instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedLoginAttempts(Integer failedLoginAttempts);

        /**
         * <p>
         * Represents the sum of successful connections (a correct combination of login attributes) made to the database
         * instance by the actor.
         * </p>
         * 
         * @param successfulLoginAttempts
         *        Represents the sum of successful connections (a correct combination of login attributes) made to the
         *        database instance by the actor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulLoginAttempts(Integer successfulLoginAttempts);
    }

    static final class BuilderImpl implements Builder {
        private String user;

        private String application;

        private Integer failedLoginAttempts;

        private Integer successfulLoginAttempts;

        private BuilderImpl() {
        }

        private BuilderImpl(LoginAttribute model) {
            user(model.user);
            application(model.application);
            failedLoginAttempts(model.failedLoginAttempts);
            successfulLoginAttempts(model.successfulLoginAttempts);
        }

        public final String getUser() {
            return user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final String getApplication() {
            return application;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final Integer getFailedLoginAttempts() {
            return failedLoginAttempts;
        }

        public final void setFailedLoginAttempts(Integer failedLoginAttempts) {
            this.failedLoginAttempts = failedLoginAttempts;
        }

        @Override
        public final Builder failedLoginAttempts(Integer failedLoginAttempts) {
            this.failedLoginAttempts = failedLoginAttempts;
            return this;
        }

        public final Integer getSuccessfulLoginAttempts() {
            return successfulLoginAttempts;
        }

        public final void setSuccessfulLoginAttempts(Integer successfulLoginAttempts) {
            this.successfulLoginAttempts = successfulLoginAttempts;
        }

        @Override
        public final Builder successfulLoginAttempts(Integer successfulLoginAttempts) {
            this.successfulLoginAttempts = successfulLoginAttempts;
            return this;
        }

        @Override
        public LoginAttribute build() {
            return new LoginAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
