/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the NETWORK_CONNECTION action described in the finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkConnectionAction implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkConnectionAction.Builder, NetworkConnectionAction> {
    private static final SdkField<Boolean> BLOCKED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Blocked").getter(getter(NetworkConnectionAction::blocked)).setter(setter(Builder::blocked))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blocked").build()).build();

    private static final SdkField<String> CONNECTION_DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionDirection").getter(getter(NetworkConnectionAction::connectionDirection))
            .setter(setter(Builder::connectionDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionDirection").build())
            .build();

    private static final SdkField<LocalPortDetails> LOCAL_PORT_DETAILS_FIELD = SdkField
            .<LocalPortDetails> builder(MarshallingType.SDK_POJO).memberName("LocalPortDetails")
            .getter(getter(NetworkConnectionAction::localPortDetails)).setter(setter(Builder::localPortDetails))
            .constructor(LocalPortDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localPortDetails").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(NetworkConnectionAction::protocol)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<LocalIpDetails> LOCAL_IP_DETAILS_FIELD = SdkField
            .<LocalIpDetails> builder(MarshallingType.SDK_POJO).memberName("LocalIpDetails")
            .getter(getter(NetworkConnectionAction::localIpDetails)).setter(setter(Builder::localIpDetails))
            .constructor(LocalIpDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localIpDetails").build()).build();

    private static final SdkField<String> LOCAL_NETWORK_INTERFACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocalNetworkInterface").getter(getter(NetworkConnectionAction::localNetworkInterface))
            .setter(setter(Builder::localNetworkInterface))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localNetworkInterface").build())
            .build();

    private static final SdkField<RemoteIpDetails> REMOTE_IP_DETAILS_FIELD = SdkField
            .<RemoteIpDetails> builder(MarshallingType.SDK_POJO).memberName("RemoteIpDetails")
            .getter(getter(NetworkConnectionAction::remoteIpDetails)).setter(setter(Builder::remoteIpDetails))
            .constructor(RemoteIpDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteIpDetails").build()).build();

    private static final SdkField<RemotePortDetails> REMOTE_PORT_DETAILS_FIELD = SdkField
            .<RemotePortDetails> builder(MarshallingType.SDK_POJO).memberName("RemotePortDetails")
            .getter(getter(NetworkConnectionAction::remotePortDetails)).setter(setter(Builder::remotePortDetails))
            .constructor(RemotePortDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remotePortDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCKED_FIELD,
            CONNECTION_DIRECTION_FIELD, LOCAL_PORT_DETAILS_FIELD, PROTOCOL_FIELD, LOCAL_IP_DETAILS_FIELD,
            LOCAL_NETWORK_INTERFACE_FIELD, REMOTE_IP_DETAILS_FIELD, REMOTE_PORT_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean blocked;

    private final String connectionDirection;

    private final LocalPortDetails localPortDetails;

    private final String protocol;

    private final LocalIpDetails localIpDetails;

    private final String localNetworkInterface;

    private final RemoteIpDetails remoteIpDetails;

    private final RemotePortDetails remotePortDetails;

    private NetworkConnectionAction(BuilderImpl builder) {
        this.blocked = builder.blocked;
        this.connectionDirection = builder.connectionDirection;
        this.localPortDetails = builder.localPortDetails;
        this.protocol = builder.protocol;
        this.localIpDetails = builder.localIpDetails;
        this.localNetworkInterface = builder.localNetworkInterface;
        this.remoteIpDetails = builder.remoteIpDetails;
        this.remotePortDetails = builder.remotePortDetails;
    }

    /**
     * <p>
     * Indicates whether EC2 blocked the network connection to your instance.
     * </p>
     * 
     * @return Indicates whether EC2 blocked the network connection to your instance.
     */
    public final Boolean blocked() {
        return blocked;
    }

    /**
     * <p>
     * The network connection direction.
     * </p>
     * 
     * @return The network connection direction.
     */
    public final String connectionDirection() {
        return connectionDirection;
    }

    /**
     * <p>
     * The local port information of the connection.
     * </p>
     * 
     * @return The local port information of the connection.
     */
    public final LocalPortDetails localPortDetails() {
        return localPortDetails;
    }

    /**
     * <p>
     * The network connection protocol.
     * </p>
     * 
     * @return The network connection protocol.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The local IP information of the connection.
     * </p>
     * 
     * @return The local IP information of the connection.
     */
    public final LocalIpDetails localIpDetails() {
        return localIpDetails;
    }

    /**
     * <p>
     * The EC2 instance's local elastic network interface utilized for the connection.
     * </p>
     * 
     * @return The EC2 instance's local elastic network interface utilized for the connection.
     */
    public final String localNetworkInterface() {
        return localNetworkInterface;
    }

    /**
     * <p>
     * The remote IP information of the connection.
     * </p>
     * 
     * @return The remote IP information of the connection.
     */
    public final RemoteIpDetails remoteIpDetails() {
        return remoteIpDetails;
    }

    /**
     * <p>
     * The remote port information of the connection.
     * </p>
     * 
     * @return The remote port information of the connection.
     */
    public final RemotePortDetails remotePortDetails() {
        return remotePortDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blocked());
        hashCode = 31 * hashCode + Objects.hashCode(connectionDirection());
        hashCode = 31 * hashCode + Objects.hashCode(localPortDetails());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(localIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(localNetworkInterface());
        hashCode = 31 * hashCode + Objects.hashCode(remoteIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(remotePortDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkConnectionAction)) {
            return false;
        }
        NetworkConnectionAction other = (NetworkConnectionAction) obj;
        return Objects.equals(blocked(), other.blocked()) && Objects.equals(connectionDirection(), other.connectionDirection())
                && Objects.equals(localPortDetails(), other.localPortDetails()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(localIpDetails(), other.localIpDetails())
                && Objects.equals(localNetworkInterface(), other.localNetworkInterface())
                && Objects.equals(remoteIpDetails(), other.remoteIpDetails())
                && Objects.equals(remotePortDetails(), other.remotePortDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkConnectionAction").add("Blocked", blocked())
                .add("ConnectionDirection", connectionDirection()).add("LocalPortDetails", localPortDetails())
                .add("Protocol", protocol()).add("LocalIpDetails", localIpDetails())
                .add("LocalNetworkInterface", localNetworkInterface()).add("RemoteIpDetails", remoteIpDetails())
                .add("RemotePortDetails", remotePortDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Blocked":
            return Optional.ofNullable(clazz.cast(blocked()));
        case "ConnectionDirection":
            return Optional.ofNullable(clazz.cast(connectionDirection()));
        case "LocalPortDetails":
            return Optional.ofNullable(clazz.cast(localPortDetails()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "LocalIpDetails":
            return Optional.ofNullable(clazz.cast(localIpDetails()));
        case "LocalNetworkInterface":
            return Optional.ofNullable(clazz.cast(localNetworkInterface()));
        case "RemoteIpDetails":
            return Optional.ofNullable(clazz.cast(remoteIpDetails()));
        case "RemotePortDetails":
            return Optional.ofNullable(clazz.cast(remotePortDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("blocked", BLOCKED_FIELD);
        map.put("connectionDirection", CONNECTION_DIRECTION_FIELD);
        map.put("localPortDetails", LOCAL_PORT_DETAILS_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("localIpDetails", LOCAL_IP_DETAILS_FIELD);
        map.put("localNetworkInterface", LOCAL_NETWORK_INTERFACE_FIELD);
        map.put("remoteIpDetails", REMOTE_IP_DETAILS_FIELD);
        map.put("remotePortDetails", REMOTE_PORT_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkConnectionAction, T> g) {
        return obj -> g.apply((NetworkConnectionAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkConnectionAction> {
        /**
         * <p>
         * Indicates whether EC2 blocked the network connection to your instance.
         * </p>
         * 
         * @param blocked
         *        Indicates whether EC2 blocked the network connection to your instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocked(Boolean blocked);

        /**
         * <p>
         * The network connection direction.
         * </p>
         * 
         * @param connectionDirection
         *        The network connection direction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionDirection(String connectionDirection);

        /**
         * <p>
         * The local port information of the connection.
         * </p>
         * 
         * @param localPortDetails
         *        The local port information of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localPortDetails(LocalPortDetails localPortDetails);

        /**
         * <p>
         * The local port information of the connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link LocalPortDetails.Builder} avoiding the
         * need to create one manually via {@link LocalPortDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LocalPortDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #localPortDetails(LocalPortDetails)}.
         * 
         * @param localPortDetails
         *        a consumer that will call methods on {@link LocalPortDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localPortDetails(LocalPortDetails)
         */
        default Builder localPortDetails(Consumer<LocalPortDetails.Builder> localPortDetails) {
            return localPortDetails(LocalPortDetails.builder().applyMutation(localPortDetails).build());
        }

        /**
         * <p>
         * The network connection protocol.
         * </p>
         * 
         * @param protocol
         *        The network connection protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The local IP information of the connection.
         * </p>
         * 
         * @param localIpDetails
         *        The local IP information of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localIpDetails(LocalIpDetails localIpDetails);

        /**
         * <p>
         * The local IP information of the connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link LocalIpDetails.Builder} avoiding the need
         * to create one manually via {@link LocalIpDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LocalIpDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #localIpDetails(LocalIpDetails)}.
         * 
         * @param localIpDetails
         *        a consumer that will call methods on {@link LocalIpDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localIpDetails(LocalIpDetails)
         */
        default Builder localIpDetails(Consumer<LocalIpDetails.Builder> localIpDetails) {
            return localIpDetails(LocalIpDetails.builder().applyMutation(localIpDetails).build());
        }

        /**
         * <p>
         * The EC2 instance's local elastic network interface utilized for the connection.
         * </p>
         * 
         * @param localNetworkInterface
         *        The EC2 instance's local elastic network interface utilized for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localNetworkInterface(String localNetworkInterface);

        /**
         * <p>
         * The remote IP information of the connection.
         * </p>
         * 
         * @param remoteIpDetails
         *        The remote IP information of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteIpDetails(RemoteIpDetails remoteIpDetails);

        /**
         * <p>
         * The remote IP information of the connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link RemoteIpDetails.Builder} avoiding the
         * need to create one manually via {@link RemoteIpDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RemoteIpDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #remoteIpDetails(RemoteIpDetails)}.
         * 
         * @param remoteIpDetails
         *        a consumer that will call methods on {@link RemoteIpDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteIpDetails(RemoteIpDetails)
         */
        default Builder remoteIpDetails(Consumer<RemoteIpDetails.Builder> remoteIpDetails) {
            return remoteIpDetails(RemoteIpDetails.builder().applyMutation(remoteIpDetails).build());
        }

        /**
         * <p>
         * The remote port information of the connection.
         * </p>
         * 
         * @param remotePortDetails
         *        The remote port information of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remotePortDetails(RemotePortDetails remotePortDetails);

        /**
         * <p>
         * The remote port information of the connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link RemotePortDetails.Builder} avoiding the
         * need to create one manually via {@link RemotePortDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RemotePortDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #remotePortDetails(RemotePortDetails)}.
         * 
         * @param remotePortDetails
         *        a consumer that will call methods on {@link RemotePortDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remotePortDetails(RemotePortDetails)
         */
        default Builder remotePortDetails(Consumer<RemotePortDetails.Builder> remotePortDetails) {
            return remotePortDetails(RemotePortDetails.builder().applyMutation(remotePortDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean blocked;

        private String connectionDirection;

        private LocalPortDetails localPortDetails;

        private String protocol;

        private LocalIpDetails localIpDetails;

        private String localNetworkInterface;

        private RemoteIpDetails remoteIpDetails;

        private RemotePortDetails remotePortDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkConnectionAction model) {
            blocked(model.blocked);
            connectionDirection(model.connectionDirection);
            localPortDetails(model.localPortDetails);
            protocol(model.protocol);
            localIpDetails(model.localIpDetails);
            localNetworkInterface(model.localNetworkInterface);
            remoteIpDetails(model.remoteIpDetails);
            remotePortDetails(model.remotePortDetails);
        }

        public final Boolean getBlocked() {
            return blocked;
        }

        public final void setBlocked(Boolean blocked) {
            this.blocked = blocked;
        }

        @Override
        public final Builder blocked(Boolean blocked) {
            this.blocked = blocked;
            return this;
        }

        public final String getConnectionDirection() {
            return connectionDirection;
        }

        public final void setConnectionDirection(String connectionDirection) {
            this.connectionDirection = connectionDirection;
        }

        @Override
        public final Builder connectionDirection(String connectionDirection) {
            this.connectionDirection = connectionDirection;
            return this;
        }

        public final LocalPortDetails.Builder getLocalPortDetails() {
            return localPortDetails != null ? localPortDetails.toBuilder() : null;
        }

        public final void setLocalPortDetails(LocalPortDetails.BuilderImpl localPortDetails) {
            this.localPortDetails = localPortDetails != null ? localPortDetails.build() : null;
        }

        @Override
        public final Builder localPortDetails(LocalPortDetails localPortDetails) {
            this.localPortDetails = localPortDetails;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final LocalIpDetails.Builder getLocalIpDetails() {
            return localIpDetails != null ? localIpDetails.toBuilder() : null;
        }

        public final void setLocalIpDetails(LocalIpDetails.BuilderImpl localIpDetails) {
            this.localIpDetails = localIpDetails != null ? localIpDetails.build() : null;
        }

        @Override
        public final Builder localIpDetails(LocalIpDetails localIpDetails) {
            this.localIpDetails = localIpDetails;
            return this;
        }

        public final String getLocalNetworkInterface() {
            return localNetworkInterface;
        }

        public final void setLocalNetworkInterface(String localNetworkInterface) {
            this.localNetworkInterface = localNetworkInterface;
        }

        @Override
        public final Builder localNetworkInterface(String localNetworkInterface) {
            this.localNetworkInterface = localNetworkInterface;
            return this;
        }

        public final RemoteIpDetails.Builder getRemoteIpDetails() {
            return remoteIpDetails != null ? remoteIpDetails.toBuilder() : null;
        }

        public final void setRemoteIpDetails(RemoteIpDetails.BuilderImpl remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails != null ? remoteIpDetails.build() : null;
        }

        @Override
        public final Builder remoteIpDetails(RemoteIpDetails remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails;
            return this;
        }

        public final RemotePortDetails.Builder getRemotePortDetails() {
            return remotePortDetails != null ? remotePortDetails.toBuilder() : null;
        }

        public final void setRemotePortDetails(RemotePortDetails.BuilderImpl remotePortDetails) {
            this.remotePortDetails = remotePortDetails != null ? remotePortDetails.build() : null;
        }

        @Override
        public final Builder remotePortDetails(RemotePortDetails remotePortDetails) {
            this.remotePortDetails = remotePortDetails;
            return this;
        }

        @Override
        public NetworkConnectionAction build() {
            return new NetworkConnectionAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
