/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about network endpoint location.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkGeoLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkGeoLocation.Builder, NetworkGeoLocation> {
    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("City")
            .getter(getter(NetworkGeoLocation::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("city").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(NetworkGeoLocation::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("country").build()).build();

    private static final SdkField<Double> LATITUDE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Latitude").getter(getter(NetworkGeoLocation::latitude)).setter(setter(Builder::latitude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lat").build()).build();

    private static final SdkField<Double> LONGITUDE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Longitude").getter(getter(NetworkGeoLocation::longitude)).setter(setter(Builder::longitude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lon").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CITY_FIELD, COUNTRY_FIELD,
            LATITUDE_FIELD, LONGITUDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String city;

    private final String country;

    private final Double latitude;

    private final Double longitude;

    private NetworkGeoLocation(BuilderImpl builder) {
        this.city = builder.city;
        this.country = builder.country;
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
    }

    /**
     * <p>
     * The name of the city.
     * </p>
     * 
     * @return The name of the city.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * The name of the country.
     * </p>
     * 
     * @return The name of the country.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * The latitude information of the endpoint location.
     * </p>
     * 
     * @return The latitude information of the endpoint location.
     */
    public final Double latitude() {
        return latitude;
    }

    /**
     * <p>
     * The longitude information of the endpoint location.
     * </p>
     * 
     * @return The longitude information of the endpoint location.
     */
    public final Double longitude() {
        return longitude;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(latitude());
        hashCode = 31 * hashCode + Objects.hashCode(longitude());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkGeoLocation)) {
            return false;
        }
        NetworkGeoLocation other = (NetworkGeoLocation) obj;
        return Objects.equals(city(), other.city()) && Objects.equals(country(), other.country())
                && Objects.equals(latitude(), other.latitude()) && Objects.equals(longitude(), other.longitude());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkGeoLocation").add("City", city()).add("Country", country()).add("Latitude", latitude())
                .add("Longitude", longitude()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "Latitude":
            return Optional.ofNullable(clazz.cast(latitude()));
        case "Longitude":
            return Optional.ofNullable(clazz.cast(longitude()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("city", CITY_FIELD);
        map.put("country", COUNTRY_FIELD);
        map.put("lat", LATITUDE_FIELD);
        map.put("lon", LONGITUDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkGeoLocation, T> g) {
        return obj -> g.apply((NetworkGeoLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkGeoLocation> {
        /**
         * <p>
         * The name of the city.
         * </p>
         * 
         * @param city
         *        The name of the city.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The name of the country.
         * </p>
         * 
         * @param country
         *        The name of the country.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * The latitude information of the endpoint location.
         * </p>
         * 
         * @param latitude
         *        The latitude information of the endpoint location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latitude(Double latitude);

        /**
         * <p>
         * The longitude information of the endpoint location.
         * </p>
         * 
         * @param longitude
         *        The longitude information of the endpoint location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longitude(Double longitude);
    }

    static final class BuilderImpl implements Builder {
        private String city;

        private String country;

        private Double latitude;

        private Double longitude;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkGeoLocation model) {
            city(model.city);
            country(model.country);
            latitude(model.latitude);
            longitude(model.longitude);
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final Double getLatitude() {
            return latitude;
        }

        public final void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        @Override
        public final Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public final Double getLongitude() {
            return longitude;
        }

        public final void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        @Override
        public final Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        @Override
        public NetworkGeoLocation build() {
            return new NetworkGeoLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
