/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the Amazon Web Services resource that is associated with the activity that prompted
 * GuardDuty to generate a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceData implements SdkPojo, Serializable, ToCopyableBuilder<ResourceData.Builder, ResourceData> {
    private static final SdkField<S3Bucket> S3_BUCKET_FIELD = SdkField.<S3Bucket> builder(MarshallingType.SDK_POJO)
            .memberName("S3Bucket").getter(getter(ResourceData::s3Bucket)).setter(setter(Builder::s3Bucket))
            .constructor(S3Bucket::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()).build();

    private static final SdkField<Ec2Instance> EC2_INSTANCE_FIELD = SdkField.<Ec2Instance> builder(MarshallingType.SDK_POJO)
            .memberName("Ec2Instance").getter(getter(ResourceData::ec2Instance)).setter(setter(Builder::ec2Instance))
            .constructor(Ec2Instance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2Instance").build()).build();

    private static final SdkField<AccessKey> ACCESS_KEY_FIELD = SdkField.<AccessKey> builder(MarshallingType.SDK_POJO)
            .memberName("AccessKey").getter(getter(ResourceData::accessKey)).setter(setter(Builder::accessKey))
            .constructor(AccessKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKey").build()).build();

    private static final SdkField<Ec2NetworkInterface> EC2_NETWORK_INTERFACE_FIELD = SdkField
            .<Ec2NetworkInterface> builder(MarshallingType.SDK_POJO).memberName("Ec2NetworkInterface")
            .getter(getter(ResourceData::ec2NetworkInterface)).setter(setter(Builder::ec2NetworkInterface))
            .constructor(Ec2NetworkInterface::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2NetworkInterface").build())
            .build();

    private static final SdkField<S3Object> S3_OBJECT_FIELD = SdkField.<S3Object> builder(MarshallingType.SDK_POJO)
            .memberName("S3Object").getter(getter(ResourceData::s3Object)).setter(setter(Builder::s3Object))
            .constructor(S3Object::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Object").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD,
            EC2_INSTANCE_FIELD, ACCESS_KEY_FIELD, EC2_NETWORK_INTERFACE_FIELD, S3_OBJECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3Bucket s3Bucket;

    private final Ec2Instance ec2Instance;

    private final AccessKey accessKey;

    private final Ec2NetworkInterface ec2NetworkInterface;

    private final S3Object s3Object;

    private ResourceData(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.ec2Instance = builder.ec2Instance;
        this.accessKey = builder.accessKey;
        this.ec2NetworkInterface = builder.ec2NetworkInterface;
        this.s3Object = builder.s3Object;
    }

    /**
     * <p>
     * Contains information about the Amazon S3 bucket.
     * </p>
     * 
     * @return Contains information about the Amazon S3 bucket.
     */
    public final S3Bucket s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * Contains information about the Amazon EC2 instance.
     * </p>
     * 
     * @return Contains information about the Amazon EC2 instance.
     */
    public final Ec2Instance ec2Instance() {
        return ec2Instance;
    }

    /**
     * <p>
     * Contains information about the IAM access key details of a user that involved in the GuardDuty finding.
     * </p>
     * 
     * @return Contains information about the IAM access key details of a user that involved in the GuardDuty finding.
     */
    public final AccessKey accessKey() {
        return accessKey;
    }

    /**
     * <p>
     * Contains information about the elastic network interface of the Amazon EC2 instance.
     * </p>
     * 
     * @return Contains information about the elastic network interface of the Amazon EC2 instance.
     */
    public final Ec2NetworkInterface ec2NetworkInterface() {
        return ec2NetworkInterface;
    }

    /**
     * <p>
     * Contains information about the Amazon S3 object.
     * </p>
     * 
     * @return Contains information about the Amazon S3 object.
     */
    public final S3Object s3Object() {
        return s3Object;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(ec2Instance());
        hashCode = 31 * hashCode + Objects.hashCode(accessKey());
        hashCode = 31 * hashCode + Objects.hashCode(ec2NetworkInterface());
        hashCode = 31 * hashCode + Objects.hashCode(s3Object());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceData)) {
            return false;
        }
        ResourceData other = (ResourceData) obj;
        return Objects.equals(s3Bucket(), other.s3Bucket()) && Objects.equals(ec2Instance(), other.ec2Instance())
                && Objects.equals(accessKey(), other.accessKey())
                && Objects.equals(ec2NetworkInterface(), other.ec2NetworkInterface())
                && Objects.equals(s3Object(), other.s3Object());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceData").add("S3Bucket", s3Bucket()).add("Ec2Instance", ec2Instance())
                .add("AccessKey", accessKey()).add("Ec2NetworkInterface", ec2NetworkInterface()).add("S3Object", s3Object())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "Ec2Instance":
            return Optional.ofNullable(clazz.cast(ec2Instance()));
        case "AccessKey":
            return Optional.ofNullable(clazz.cast(accessKey()));
        case "Ec2NetworkInterface":
            return Optional.ofNullable(clazz.cast(ec2NetworkInterface()));
        case "S3Object":
            return Optional.ofNullable(clazz.cast(s3Object()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3Bucket", S3_BUCKET_FIELD);
        map.put("ec2Instance", EC2_INSTANCE_FIELD);
        map.put("accessKey", ACCESS_KEY_FIELD);
        map.put("ec2NetworkInterface", EC2_NETWORK_INTERFACE_FIELD);
        map.put("s3Object", S3_OBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceData, T> g) {
        return obj -> g.apply((ResourceData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceData> {
        /**
         * <p>
         * Contains information about the Amazon S3 bucket.
         * </p>
         * 
         * @param s3Bucket
         *        Contains information about the Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(S3Bucket s3Bucket);

        /**
         * <p>
         * Contains information about the Amazon S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Bucket.Builder} avoiding the need to
         * create one manually via {@link S3Bucket#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Bucket.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Bucket(S3Bucket)}.
         * 
         * @param s3Bucket
         *        a consumer that will call methods on {@link S3Bucket.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Bucket(S3Bucket)
         */
        default Builder s3Bucket(Consumer<S3Bucket.Builder> s3Bucket) {
            return s3Bucket(S3Bucket.builder().applyMutation(s3Bucket).build());
        }

        /**
         * <p>
         * Contains information about the Amazon EC2 instance.
         * </p>
         * 
         * @param ec2Instance
         *        Contains information about the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2Instance(Ec2Instance ec2Instance);

        /**
         * <p>
         * Contains information about the Amazon EC2 instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ec2Instance.Builder} avoiding the need to
         * create one manually via {@link Ec2Instance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ec2Instance.Builder#build()} is called immediately and its result
         * is passed to {@link #ec2Instance(Ec2Instance)}.
         * 
         * @param ec2Instance
         *        a consumer that will call methods on {@link Ec2Instance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2Instance(Ec2Instance)
         */
        default Builder ec2Instance(Consumer<Ec2Instance.Builder> ec2Instance) {
            return ec2Instance(Ec2Instance.builder().applyMutation(ec2Instance).build());
        }

        /**
         * <p>
         * Contains information about the IAM access key details of a user that involved in the GuardDuty finding.
         * </p>
         * 
         * @param accessKey
         *        Contains information about the IAM access key details of a user that involved in the GuardDuty
         *        finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKey(AccessKey accessKey);

        /**
         * <p>
         * Contains information about the IAM access key details of a user that involved in the GuardDuty finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessKey.Builder} avoiding the need to
         * create one manually via {@link AccessKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessKey.Builder#build()} is called immediately and its result
         * is passed to {@link #accessKey(AccessKey)}.
         * 
         * @param accessKey
         *        a consumer that will call methods on {@link AccessKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessKey(AccessKey)
         */
        default Builder accessKey(Consumer<AccessKey.Builder> accessKey) {
            return accessKey(AccessKey.builder().applyMutation(accessKey).build());
        }

        /**
         * <p>
         * Contains information about the elastic network interface of the Amazon EC2 instance.
         * </p>
         * 
         * @param ec2NetworkInterface
         *        Contains information about the elastic network interface of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2NetworkInterface(Ec2NetworkInterface ec2NetworkInterface);

        /**
         * <p>
         * Contains information about the elastic network interface of the Amazon EC2 instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ec2NetworkInterface.Builder} avoiding the
         * need to create one manually via {@link Ec2NetworkInterface#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ec2NetworkInterface.Builder#build()} is called immediately and
         * its result is passed to {@link #ec2NetworkInterface(Ec2NetworkInterface)}.
         * 
         * @param ec2NetworkInterface
         *        a consumer that will call methods on {@link Ec2NetworkInterface.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2NetworkInterface(Ec2NetworkInterface)
         */
        default Builder ec2NetworkInterface(Consumer<Ec2NetworkInterface.Builder> ec2NetworkInterface) {
            return ec2NetworkInterface(Ec2NetworkInterface.builder().applyMutation(ec2NetworkInterface).build());
        }

        /**
         * <p>
         * Contains information about the Amazon S3 object.
         * </p>
         * 
         * @param s3Object
         *        Contains information about the Amazon S3 object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Object(S3Object s3Object);

        /**
         * <p>
         * Contains information about the Amazon S3 object.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Object.Builder} avoiding the need to
         * create one manually via {@link S3Object#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Object.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Object(S3Object)}.
         * 
         * @param s3Object
         *        a consumer that will call methods on {@link S3Object.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Object(S3Object)
         */
        default Builder s3Object(Consumer<S3Object.Builder> s3Object) {
            return s3Object(S3Object.builder().applyMutation(s3Object).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Bucket s3Bucket;

        private Ec2Instance ec2Instance;

        private AccessKey accessKey;

        private Ec2NetworkInterface ec2NetworkInterface;

        private S3Object s3Object;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceData model) {
            s3Bucket(model.s3Bucket);
            ec2Instance(model.ec2Instance);
            accessKey(model.accessKey);
            ec2NetworkInterface(model.ec2NetworkInterface);
            s3Object(model.s3Object);
        }

        public final S3Bucket.Builder getS3Bucket() {
            return s3Bucket != null ? s3Bucket.toBuilder() : null;
        }

        public final void setS3Bucket(S3Bucket.BuilderImpl s3Bucket) {
            this.s3Bucket = s3Bucket != null ? s3Bucket.build() : null;
        }

        @Override
        public final Builder s3Bucket(S3Bucket s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final Ec2Instance.Builder getEc2Instance() {
            return ec2Instance != null ? ec2Instance.toBuilder() : null;
        }

        public final void setEc2Instance(Ec2Instance.BuilderImpl ec2Instance) {
            this.ec2Instance = ec2Instance != null ? ec2Instance.build() : null;
        }

        @Override
        public final Builder ec2Instance(Ec2Instance ec2Instance) {
            this.ec2Instance = ec2Instance;
            return this;
        }

        public final AccessKey.Builder getAccessKey() {
            return accessKey != null ? accessKey.toBuilder() : null;
        }

        public final void setAccessKey(AccessKey.BuilderImpl accessKey) {
            this.accessKey = accessKey != null ? accessKey.build() : null;
        }

        @Override
        public final Builder accessKey(AccessKey accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public final Ec2NetworkInterface.Builder getEc2NetworkInterface() {
            return ec2NetworkInterface != null ? ec2NetworkInterface.toBuilder() : null;
        }

        public final void setEc2NetworkInterface(Ec2NetworkInterface.BuilderImpl ec2NetworkInterface) {
            this.ec2NetworkInterface = ec2NetworkInterface != null ? ec2NetworkInterface.build() : null;
        }

        @Override
        public final Builder ec2NetworkInterface(Ec2NetworkInterface ec2NetworkInterface) {
            this.ec2NetworkInterface = ec2NetworkInterface;
            return this;
        }

        public final S3Object.Builder getS3Object() {
            return s3Object != null ? s3Object.toBuilder() : null;
        }

        public final void setS3Object(S3Object.BuilderImpl s3Object) {
            this.s3Object = s3Object != null ? s3Object.build() : null;
        }

        @Override
        public final Builder s3Object(S3Object s3Object) {
            this.s3Object = s3Object;
            return this;
        }

        @Override
        public ResourceData build() {
            return new ResourceData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
