/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on the S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3BucketDetail implements SdkPojo, Serializable, ToCopyableBuilder<S3BucketDetail.Builder, S3BucketDetail> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(S3BucketDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(S3BucketDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(S3BucketDetail::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(S3BucketDetail::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Owner> OWNER_FIELD = SdkField.<Owner> builder(MarshallingType.SDK_POJO).memberName("Owner")
            .getter(getter(S3BucketDetail::owner)).setter(setter(Builder::owner)).constructor(Owner::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(S3BucketDetail::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DefaultServerSideEncryption> DEFAULT_SERVER_SIDE_ENCRYPTION_FIELD = SdkField
            .<DefaultServerSideEncryption> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultServerSideEncryption")
            .getter(getter(S3BucketDetail::defaultServerSideEncryption))
            .setter(setter(Builder::defaultServerSideEncryption))
            .constructor(DefaultServerSideEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultServerSideEncryption")
                    .build()).build();

    private static final SdkField<PublicAccess> PUBLIC_ACCESS_FIELD = SdkField.<PublicAccess> builder(MarshallingType.SDK_POJO)
            .memberName("PublicAccess").getter(getter(S3BucketDetail::publicAccess)).setter(setter(Builder::publicAccess))
            .constructor(PublicAccess::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicAccess").build()).build();

    private static final SdkField<List<S3ObjectDetail>> S3_OBJECT_DETAILS_FIELD = SdkField
            .<List<S3ObjectDetail>> builder(MarshallingType.LIST)
            .memberName("S3ObjectDetails")
            .getter(getter(S3BucketDetail::s3ObjectDetails))
            .setter(setter(Builder::s3ObjectDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ObjectDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3ObjectDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3ObjectDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            TYPE_FIELD, CREATED_AT_FIELD, OWNER_FIELD, TAGS_FIELD, DEFAULT_SERVER_SIDE_ENCRYPTION_FIELD, PUBLIC_ACCESS_FIELD,
            S3_OBJECT_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String type;

    private final Instant createdAt;

    private final Owner owner;

    private final List<Tag> tags;

    private final DefaultServerSideEncryption defaultServerSideEncryption;

    private final PublicAccess publicAccess;

    private final List<S3ObjectDetail> s3ObjectDetails;

    private S3BucketDetail(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.createdAt = builder.createdAt;
        this.owner = builder.owner;
        this.tags = builder.tags;
        this.defaultServerSideEncryption = builder.defaultServerSideEncryption;
        this.publicAccess = builder.publicAccess;
        this.s3ObjectDetails = builder.s3ObjectDetails;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the S3 bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the S3 bucket.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the S3 bucket.
     * </p>
     * 
     * @return The name of the S3 bucket.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Describes whether the bucket is a source or destination bucket.
     * </p>
     * 
     * @return Describes whether the bucket is a source or destination bucket.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The date and time the bucket was created at.
     * </p>
     * 
     * @return The date and time the bucket was created at.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The owner of the S3 bucket.
     * </p>
     * 
     * @return The owner of the S3 bucket.
     */
    public final Owner owner() {
        return owner;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * All tags attached to the S3 bucket
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return All tags attached to the S3 bucket
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Describes the server side encryption method used in the S3 bucket.
     * </p>
     * 
     * @return Describes the server side encryption method used in the S3 bucket.
     */
    public final DefaultServerSideEncryption defaultServerSideEncryption() {
        return defaultServerSideEncryption;
    }

    /**
     * <p>
     * Describes the public access policies that apply to the S3 bucket.
     * </p>
     * 
     * @return Describes the public access policies that apply to the S3 bucket.
     */
    public final PublicAccess publicAccess() {
        return publicAccess;
    }

    /**
     * For responses, this returns true if the service returned a value for the S3ObjectDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasS3ObjectDetails() {
        return s3ObjectDetails != null && !(s3ObjectDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the S3 object that was scanned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasS3ObjectDetails} method.
     * </p>
     * 
     * @return Information about the S3 object that was scanned.
     */
    public final List<S3ObjectDetail> s3ObjectDetails() {
        return s3ObjectDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultServerSideEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(publicAccess());
        hashCode = 31 * hashCode + Objects.hashCode(hasS3ObjectDetails() ? s3ObjectDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketDetail)) {
            return false;
        }
        S3BucketDetail other = (S3BucketDetail) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name()) && Objects.equals(type(), other.type())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(owner(), other.owner())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(defaultServerSideEncryption(), other.defaultServerSideEncryption())
                && Objects.equals(publicAccess(), other.publicAccess()) && hasS3ObjectDetails() == other.hasS3ObjectDetails()
                && Objects.equals(s3ObjectDetails(), other.s3ObjectDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3BucketDetail").add("Arn", arn()).add("Name", name()).add("Type", type())
                .add("CreatedAt", createdAt()).add("Owner", owner()).add("Tags", hasTags() ? tags() : null)
                .add("DefaultServerSideEncryption", defaultServerSideEncryption()).add("PublicAccess", publicAccess())
                .add("S3ObjectDetails", hasS3ObjectDetails() ? s3ObjectDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "DefaultServerSideEncryption":
            return Optional.ofNullable(clazz.cast(defaultServerSideEncryption()));
        case "PublicAccess":
            return Optional.ofNullable(clazz.cast(publicAccess()));
        case "S3ObjectDetails":
            return Optional.ofNullable(clazz.cast(s3ObjectDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("defaultServerSideEncryption", DEFAULT_SERVER_SIDE_ENCRYPTION_FIELD);
        map.put("publicAccess", PUBLIC_ACCESS_FIELD);
        map.put("s3ObjectDetails", S3_OBJECT_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3BucketDetail, T> g) {
        return obj -> g.apply((S3BucketDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3BucketDetail> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the S3 bucket.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the S3 bucket.
         * </p>
         * 
         * @param name
         *        The name of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Describes whether the bucket is a source or destination bucket.
         * </p>
         * 
         * @param type
         *        Describes whether the bucket is a source or destination bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The date and time the bucket was created at.
         * </p>
         * 
         * @param createdAt
         *        The date and time the bucket was created at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The owner of the S3 bucket.
         * </p>
         * 
         * @param owner
         *        The owner of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(Owner owner);

        /**
         * <p>
         * The owner of the S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link Owner.Builder} avoiding the need to
         * create one manually via {@link Owner#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Owner.Builder#build()} is called immediately and its result is
         * passed to {@link #owner(Owner)}.
         * 
         * @param owner
         *        a consumer that will call methods on {@link Owner.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #owner(Owner)
         */
        default Builder owner(Consumer<Owner.Builder> owner) {
            return owner(Owner.builder().applyMutation(owner).build());
        }

        /**
         * <p>
         * All tags attached to the S3 bucket
         * </p>
         * 
         * @param tags
         *        All tags attached to the S3 bucket
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * All tags attached to the S3 bucket
         * </p>
         * 
         * @param tags
         *        All tags attached to the S3 bucket
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * All tags attached to the S3 bucket
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.guardduty.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Describes the server side encryption method used in the S3 bucket.
         * </p>
         * 
         * @param defaultServerSideEncryption
         *        Describes the server side encryption method used in the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultServerSideEncryption(DefaultServerSideEncryption defaultServerSideEncryption);

        /**
         * <p>
         * Describes the server side encryption method used in the S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultServerSideEncryption.Builder}
         * avoiding the need to create one manually via {@link DefaultServerSideEncryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultServerSideEncryption.Builder#build()} is called
         * immediately and its result is passed to {@link #defaultServerSideEncryption(DefaultServerSideEncryption)}.
         * 
         * @param defaultServerSideEncryption
         *        a consumer that will call methods on {@link DefaultServerSideEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultServerSideEncryption(DefaultServerSideEncryption)
         */
        default Builder defaultServerSideEncryption(Consumer<DefaultServerSideEncryption.Builder> defaultServerSideEncryption) {
            return defaultServerSideEncryption(DefaultServerSideEncryption.builder().applyMutation(defaultServerSideEncryption)
                    .build());
        }

        /**
         * <p>
         * Describes the public access policies that apply to the S3 bucket.
         * </p>
         * 
         * @param publicAccess
         *        Describes the public access policies that apply to the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicAccess(PublicAccess publicAccess);

        /**
         * <p>
         * Describes the public access policies that apply to the S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link PublicAccess.Builder} avoiding the need
         * to create one manually via {@link PublicAccess#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PublicAccess.Builder#build()} is called immediately and its
         * result is passed to {@link #publicAccess(PublicAccess)}.
         * 
         * @param publicAccess
         *        a consumer that will call methods on {@link PublicAccess.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicAccess(PublicAccess)
         */
        default Builder publicAccess(Consumer<PublicAccess.Builder> publicAccess) {
            return publicAccess(PublicAccess.builder().applyMutation(publicAccess).build());
        }

        /**
         * <p>
         * Information about the S3 object that was scanned.
         * </p>
         * 
         * @param s3ObjectDetails
         *        Information about the S3 object that was scanned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ObjectDetails(Collection<S3ObjectDetail> s3ObjectDetails);

        /**
         * <p>
         * Information about the S3 object that was scanned.
         * </p>
         * 
         * @param s3ObjectDetails
         *        Information about the S3 object that was scanned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ObjectDetails(S3ObjectDetail... s3ObjectDetails);

        /**
         * <p>
         * Information about the S3 object that was scanned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.S3ObjectDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.guardduty.model.S3ObjectDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.S3ObjectDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #s3ObjectDetails(List<S3ObjectDetail>)}.
         * 
         * @param s3ObjectDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.S3ObjectDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ObjectDetails(java.util.Collection<S3ObjectDetail>)
         */
        Builder s3ObjectDetails(Consumer<S3ObjectDetail.Builder>... s3ObjectDetails);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String type;

        private Instant createdAt;

        private Owner owner;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private DefaultServerSideEncryption defaultServerSideEncryption;

        private PublicAccess publicAccess;

        private List<S3ObjectDetail> s3ObjectDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketDetail model) {
            arn(model.arn);
            name(model.name);
            type(model.type);
            createdAt(model.createdAt);
            owner(model.owner);
            tags(model.tags);
            defaultServerSideEncryption(model.defaultServerSideEncryption);
            publicAccess(model.publicAccess);
            s3ObjectDetails(model.s3ObjectDetails);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Owner.Builder getOwner() {
            return owner != null ? owner.toBuilder() : null;
        }

        public final void setOwner(Owner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final DefaultServerSideEncryption.Builder getDefaultServerSideEncryption() {
            return defaultServerSideEncryption != null ? defaultServerSideEncryption.toBuilder() : null;
        }

        public final void setDefaultServerSideEncryption(DefaultServerSideEncryption.BuilderImpl defaultServerSideEncryption) {
            this.defaultServerSideEncryption = defaultServerSideEncryption != null ? defaultServerSideEncryption.build() : null;
        }

        @Override
        public final Builder defaultServerSideEncryption(DefaultServerSideEncryption defaultServerSideEncryption) {
            this.defaultServerSideEncryption = defaultServerSideEncryption;
            return this;
        }

        public final PublicAccess.Builder getPublicAccess() {
            return publicAccess != null ? publicAccess.toBuilder() : null;
        }

        public final void setPublicAccess(PublicAccess.BuilderImpl publicAccess) {
            this.publicAccess = publicAccess != null ? publicAccess.build() : null;
        }

        @Override
        public final Builder publicAccess(PublicAccess publicAccess) {
            this.publicAccess = publicAccess;
            return this;
        }

        public final List<S3ObjectDetail.Builder> getS3ObjectDetails() {
            List<S3ObjectDetail.Builder> result = S3ObjectDetailsCopier.copyToBuilder(this.s3ObjectDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3ObjectDetails(Collection<S3ObjectDetail.BuilderImpl> s3ObjectDetails) {
            this.s3ObjectDetails = S3ObjectDetailsCopier.copyFromBuilder(s3ObjectDetails);
        }

        @Override
        public final Builder s3ObjectDetails(Collection<S3ObjectDetail> s3ObjectDetails) {
            this.s3ObjectDetails = S3ObjectDetailsCopier.copy(s3ObjectDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3ObjectDetails(S3ObjectDetail... s3ObjectDetails) {
            s3ObjectDetails(Arrays.asList(s3ObjectDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3ObjectDetails(Consumer<S3ObjectDetail.Builder>... s3ObjectDetails) {
            s3ObjectDetails(Stream.of(s3ObjectDetails).map(c -> S3ObjectDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public S3BucketDetail build() {
            return new S3BucketDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
