/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes whether Malware Protection for EC2 instances with findings will be enabled as a data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScanEc2InstanceWithFindings implements SdkPojo, Serializable,
        ToCopyableBuilder<ScanEc2InstanceWithFindings.Builder, ScanEc2InstanceWithFindings> {
    private static final SdkField<Boolean> EBS_VOLUMES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsVolumes").getter(getter(ScanEc2InstanceWithFindings::ebsVolumes)).setter(setter(Builder::ebsVolumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsVolumes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EBS_VOLUMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean ebsVolumes;

    private ScanEc2InstanceWithFindings(BuilderImpl builder) {
        this.ebsVolumes = builder.ebsVolumes;
    }

    /**
     * <p>
     * Describes the configuration for scanning EBS volumes as data source.
     * </p>
     * 
     * @return Describes the configuration for scanning EBS volumes as data source.
     */
    public final Boolean ebsVolumes() {
        return ebsVolumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ebsVolumes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanEc2InstanceWithFindings)) {
            return false;
        }
        ScanEc2InstanceWithFindings other = (ScanEc2InstanceWithFindings) obj;
        return Objects.equals(ebsVolumes(), other.ebsVolumes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScanEc2InstanceWithFindings").add("EbsVolumes", ebsVolumes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EbsVolumes":
            return Optional.ofNullable(clazz.cast(ebsVolumes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ebsVolumes", EBS_VOLUMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScanEc2InstanceWithFindings, T> g) {
        return obj -> g.apply((ScanEc2InstanceWithFindings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScanEc2InstanceWithFindings> {
        /**
         * <p>
         * Describes the configuration for scanning EBS volumes as data source.
         * </p>
         * 
         * @param ebsVolumes
         *        Describes the configuration for scanning EBS volumes as data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsVolumes(Boolean ebsVolumes);
    }

    static final class BuilderImpl implements Builder {
        private Boolean ebsVolumes;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanEc2InstanceWithFindings model) {
            ebsVolumes(model.ebsVolumes);
        }

        public final Boolean getEbsVolumes() {
            return ebsVolumes;
        }

        public final void setEbsVolumes(Boolean ebsVolumes) {
            this.ebsVolumes = ebsVolumes;
        }

        @Override
        public final Builder ebsVolumes(Boolean ebsVolumes) {
            this.ebsVolumes = ebsVolumes;
            return this;
        }

        @Override
        public ScanEc2InstanceWithFindings build() {
            return new ScanEc2InstanceWithFindings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
