/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMalwareProtectionPlanRequest extends GuardDutyRequest implements
        ToCopyableBuilder<UpdateMalwareProtectionPlanRequest.Builder, UpdateMalwareProtectionPlanRequest> {
    private static final SdkField<String> MALWARE_PROTECTION_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MalwareProtectionPlanId").getter(getter(UpdateMalwareProtectionPlanRequest::malwareProtectionPlanId))
            .setter(setter(Builder::malwareProtectionPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("malwareProtectionPlanId").build())
            .build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(UpdateMalwareProtectionPlanRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final SdkField<MalwareProtectionPlanActions> ACTIONS_FIELD = SdkField
            .<MalwareProtectionPlanActions> builder(MarshallingType.SDK_POJO).memberName("Actions")
            .getter(getter(UpdateMalwareProtectionPlanRequest::actions)).setter(setter(Builder::actions))
            .constructor(MalwareProtectionPlanActions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build()).build();

    private static final SdkField<UpdateProtectedResource> PROTECTED_RESOURCE_FIELD = SdkField
            .<UpdateProtectedResource> builder(MarshallingType.SDK_POJO).memberName("ProtectedResource")
            .getter(getter(UpdateMalwareProtectionPlanRequest::protectedResource)).setter(setter(Builder::protectedResource))
            .constructor(UpdateProtectedResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protectedResource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MALWARE_PROTECTION_PLAN_ID_FIELD, ROLE_FIELD, ACTIONS_FIELD, PROTECTED_RESOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String malwareProtectionPlanId;

    private final String role;

    private final MalwareProtectionPlanActions actions;

    private final UpdateProtectedResource protectedResource;

    private UpdateMalwareProtectionPlanRequest(BuilderImpl builder) {
        super(builder);
        this.malwareProtectionPlanId = builder.malwareProtectionPlanId;
        this.role = builder.role;
        this.actions = builder.actions;
        this.protectedResource = builder.protectedResource;
    }

    /**
     * <p>
     * A unique identifier associated with the Malware Protection plan.
     * </p>
     * 
     * @return A unique identifier associated with the Malware Protection plan.
     */
    public final String malwareProtectionPlanId() {
        return malwareProtectionPlanId;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the IAM role with permissions to scan and add tags to the associated protected
     * resource.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the IAM role with permissions to scan and add tags to the associated
     *         protected resource.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * Information about whether the tags will be added to the S3 object after scanning.
     * </p>
     * 
     * @return Information about whether the tags will be added to the S3 object after scanning.
     */
    public final MalwareProtectionPlanActions actions() {
        return actions;
    }

    /**
     * <p>
     * Information about the protected resource that is associated with the created Malware Protection plan. Presently,
     * <code>S3Bucket</code> is the only supported protected resource.
     * </p>
     * 
     * @return Information about the protected resource that is associated with the created Malware Protection plan.
     *         Presently, <code>S3Bucket</code> is the only supported protected resource.
     */
    public final UpdateProtectedResource protectedResource() {
        return protectedResource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(malwareProtectionPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        hashCode = 31 * hashCode + Objects.hashCode(protectedResource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMalwareProtectionPlanRequest)) {
            return false;
        }
        UpdateMalwareProtectionPlanRequest other = (UpdateMalwareProtectionPlanRequest) obj;
        return Objects.equals(malwareProtectionPlanId(), other.malwareProtectionPlanId()) && Objects.equals(role(), other.role())
                && Objects.equals(actions(), other.actions()) && Objects.equals(protectedResource(), other.protectedResource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMalwareProtectionPlanRequest").add("MalwareProtectionPlanId", malwareProtectionPlanId())
                .add("Role", role()).add("Actions", actions()).add("ProtectedResource", protectedResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MalwareProtectionPlanId":
            return Optional.ofNullable(clazz.cast(malwareProtectionPlanId()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "ProtectedResource":
            return Optional.ofNullable(clazz.cast(protectedResource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("malwareProtectionPlanId", MALWARE_PROTECTION_PLAN_ID_FIELD);
        map.put("role", ROLE_FIELD);
        map.put("actions", ACTIONS_FIELD);
        map.put("protectedResource", PROTECTED_RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMalwareProtectionPlanRequest, T> g) {
        return obj -> g.apply((UpdateMalwareProtectionPlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMalwareProtectionPlanRequest> {
        /**
         * <p>
         * A unique identifier associated with the Malware Protection plan.
         * </p>
         * 
         * @param malwareProtectionPlanId
         *        A unique identifier associated with the Malware Protection plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malwareProtectionPlanId(String malwareProtectionPlanId);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the IAM role with permissions to scan and add tags to the associated protected
         * resource.
         * </p>
         * 
         * @param role
         *        Amazon Resource Name (ARN) of the IAM role with permissions to scan and add tags to the associated
         *        protected resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * Information about whether the tags will be added to the S3 object after scanning.
         * </p>
         * 
         * @param actions
         *        Information about whether the tags will be added to the S3 object after scanning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(MalwareProtectionPlanActions actions);

        /**
         * <p>
         * Information about whether the tags will be added to the S3 object after scanning.
         * </p>
         * This is a convenience method that creates an instance of the {@link MalwareProtectionPlanActions.Builder}
         * avoiding the need to create one manually via {@link MalwareProtectionPlanActions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MalwareProtectionPlanActions.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(MalwareProtectionPlanActions)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link MalwareProtectionPlanActions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(MalwareProtectionPlanActions)
         */
        default Builder actions(Consumer<MalwareProtectionPlanActions.Builder> actions) {
            return actions(MalwareProtectionPlanActions.builder().applyMutation(actions).build());
        }

        /**
         * <p>
         * Information about the protected resource that is associated with the created Malware Protection plan.
         * Presently, <code>S3Bucket</code> is the only supported protected resource.
         * </p>
         * 
         * @param protectedResource
         *        Information about the protected resource that is associated with the created Malware Protection plan.
         *        Presently, <code>S3Bucket</code> is the only supported protected resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedResource(UpdateProtectedResource protectedResource);

        /**
         * <p>
         * Information about the protected resource that is associated with the created Malware Protection plan.
         * Presently, <code>S3Bucket</code> is the only supported protected resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateProtectedResource.Builder} avoiding
         * the need to create one manually via {@link UpdateProtectedResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateProtectedResource.Builder#build()} is called immediately
         * and its result is passed to {@link #protectedResource(UpdateProtectedResource)}.
         * 
         * @param protectedResource
         *        a consumer that will call methods on {@link UpdateProtectedResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protectedResource(UpdateProtectedResource)
         */
        default Builder protectedResource(Consumer<UpdateProtectedResource.Builder> protectedResource) {
            return protectedResource(UpdateProtectedResource.builder().applyMutation(protectedResource).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String malwareProtectionPlanId;

        private String role;

        private MalwareProtectionPlanActions actions;

        private UpdateProtectedResource protectedResource;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMalwareProtectionPlanRequest model) {
            super(model);
            malwareProtectionPlanId(model.malwareProtectionPlanId);
            role(model.role);
            actions(model.actions);
            protectedResource(model.protectedResource);
        }

        public final String getMalwareProtectionPlanId() {
            return malwareProtectionPlanId;
        }

        public final void setMalwareProtectionPlanId(String malwareProtectionPlanId) {
            this.malwareProtectionPlanId = malwareProtectionPlanId;
        }

        @Override
        public final Builder malwareProtectionPlanId(String malwareProtectionPlanId) {
            this.malwareProtectionPlanId = malwareProtectionPlanId;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final MalwareProtectionPlanActions.Builder getActions() {
            return actions != null ? actions.toBuilder() : null;
        }

        public final void setActions(MalwareProtectionPlanActions.BuilderImpl actions) {
            this.actions = actions != null ? actions.build() : null;
        }

        @Override
        public final Builder actions(MalwareProtectionPlanActions actions) {
            this.actions = actions;
            return this;
        }

        public final UpdateProtectedResource.Builder getProtectedResource() {
            return protectedResource != null ? protectedResource.toBuilder() : null;
        }

        public final void setProtectedResource(UpdateProtectedResource.BuilderImpl protectedResource) {
            this.protectedResource = protectedResource != null ? protectedResource.build() : null;
        }

        @Override
        public final Builder protectedResource(UpdateProtectedResource protectedResource) {
            this.protectedResource = protectedResource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMalwareProtectionPlanRequest build() {
            return new UpdateMalwareProtectionPlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
