/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on the sum of usage based on an Amazon Web Services resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageResourceResult implements SdkPojo, Serializable,
        ToCopyableBuilder<UsageResourceResult.Builder, UsageResourceResult> {
    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Resource").getter(getter(UsageResourceResult::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<Total> TOTAL_FIELD = SdkField.<Total> builder(MarshallingType.SDK_POJO).memberName("Total")
            .getter(getter(UsageResourceResult::total)).setter(setter(Builder::total)).constructor(Total::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD, TOTAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resource;

    private final Total total;

    private UsageResourceResult(BuilderImpl builder) {
        this.resource = builder.resource;
        this.total = builder.total;
    }

    /**
     * <p>
     * The Amazon Web Services resource that generated usage.
     * </p>
     * 
     * @return The Amazon Web Services resource that generated usage.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * Represents the sum total of usage for the specified resource type.
     * </p>
     * 
     * @return Represents the sum total of usage for the specified resource type.
     */
    public final Total total() {
        return total;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageResourceResult)) {
            return false;
        }
        UsageResourceResult other = (UsageResourceResult) obj;
        return Objects.equals(resource(), other.resource()) && Objects.equals(total(), other.total());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageResourceResult").add("Resource", resource()).add("Total", total()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resource", RESOURCE_FIELD);
        map.put("total", TOTAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UsageResourceResult, T> g) {
        return obj -> g.apply((UsageResourceResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageResourceResult> {
        /**
         * <p>
         * The Amazon Web Services resource that generated usage.
         * </p>
         * 
         * @param resource
         *        The Amazon Web Services resource that generated usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * Represents the sum total of usage for the specified resource type.
         * </p>
         * 
         * @param total
         *        Represents the sum total of usage for the specified resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Total total);

        /**
         * <p>
         * Represents the sum total of usage for the specified resource type.
         * </p>
         * This is a convenience method that creates an instance of the {@link Total.Builder} avoiding the need to
         * create one manually via {@link Total#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Total.Builder#build()} is called immediately and its result is
         * passed to {@link #total(Total)}.
         * 
         * @param total
         *        a consumer that will call methods on {@link Total.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #total(Total)
         */
        default Builder total(Consumer<Total.Builder> total) {
            return total(Total.builder().applyMutation(total).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String resource;

        private Total total;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageResourceResult model) {
            resource(model.resource);
            total(model.total);
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final Total.Builder getTotal() {
            return total != null ? total.toBuilder() : null;
        }

        public final void setTotal(Total.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        @Override
        public final Builder total(Total total) {
            this.total = total;
            return this;
        }

        @Override
        public UsageResourceResult build() {
            return new UsageResourceResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
