/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the usage statistics, calculated by top accounts by feature.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageTopAccountsResult implements SdkPojo, Serializable,
        ToCopyableBuilder<UsageTopAccountsResult.Builder, UsageTopAccountsResult> {
    private static final SdkField<String> FEATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Feature")
            .getter(getter(UsageTopAccountsResult::featureAsString)).setter(setter(Builder::feature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("feature").build()).build();

    private static final SdkField<List<UsageTopAccountResult>> ACCOUNTS_FIELD = SdkField
            .<List<UsageTopAccountResult>> builder(MarshallingType.LIST)
            .memberName("Accounts")
            .getter(getter(UsageTopAccountsResult::accounts))
            .setter(setter(Builder::accounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageTopAccountResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageTopAccountResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FEATURE_FIELD, ACCOUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String feature;

    private final List<UsageTopAccountResult> accounts;

    private UsageTopAccountsResult(BuilderImpl builder) {
        this.feature = builder.feature;
        this.accounts = builder.accounts;
    }

    /**
     * <p>
     * Features by which you can generate the usage statistics.
     * </p>
     * <p>
     * <code>RDS_LOGIN_EVENTS</code> is currently not supported with <code>topAccountsByFeature</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feature} will
     * return {@link UsageFeature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #featureAsString}.
     * </p>
     * 
     * @return Features by which you can generate the usage statistics.</p>
     *         <p>
     *         <code>RDS_LOGIN_EVENTS</code> is currently not supported with <code>topAccountsByFeature</code>.
     * @see UsageFeature
     */
    public final UsageFeature feature() {
        return UsageFeature.fromValue(feature);
    }

    /**
     * <p>
     * Features by which you can generate the usage statistics.
     * </p>
     * <p>
     * <code>RDS_LOGIN_EVENTS</code> is currently not supported with <code>topAccountsByFeature</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feature} will
     * return {@link UsageFeature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #featureAsString}.
     * </p>
     * 
     * @return Features by which you can generate the usage statistics.</p>
     *         <p>
     *         <code>RDS_LOGIN_EVENTS</code> is currently not supported with <code>topAccountsByFeature</code>.
     * @see UsageFeature
     */
    public final String featureAsString() {
        return feature;
    }

    /**
     * For responses, this returns true if the service returned a value for the Accounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccounts() {
        return accounts != null && !(accounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The accounts that contributed to the total usage cost.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccounts} method.
     * </p>
     * 
     * @return The accounts that contributed to the total usage cost.
     */
    public final List<UsageTopAccountResult> accounts() {
        return accounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(featureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccounts() ? accounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageTopAccountsResult)) {
            return false;
        }
        UsageTopAccountsResult other = (UsageTopAccountsResult) obj;
        return Objects.equals(featureAsString(), other.featureAsString()) && hasAccounts() == other.hasAccounts()
                && Objects.equals(accounts(), other.accounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageTopAccountsResult").add("Feature", featureAsString())
                .add("Accounts", hasAccounts() ? accounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Feature":
            return Optional.ofNullable(clazz.cast(featureAsString()));
        case "Accounts":
            return Optional.ofNullable(clazz.cast(accounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("feature", FEATURE_FIELD);
        map.put("accounts", ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UsageTopAccountsResult, T> g) {
        return obj -> g.apply((UsageTopAccountsResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageTopAccountsResult> {
        /**
         * <p>
         * Features by which you can generate the usage statistics.
         * </p>
         * <p>
         * <code>RDS_LOGIN_EVENTS</code> is currently not supported with <code>topAccountsByFeature</code>.
         * </p>
         * 
         * @param feature
         *        Features by which you can generate the usage statistics.</p>
         *        <p>
         *        <code>RDS_LOGIN_EVENTS</code> is currently not supported with <code>topAccountsByFeature</code>.
         * @see UsageFeature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageFeature
         */
        Builder feature(String feature);

        /**
         * <p>
         * Features by which you can generate the usage statistics.
         * </p>
         * <p>
         * <code>RDS_LOGIN_EVENTS</code> is currently not supported with <code>topAccountsByFeature</code>.
         * </p>
         * 
         * @param feature
         *        Features by which you can generate the usage statistics.</p>
         *        <p>
         *        <code>RDS_LOGIN_EVENTS</code> is currently not supported with <code>topAccountsByFeature</code>.
         * @see UsageFeature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageFeature
         */
        Builder feature(UsageFeature feature);

        /**
         * <p>
         * The accounts that contributed to the total usage cost.
         * </p>
         * 
         * @param accounts
         *        The accounts that contributed to the total usage cost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(Collection<UsageTopAccountResult> accounts);

        /**
         * <p>
         * The accounts that contributed to the total usage cost.
         * </p>
         * 
         * @param accounts
         *        The accounts that contributed to the total usage cost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(UsageTopAccountResult... accounts);

        /**
         * <p>
         * The accounts that contributed to the total usage cost.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.UsageTopAccountResult.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.UsageTopAccountResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.UsageTopAccountResult.Builder#build()} is called
         * immediately and its result is passed to {@link #accounts(List<UsageTopAccountResult>)}.
         * 
         * @param accounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.UsageTopAccountResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accounts(java.util.Collection<UsageTopAccountResult>)
         */
        Builder accounts(Consumer<UsageTopAccountResult.Builder>... accounts);
    }

    static final class BuilderImpl implements Builder {
        private String feature;

        private List<UsageTopAccountResult> accounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsageTopAccountsResult model) {
            feature(model.feature);
            accounts(model.accounts);
        }

        public final String getFeature() {
            return feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public final Builder feature(UsageFeature feature) {
            this.feature(feature == null ? null : feature.toString());
            return this;
        }

        public final List<UsageTopAccountResult.Builder> getAccounts() {
            List<UsageTopAccountResult.Builder> result = UsageTopAccountsByFeatureListCopier.copyToBuilder(this.accounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccounts(Collection<UsageTopAccountResult.BuilderImpl> accounts) {
            this.accounts = UsageTopAccountsByFeatureListCopier.copyFromBuilder(accounts);
        }

        @Override
        public final Builder accounts(Collection<UsageTopAccountResult> accounts) {
            this.accounts = UsageTopAccountsByFeatureListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(UsageTopAccountResult... accounts) {
            accounts(Arrays.asList(accounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(Consumer<UsageTopAccountResult.Builder>... accounts) {
            accounts(Stream.of(accounts).map(c -> UsageTopAccountResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public UsageTopAccountsResult build() {
            return new UsageTopAccountsResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
