/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the anomalies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Anomaly implements SdkPojo, Serializable, ToCopyableBuilder<Anomaly.Builder, Anomaly> {
    private static final SdkField<Map<String, Map<String, List<AnomalyObject>>>> PROFILES_FIELD = SdkField
            .<Map<String, Map<String, List<AnomalyObject>>>> builder(MarshallingType.MAP)
            .memberName("Profiles")
            .getter(getter(Anomaly::profiles))
            .setter(setter(Builder::profiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profiles").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, List<AnomalyObject>>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<List<AnomalyObject>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<AnomalyObject> builder(
                                                                                                            MarshallingType.SDK_POJO)
                                                                                                            .constructor(
                                                                                                                    AnomalyObject::builder)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final SdkField<AnomalyUnusual> UNUSUAL_FIELD = SdkField.<AnomalyUnusual> builder(MarshallingType.SDK_POJO)
            .memberName("Unusual").getter(getter(Anomaly::unusual)).setter(setter(Builder::unusual))
            .constructor(AnomalyUnusual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusual").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(PROFILES_FIELD, UNUSUAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, Map<String, List<AnomalyObject>>> profiles;

    private final AnomalyUnusual unusual;

    private Anomaly(BuilderImpl builder) {
        this.profiles = builder.profiles;
        this.unusual = builder.unusual;
    }

    /**
     * For responses, this returns true if the service returned a value for the Profiles property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProfiles() {
        return profiles != null && !(profiles instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Information about the types of profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfiles} method.
     * </p>
     * 
     * @return Information about the types of profiles.
     */
    public final Map<String, Map<String, List<AnomalyObject>>> profiles() {
        return profiles;
    }

    /**
     * <p>
     * Information about the behavior of the anomalies.
     * </p>
     * 
     * @return Information about the behavior of the anomalies.
     */
    public final AnomalyUnusual unusual() {
        return unusual;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasProfiles() ? profiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(unusual());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Anomaly)) {
            return false;
        }
        Anomaly other = (Anomaly) obj;
        return hasProfiles() == other.hasProfiles() && Objects.equals(profiles(), other.profiles())
                && Objects.equals(unusual(), other.unusual());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Anomaly").add("Profiles", hasProfiles() ? profiles() : null).add("Unusual", unusual()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Profiles":
            return Optional.ofNullable(clazz.cast(profiles()));
        case "Unusual":
            return Optional.ofNullable(clazz.cast(unusual()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("profiles", PROFILES_FIELD);
        map.put("unusual", UNUSUAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Anomaly, T> g) {
        return obj -> g.apply((Anomaly) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Anomaly> {
        /**
         * <p>
         * Information about the types of profiles.
         * </p>
         * 
         * @param profiles
         *        Information about the types of profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profiles(Map<String, ? extends Map<String, ? extends Collection<AnomalyObject>>> profiles);

        /**
         * <p>
         * Information about the behavior of the anomalies.
         * </p>
         * 
         * @param unusual
         *        Information about the behavior of the anomalies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusual(AnomalyUnusual unusual);

        /**
         * <p>
         * Information about the behavior of the anomalies.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnomalyUnusual.Builder} avoiding the need
         * to create one manually via {@link AnomalyUnusual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnomalyUnusual.Builder#build()} is called immediately and its
         * result is passed to {@link #unusual(AnomalyUnusual)}.
         * 
         * @param unusual
         *        a consumer that will call methods on {@link AnomalyUnusual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unusual(AnomalyUnusual)
         */
        default Builder unusual(Consumer<AnomalyUnusual.Builder> unusual) {
            return unusual(AnomalyUnusual.builder().applyMutation(unusual).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Map<String, List<AnomalyObject>>> profiles = DefaultSdkAutoConstructMap.getInstance();

        private AnomalyUnusual unusual;

        private BuilderImpl() {
        }

        private BuilderImpl(Anomaly model) {
            profiles(model.profiles);
            unusual(model.unusual);
        }

        public final Map<String, Map<String, List<AnomalyObject.Builder>>> getProfiles() {
            Map<String, Map<String, List<AnomalyObject.Builder>>> result = AnomalyProfilesCopier.copyToBuilder(this.profiles);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setProfiles(Map<String, ? extends Map<String, ? extends Collection<AnomalyObject.BuilderImpl>>> profiles) {
            this.profiles = AnomalyProfilesCopier.copyFromBuilder(profiles);
        }

        @Override
        public final Builder profiles(Map<String, ? extends Map<String, ? extends Collection<AnomalyObject>>> profiles) {
            this.profiles = AnomalyProfilesCopier.copy(profiles);
            return this;
        }

        public final AnomalyUnusual.Builder getUnusual() {
            return unusual != null ? unusual.toBuilder() : null;
        }

        public final void setUnusual(AnomalyUnusual.BuilderImpl unusual) {
            this.unusual = unusual != null ? unusual.build() : null;
        }

        @Override
        public final Builder unusual(AnomalyUnusual unusual) {
            this.unusual = unusual;
            return this;
        }

        @Override
        public Anomaly build() {
            return new Anomaly(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
