/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the bucket level permissions for the S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketLevelPermissions implements SdkPojo, Serializable,
        ToCopyableBuilder<BucketLevelPermissions.Builder, BucketLevelPermissions> {
    private static final SdkField<AccessControlList> ACCESS_CONTROL_LIST_FIELD = SdkField
            .<AccessControlList> builder(MarshallingType.SDK_POJO).memberName("AccessControlList")
            .getter(getter(BucketLevelPermissions::accessControlList)).setter(setter(Builder::accessControlList))
            .constructor(AccessControlList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessControlList").build()).build();

    private static final SdkField<BucketPolicy> BUCKET_POLICY_FIELD = SdkField.<BucketPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("BucketPolicy").getter(getter(BucketLevelPermissions::bucketPolicy))
            .setter(setter(Builder::bucketPolicy)).constructor(BucketPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPolicy").build()).build();

    private static final SdkField<BlockPublicAccess> BLOCK_PUBLIC_ACCESS_FIELD = SdkField
            .<BlockPublicAccess> builder(MarshallingType.SDK_POJO).memberName("BlockPublicAccess")
            .getter(getter(BucketLevelPermissions::blockPublicAccess)).setter(setter(Builder::blockPublicAccess))
            .constructor(BlockPublicAccess::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockPublicAccess").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONTROL_LIST_FIELD,
            BUCKET_POLICY_FIELD, BLOCK_PUBLIC_ACCESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AccessControlList accessControlList;

    private final BucketPolicy bucketPolicy;

    private final BlockPublicAccess blockPublicAccess;

    private BucketLevelPermissions(BuilderImpl builder) {
        this.accessControlList = builder.accessControlList;
        this.bucketPolicy = builder.bucketPolicy;
        this.blockPublicAccess = builder.blockPublicAccess;
    }

    /**
     * <p>
     * Contains information on how Access Control Policies are applied to the bucket.
     * </p>
     * 
     * @return Contains information on how Access Control Policies are applied to the bucket.
     */
    public final AccessControlList accessControlList() {
        return accessControlList;
    }

    /**
     * <p>
     * Contains information on the bucket policies for the S3 bucket.
     * </p>
     * 
     * @return Contains information on the bucket policies for the S3 bucket.
     */
    public final BucketPolicy bucketPolicy() {
        return bucketPolicy;
    }

    /**
     * <p>
     * Contains information on which account level S3 Block Public Access settings are applied to the S3 bucket.
     * </p>
     * 
     * @return Contains information on which account level S3 Block Public Access settings are applied to the S3 bucket.
     */
    public final BlockPublicAccess blockPublicAccess() {
        return blockPublicAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessControlList());
        hashCode = 31 * hashCode + Objects.hashCode(bucketPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(blockPublicAccess());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketLevelPermissions)) {
            return false;
        }
        BucketLevelPermissions other = (BucketLevelPermissions) obj;
        return Objects.equals(accessControlList(), other.accessControlList())
                && Objects.equals(bucketPolicy(), other.bucketPolicy())
                && Objects.equals(blockPublicAccess(), other.blockPublicAccess());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BucketLevelPermissions").add("AccessControlList", accessControlList())
                .add("BucketPolicy", bucketPolicy()).add("BlockPublicAccess", blockPublicAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessControlList":
            return Optional.ofNullable(clazz.cast(accessControlList()));
        case "BucketPolicy":
            return Optional.ofNullable(clazz.cast(bucketPolicy()));
        case "BlockPublicAccess":
            return Optional.ofNullable(clazz.cast(blockPublicAccess()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessControlList", ACCESS_CONTROL_LIST_FIELD);
        map.put("bucketPolicy", BUCKET_POLICY_FIELD);
        map.put("blockPublicAccess", BLOCK_PUBLIC_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BucketLevelPermissions, T> g) {
        return obj -> g.apply((BucketLevelPermissions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketLevelPermissions> {
        /**
         * <p>
         * Contains information on how Access Control Policies are applied to the bucket.
         * </p>
         * 
         * @param accessControlList
         *        Contains information on how Access Control Policies are applied to the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlList(AccessControlList accessControlList);

        /**
         * <p>
         * Contains information on how Access Control Policies are applied to the bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessControlList.Builder} avoiding the
         * need to create one manually via {@link AccessControlList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessControlList.Builder#build()} is called immediately and its
         * result is passed to {@link #accessControlList(AccessControlList)}.
         * 
         * @param accessControlList
         *        a consumer that will call methods on {@link AccessControlList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessControlList(AccessControlList)
         */
        default Builder accessControlList(Consumer<AccessControlList.Builder> accessControlList) {
            return accessControlList(AccessControlList.builder().applyMutation(accessControlList).build());
        }

        /**
         * <p>
         * Contains information on the bucket policies for the S3 bucket.
         * </p>
         * 
         * @param bucketPolicy
         *        Contains information on the bucket policies for the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketPolicy(BucketPolicy bucketPolicy);

        /**
         * <p>
         * Contains information on the bucket policies for the S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link BucketPolicy.Builder} avoiding the need
         * to create one manually via {@link BucketPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BucketPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #bucketPolicy(BucketPolicy)}.
         * 
         * @param bucketPolicy
         *        a consumer that will call methods on {@link BucketPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketPolicy(BucketPolicy)
         */
        default Builder bucketPolicy(Consumer<BucketPolicy.Builder> bucketPolicy) {
            return bucketPolicy(BucketPolicy.builder().applyMutation(bucketPolicy).build());
        }

        /**
         * <p>
         * Contains information on which account level S3 Block Public Access settings are applied to the S3 bucket.
         * </p>
         * 
         * @param blockPublicAccess
         *        Contains information on which account level S3 Block Public Access settings are applied to the S3
         *        bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockPublicAccess(BlockPublicAccess blockPublicAccess);

        /**
         * <p>
         * Contains information on which account level S3 Block Public Access settings are applied to the S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link BlockPublicAccess.Builder} avoiding the
         * need to create one manually via {@link BlockPublicAccess#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlockPublicAccess.Builder#build()} is called immediately and its
         * result is passed to {@link #blockPublicAccess(BlockPublicAccess)}.
         * 
         * @param blockPublicAccess
         *        a consumer that will call methods on {@link BlockPublicAccess.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockPublicAccess(BlockPublicAccess)
         */
        default Builder blockPublicAccess(Consumer<BlockPublicAccess.Builder> blockPublicAccess) {
            return blockPublicAccess(BlockPublicAccess.builder().applyMutation(blockPublicAccess).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AccessControlList accessControlList;

        private BucketPolicy bucketPolicy;

        private BlockPublicAccess blockPublicAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketLevelPermissions model) {
            accessControlList(model.accessControlList);
            bucketPolicy(model.bucketPolicy);
            blockPublicAccess(model.blockPublicAccess);
        }

        public final AccessControlList.Builder getAccessControlList() {
            return accessControlList != null ? accessControlList.toBuilder() : null;
        }

        public final void setAccessControlList(AccessControlList.BuilderImpl accessControlList) {
            this.accessControlList = accessControlList != null ? accessControlList.build() : null;
        }

        @Override
        public final Builder accessControlList(AccessControlList accessControlList) {
            this.accessControlList = accessControlList;
            return this;
        }

        public final BucketPolicy.Builder getBucketPolicy() {
            return bucketPolicy != null ? bucketPolicy.toBuilder() : null;
        }

        public final void setBucketPolicy(BucketPolicy.BuilderImpl bucketPolicy) {
            this.bucketPolicy = bucketPolicy != null ? bucketPolicy.build() : null;
        }

        @Override
        public final Builder bucketPolicy(BucketPolicy bucketPolicy) {
            this.bucketPolicy = bucketPolicy;
            return this;
        }

        public final BlockPublicAccess.Builder getBlockPublicAccess() {
            return blockPublicAccess != null ? blockPublicAccess.toBuilder() : null;
        }

        public final void setBlockPublicAccess(BlockPublicAccess.BuilderImpl blockPublicAccess) {
            this.blockPublicAccess = blockPublicAccess != null ? blockPublicAccess.build() : null;
        }

        @Override
        public final Builder blockPublicAccess(BlockPublicAccess blockPublicAccess) {
            this.blockPublicAccess = blockPublicAccess;
            return this;
        }

        @Override
        public BucketLevelPermissions build() {
            return new BucketLevelPermissions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
