/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about Amazon ECS cluster runtime coverage details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoverageEcsClusterDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CoverageEcsClusterDetails.Builder, CoverageEcsClusterDetails> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(CoverageEcsClusterDetails::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<FargateDetails> FARGATE_DETAILS_FIELD = SdkField
            .<FargateDetails> builder(MarshallingType.SDK_POJO).memberName("FargateDetails")
            .getter(getter(CoverageEcsClusterDetails::fargateDetails)).setter(setter(Builder::fargateDetails))
            .constructor(FargateDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fargateDetails").build()).build();

    private static final SdkField<ContainerInstanceDetails> CONTAINER_INSTANCE_DETAILS_FIELD = SdkField
            .<ContainerInstanceDetails> builder(MarshallingType.SDK_POJO).memberName("ContainerInstanceDetails")
            .getter(getter(CoverageEcsClusterDetails::containerInstanceDetails))
            .setter(setter(Builder::containerInstanceDetails)).constructor(ContainerInstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstanceDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            FARGATE_DETAILS_FIELD, CONTAINER_INSTANCE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clusterName;

    private final FargateDetails fargateDetails;

    private final ContainerInstanceDetails containerInstanceDetails;

    private CoverageEcsClusterDetails(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.fargateDetails = builder.fargateDetails;
        this.containerInstanceDetails = builder.containerInstanceDetails;
    }

    /**
     * <p>
     * The name of the Amazon ECS cluster.
     * </p>
     * 
     * @return The name of the Amazon ECS cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * Information about the Fargate details associated with the Amazon ECS cluster.
     * </p>
     * 
     * @return Information about the Fargate details associated with the Amazon ECS cluster.
     */
    public final FargateDetails fargateDetails() {
        return fargateDetails;
    }

    /**
     * <p>
     * Information about the Amazon ECS container running on Amazon EC2 instance.
     * </p>
     * 
     * @return Information about the Amazon ECS container running on Amazon EC2 instance.
     */
    public final ContainerInstanceDetails containerInstanceDetails() {
        return containerInstanceDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(fargateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(containerInstanceDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageEcsClusterDetails)) {
            return false;
        }
        CoverageEcsClusterDetails other = (CoverageEcsClusterDetails) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(fargateDetails(), other.fargateDetails())
                && Objects.equals(containerInstanceDetails(), other.containerInstanceDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoverageEcsClusterDetails").add("ClusterName", clusterName())
                .add("FargateDetails", fargateDetails()).add("ContainerInstanceDetails", containerInstanceDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "FargateDetails":
            return Optional.ofNullable(clazz.cast(fargateDetails()));
        case "ContainerInstanceDetails":
            return Optional.ofNullable(clazz.cast(containerInstanceDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("fargateDetails", FARGATE_DETAILS_FIELD);
        map.put("containerInstanceDetails", CONTAINER_INSTANCE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoverageEcsClusterDetails, T> g) {
        return obj -> g.apply((CoverageEcsClusterDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoverageEcsClusterDetails> {
        /**
         * <p>
         * The name of the Amazon ECS cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of the Amazon ECS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * Information about the Fargate details associated with the Amazon ECS cluster.
         * </p>
         * 
         * @param fargateDetails
         *        Information about the Fargate details associated with the Amazon ECS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fargateDetails(FargateDetails fargateDetails);

        /**
         * <p>
         * Information about the Fargate details associated with the Amazon ECS cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link FargateDetails.Builder} avoiding the need
         * to create one manually via {@link FargateDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FargateDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #fargateDetails(FargateDetails)}.
         * 
         * @param fargateDetails
         *        a consumer that will call methods on {@link FargateDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fargateDetails(FargateDetails)
         */
        default Builder fargateDetails(Consumer<FargateDetails.Builder> fargateDetails) {
            return fargateDetails(FargateDetails.builder().applyMutation(fargateDetails).build());
        }

        /**
         * <p>
         * Information about the Amazon ECS container running on Amazon EC2 instance.
         * </p>
         * 
         * @param containerInstanceDetails
         *        Information about the Amazon ECS container running on Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerInstanceDetails(ContainerInstanceDetails containerInstanceDetails);

        /**
         * <p>
         * Information about the Amazon ECS container running on Amazon EC2 instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerInstanceDetails.Builder}
         * avoiding the need to create one manually via {@link ContainerInstanceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerInstanceDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #containerInstanceDetails(ContainerInstanceDetails)}.
         * 
         * @param containerInstanceDetails
         *        a consumer that will call methods on {@link ContainerInstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerInstanceDetails(ContainerInstanceDetails)
         */
        default Builder containerInstanceDetails(Consumer<ContainerInstanceDetails.Builder> containerInstanceDetails) {
            return containerInstanceDetails(ContainerInstanceDetails.builder().applyMutation(containerInstanceDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String clusterName;

        private FargateDetails fargateDetails;

        private ContainerInstanceDetails containerInstanceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageEcsClusterDetails model) {
            clusterName(model.clusterName);
            fargateDetails(model.fargateDetails);
            containerInstanceDetails(model.containerInstanceDetails);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final FargateDetails.Builder getFargateDetails() {
            return fargateDetails != null ? fargateDetails.toBuilder() : null;
        }

        public final void setFargateDetails(FargateDetails.BuilderImpl fargateDetails) {
            this.fargateDetails = fargateDetails != null ? fargateDetails.build() : null;
        }

        @Override
        public final Builder fargateDetails(FargateDetails fargateDetails) {
            this.fargateDetails = fargateDetails;
            return this;
        }

        public final ContainerInstanceDetails.Builder getContainerInstanceDetails() {
            return containerInstanceDetails != null ? containerInstanceDetails.toBuilder() : null;
        }

        public final void setContainerInstanceDetails(ContainerInstanceDetails.BuilderImpl containerInstanceDetails) {
            this.containerInstanceDetails = containerInstanceDetails != null ? containerInstanceDetails.build() : null;
        }

        @Override
        public final Builder containerInstanceDetails(ContainerInstanceDetails containerInstanceDetails) {
            this.containerInstanceDetails = containerInstanceDetails;
            return this;
        }

        @Override
        public CoverageEcsClusterDetails build() {
            return new CoverageEcsClusterDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
