/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMalwareProtectionPlanRequest extends GuardDutyRequest implements
        ToCopyableBuilder<CreateMalwareProtectionPlanRequest.Builder, CreateMalwareProtectionPlanRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateMalwareProtectionPlanRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(CreateMalwareProtectionPlanRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final SdkField<CreateProtectedResource> PROTECTED_RESOURCE_FIELD = SdkField
            .<CreateProtectedResource> builder(MarshallingType.SDK_POJO).memberName("ProtectedResource")
            .getter(getter(CreateMalwareProtectionPlanRequest::protectedResource)).setter(setter(Builder::protectedResource))
            .constructor(CreateProtectedResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protectedResource").build()).build();

    private static final SdkField<MalwareProtectionPlanActions> ACTIONS_FIELD = SdkField
            .<MalwareProtectionPlanActions> builder(MarshallingType.SDK_POJO).memberName("Actions")
            .getter(getter(CreateMalwareProtectionPlanRequest::actions)).setter(setter(Builder::actions))
            .constructor(MalwareProtectionPlanActions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateMalwareProtectionPlanRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            ROLE_FIELD, PROTECTED_RESOURCE_FIELD, ACTIONS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String role;

    private final CreateProtectedResource protectedResource;

    private final MalwareProtectionPlanActions actions;

    private final Map<String, String> tags;

    private CreateMalwareProtectionPlanRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.role = builder.role;
        this.protectedResource = builder.protectedResource;
        this.actions = builder.actions;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The idempotency token for the create request.
     * </p>
     * 
     * @return The idempotency token for the create request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the IAM role that has the permissions to scan and add tags to the associated
     * protected resource.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the IAM role that has the permissions to scan and add tags to the
     *         associated protected resource.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * Information about the protected resource that is associated with the created Malware Protection plan. Presently,
     * <code>S3Bucket</code> is the only supported protected resource.
     * </p>
     * 
     * @return Information about the protected resource that is associated with the created Malware Protection plan.
     *         Presently, <code>S3Bucket</code> is the only supported protected resource.
     */
    public final CreateProtectedResource protectedResource() {
        return protectedResource;
    }

    /**
     * <p>
     * Information about whether the tags will be added to the S3 object after scanning.
     * </p>
     * 
     * @return Information about whether the tags will be added to the S3 object after scanning.
     */
    public final MalwareProtectionPlanActions actions() {
        return actions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags added to the Malware Protection plan resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags added to the Malware Protection plan resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(protectedResource());
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMalwareProtectionPlanRequest)) {
            return false;
        }
        CreateMalwareProtectionPlanRequest other = (CreateMalwareProtectionPlanRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(role(), other.role())
                && Objects.equals(protectedResource(), other.protectedResource()) && Objects.equals(actions(), other.actions())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMalwareProtectionPlanRequest").add("ClientToken", clientToken()).add("Role", role())
                .add("ProtectedResource", protectedResource()).add("Actions", actions()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "ProtectedResource":
            return Optional.ofNullable(clazz.cast(protectedResource()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("role", ROLE_FIELD);
        map.put("protectedResource", PROTECTED_RESOURCE_FIELD);
        map.put("actions", ACTIONS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMalwareProtectionPlanRequest, T> g) {
        return obj -> g.apply((CreateMalwareProtectionPlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMalwareProtectionPlanRequest> {
        /**
         * <p>
         * The idempotency token for the create request.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token for the create request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the IAM role that has the permissions to scan and add tags to the associated
         * protected resource.
         * </p>
         * 
         * @param role
         *        Amazon Resource Name (ARN) of the IAM role that has the permissions to scan and add tags to the
         *        associated protected resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * Information about the protected resource that is associated with the created Malware Protection plan.
         * Presently, <code>S3Bucket</code> is the only supported protected resource.
         * </p>
         * 
         * @param protectedResource
         *        Information about the protected resource that is associated with the created Malware Protection plan.
         *        Presently, <code>S3Bucket</code> is the only supported protected resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedResource(CreateProtectedResource protectedResource);

        /**
         * <p>
         * Information about the protected resource that is associated with the created Malware Protection plan.
         * Presently, <code>S3Bucket</code> is the only supported protected resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateProtectedResource.Builder} avoiding
         * the need to create one manually via {@link CreateProtectedResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateProtectedResource.Builder#build()} is called immediately
         * and its result is passed to {@link #protectedResource(CreateProtectedResource)}.
         * 
         * @param protectedResource
         *        a consumer that will call methods on {@link CreateProtectedResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protectedResource(CreateProtectedResource)
         */
        default Builder protectedResource(Consumer<CreateProtectedResource.Builder> protectedResource) {
            return protectedResource(CreateProtectedResource.builder().applyMutation(protectedResource).build());
        }

        /**
         * <p>
         * Information about whether the tags will be added to the S3 object after scanning.
         * </p>
         * 
         * @param actions
         *        Information about whether the tags will be added to the S3 object after scanning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(MalwareProtectionPlanActions actions);

        /**
         * <p>
         * Information about whether the tags will be added to the S3 object after scanning.
         * </p>
         * This is a convenience method that creates an instance of the {@link MalwareProtectionPlanActions.Builder}
         * avoiding the need to create one manually via {@link MalwareProtectionPlanActions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MalwareProtectionPlanActions.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(MalwareProtectionPlanActions)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link MalwareProtectionPlanActions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(MalwareProtectionPlanActions)
         */
        default Builder actions(Consumer<MalwareProtectionPlanActions.Builder> actions) {
            return actions(MalwareProtectionPlanActions.builder().applyMutation(actions).build());
        }

        /**
         * <p>
         * Tags added to the Malware Protection plan resource.
         * </p>
         * 
         * @param tags
         *        Tags added to the Malware Protection plan resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String role;

        private CreateProtectedResource protectedResource;

        private MalwareProtectionPlanActions actions;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMalwareProtectionPlanRequest model) {
            super(model);
            clientToken(model.clientToken);
            role(model.role);
            protectedResource(model.protectedResource);
            actions(model.actions);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final CreateProtectedResource.Builder getProtectedResource() {
            return protectedResource != null ? protectedResource.toBuilder() : null;
        }

        public final void setProtectedResource(CreateProtectedResource.BuilderImpl protectedResource) {
            this.protectedResource = protectedResource != null ? protectedResource.build() : null;
        }

        @Override
        public final Builder protectedResource(CreateProtectedResource protectedResource) {
            this.protectedResource = protectedResource;
            return this;
        }

        public final MalwareProtectionPlanActions.Builder getActions() {
            return actions != null ? actions.toBuilder() : null;
        }

        public final void setActions(MalwareProtectionPlanActions.BuilderImpl actions) {
            this.actions = actions != null ? actions.build() : null;
        }

        @Override
        public final Builder actions(MalwareProtectionPlanActions actions) {
            this.actions = actions;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMalwareProtectionPlanRequest build() {
            return new CreateMalwareProtectionPlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
