/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMalwareProtectionPlanResponse extends GuardDutyResponse implements
        ToCopyableBuilder<CreateMalwareProtectionPlanResponse.Builder, CreateMalwareProtectionPlanResponse> {
    private static final SdkField<String> MALWARE_PROTECTION_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MalwareProtectionPlanId").getter(getter(CreateMalwareProtectionPlanResponse::malwareProtectionPlanId))
            .setter(setter(Builder::malwareProtectionPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("malwareProtectionPlanId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MALWARE_PROTECTION_PLAN_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String malwareProtectionPlanId;

    private CreateMalwareProtectionPlanResponse(BuilderImpl builder) {
        super(builder);
        this.malwareProtectionPlanId = builder.malwareProtectionPlanId;
    }

    /**
     * <p>
     * A unique identifier associated with the Malware Protection plan resource.
     * </p>
     * 
     * @return A unique identifier associated with the Malware Protection plan resource.
     */
    public final String malwareProtectionPlanId() {
        return malwareProtectionPlanId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(malwareProtectionPlanId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMalwareProtectionPlanResponse)) {
            return false;
        }
        CreateMalwareProtectionPlanResponse other = (CreateMalwareProtectionPlanResponse) obj;
        return Objects.equals(malwareProtectionPlanId(), other.malwareProtectionPlanId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMalwareProtectionPlanResponse").add("MalwareProtectionPlanId", malwareProtectionPlanId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MalwareProtectionPlanId":
            return Optional.ofNullable(clazz.cast(malwareProtectionPlanId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("malwareProtectionPlanId", MALWARE_PROTECTION_PLAN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMalwareProtectionPlanResponse, T> g) {
        return obj -> g.apply((CreateMalwareProtectionPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMalwareProtectionPlanResponse> {
        /**
         * <p>
         * A unique identifier associated with the Malware Protection plan resource.
         * </p>
         * 
         * @param malwareProtectionPlanId
         *        A unique identifier associated with the Malware Protection plan resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malwareProtectionPlanId(String malwareProtectionPlanId);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private String malwareProtectionPlanId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMalwareProtectionPlanResponse model) {
            super(model);
            malwareProtectionPlanId(model.malwareProtectionPlanId);
        }

        public final String getMalwareProtectionPlanId() {
            return malwareProtectionPlanId;
        }

        public final void setMalwareProtectionPlanId(String malwareProtectionPlanId) {
            this.malwareProtectionPlanId = malwareProtectionPlanId;
        }

        @Override
        public final Builder malwareProtectionPlanId(String malwareProtectionPlanId) {
            this.malwareProtectionPlanId = malwareProtectionPlanId;
            return this;
        }

        @Override
        public CreateMalwareProtectionPlanResponse build() {
            return new CreateMalwareProtectionPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
