/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the protected resource that is associated with the created Malware Protection plan. Presently,
 * <code>S3Bucket</code> is the only supported protected resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProtectedResource implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateProtectedResource.Builder, CreateProtectedResource> {
    private static final SdkField<CreateS3BucketResource> S3_BUCKET_FIELD = SdkField
            .<CreateS3BucketResource> builder(MarshallingType.SDK_POJO).memberName("S3Bucket")
            .getter(getter(CreateProtectedResource::s3Bucket)).setter(setter(Builder::s3Bucket))
            .constructor(CreateS3BucketResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CreateS3BucketResource s3Bucket;

    private CreateProtectedResource(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
    }

    /**
     * <p>
     * Information about the protected S3 bucket resource.
     * </p>
     * 
     * @return Information about the protected S3 bucket resource.
     */
    public final CreateS3BucketResource s3Bucket() {
        return s3Bucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProtectedResource)) {
            return false;
        }
        CreateProtectedResource other = (CreateProtectedResource) obj;
        return Objects.equals(s3Bucket(), other.s3Bucket());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProtectedResource").add("S3Bucket", s3Bucket()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3Bucket", S3_BUCKET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProtectedResource, T> g) {
        return obj -> g.apply((CreateProtectedResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateProtectedResource> {
        /**
         * <p>
         * Information about the protected S3 bucket resource.
         * </p>
         * 
         * @param s3Bucket
         *        Information about the protected S3 bucket resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(CreateS3BucketResource s3Bucket);

        /**
         * <p>
         * Information about the protected S3 bucket resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateS3BucketResource.Builder} avoiding
         * the need to create one manually via {@link CreateS3BucketResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateS3BucketResource.Builder#build()} is called immediately and
         * its result is passed to {@link #s3Bucket(CreateS3BucketResource)}.
         * 
         * @param s3Bucket
         *        a consumer that will call methods on {@link CreateS3BucketResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Bucket(CreateS3BucketResource)
         */
        default Builder s3Bucket(Consumer<CreateS3BucketResource.Builder> s3Bucket) {
            return s3Bucket(CreateS3BucketResource.builder().applyMutation(s3Bucket).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CreateS3BucketResource s3Bucket;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProtectedResource model) {
            s3Bucket(model.s3Bucket);
        }

        public final CreateS3BucketResource.Builder getS3Bucket() {
            return s3Bucket != null ? s3Bucket.toBuilder() : null;
        }

        public final void setS3Bucket(CreateS3BucketResource.BuilderImpl s3Bucket) {
            this.s3Bucket = s3Bucket != null ? s3Bucket.build() : null;
        }

        @Override
        public final Builder s3Bucket(CreateS3BucketResource s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        @Override
        public CreateProtectedResource build() {
            return new CreateProtectedResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
