/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePublishingDestinationRequest extends GuardDutyRequest implements
        ToCopyableBuilder<CreatePublishingDestinationRequest.Builder, CreatePublishingDestinationRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(CreatePublishingDestinationRequest::detectorId))
            .setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationType").getter(getter(CreatePublishingDestinationRequest::destinationTypeAsString))
            .setter(setter(Builder::destinationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationType").build()).build();

    private static final SdkField<DestinationProperties> DESTINATION_PROPERTIES_FIELD = SdkField
            .<DestinationProperties> builder(MarshallingType.SDK_POJO).memberName("DestinationProperties")
            .getter(getter(CreatePublishingDestinationRequest::destinationProperties))
            .setter(setter(Builder::destinationProperties)).constructor(DestinationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationProperties").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreatePublishingDestinationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            DESTINATION_TYPE_FIELD, DESTINATION_PROPERTIES_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String detectorId;

    private final String destinationType;

    private final DestinationProperties destinationProperties;

    private final String clientToken;

    private CreatePublishingDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.destinationType = builder.destinationType;
        this.destinationProperties = builder.destinationProperties;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the GuardDuty detector associated with the publishing destination.
     * </p>
     * <p>
     * To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty console, or run
     * the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
     * API.
     * </p>
     * 
     * @return The ID of the GuardDuty detector associated with the publishing destination.</p>
     *         <p>
     *         To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty
     *         console, or run the <a
     *         href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
     *         API.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The type of resource for the publishing destination. Currently only Amazon S3 buckets are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link DestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return The type of resource for the publishing destination. Currently only Amazon S3 buckets are supported.
     * @see DestinationType
     */
    public final DestinationType destinationType() {
        return DestinationType.fromValue(destinationType);
    }

    /**
     * <p>
     * The type of resource for the publishing destination. Currently only Amazon S3 buckets are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link DestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return The type of resource for the publishing destination. Currently only Amazon S3 buckets are supported.
     * @see DestinationType
     */
    public final String destinationTypeAsString() {
        return destinationType;
    }

    /**
     * <p>
     * The properties of the publishing destination, including the ARNs for the destination and the KMS key used for
     * encryption.
     * </p>
     * 
     * @return The properties of the publishing destination, including the ARNs for the destination and the KMS key used
     *         for encryption.
     */
    public final DestinationProperties destinationProperties() {
        return destinationProperties;
    }

    /**
     * <p>
     * The idempotency token for the request.
     * </p>
     * 
     * @return The idempotency token for the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationProperties());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePublishingDestinationRequest)) {
            return false;
        }
        CreatePublishingDestinationRequest other = (CreatePublishingDestinationRequest) obj;
        return Objects.equals(detectorId(), other.detectorId())
                && Objects.equals(destinationTypeAsString(), other.destinationTypeAsString())
                && Objects.equals(destinationProperties(), other.destinationProperties())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePublishingDestinationRequest").add("DetectorId", detectorId())
                .add("DestinationType", destinationTypeAsString()).add("DestinationProperties", destinationProperties())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "DestinationType":
            return Optional.ofNullable(clazz.cast(destinationTypeAsString()));
        case "DestinationProperties":
            return Optional.ofNullable(clazz.cast(destinationProperties()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("destinationType", DESTINATION_TYPE_FIELD);
        map.put("destinationProperties", DESTINATION_PROPERTIES_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePublishingDestinationRequest, T> g) {
        return obj -> g.apply((CreatePublishingDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePublishingDestinationRequest> {
        /**
         * <p>
         * The ID of the GuardDuty detector associated with the publishing destination.
         * </p>
         * <p>
         * To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty console, or
         * run the <a
         * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
         * API.
         * </p>
         * 
         * @param detectorId
         *        The ID of the GuardDuty detector associated with the publishing destination.</p>
         *        <p>
         *        To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty
         *        console, or run the <a
         *        href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html"
         *        >ListDetectors</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The type of resource for the publishing destination. Currently only Amazon S3 buckets are supported.
         * </p>
         * 
         * @param destinationType
         *        The type of resource for the publishing destination. Currently only Amazon S3 buckets are supported.
         * @see DestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationType
         */
        Builder destinationType(String destinationType);

        /**
         * <p>
         * The type of resource for the publishing destination. Currently only Amazon S3 buckets are supported.
         * </p>
         * 
         * @param destinationType
         *        The type of resource for the publishing destination. Currently only Amazon S3 buckets are supported.
         * @see DestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationType
         */
        Builder destinationType(DestinationType destinationType);

        /**
         * <p>
         * The properties of the publishing destination, including the ARNs for the destination and the KMS key used for
         * encryption.
         * </p>
         * 
         * @param destinationProperties
         *        The properties of the publishing destination, including the ARNs for the destination and the KMS key
         *        used for encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationProperties(DestinationProperties destinationProperties);

        /**
         * <p>
         * The properties of the publishing destination, including the ARNs for the destination and the KMS key used for
         * encryption.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationProperties.Builder} avoiding
         * the need to create one manually via {@link DestinationProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #destinationProperties(DestinationProperties)}.
         * 
         * @param destinationProperties
         *        a consumer that will call methods on {@link DestinationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationProperties(DestinationProperties)
         */
        default Builder destinationProperties(Consumer<DestinationProperties.Builder> destinationProperties) {
            return destinationProperties(DestinationProperties.builder().applyMutation(destinationProperties).build());
        }

        /**
         * <p>
         * The idempotency token for the request.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private String destinationType;

        private DestinationProperties destinationProperties;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePublishingDestinationRequest model) {
            super(model);
            detectorId(model.detectorId);
            destinationType(model.destinationType);
            destinationProperties(model.destinationProperties);
            clientToken(model.clientToken);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getDestinationType() {
            return destinationType;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(DestinationType destinationType) {
            this.destinationType(destinationType == null ? null : destinationType.toString());
            return this;
        }

        public final DestinationProperties.Builder getDestinationProperties() {
            return destinationProperties != null ? destinationProperties.toBuilder() : null;
        }

        public final void setDestinationProperties(DestinationProperties.BuilderImpl destinationProperties) {
            this.destinationProperties = destinationProperties != null ? destinationProperties.build() : null;
        }

        @Override
        public final Builder destinationProperties(DestinationProperties destinationProperties) {
            this.destinationProperties = destinationProperties;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePublishingDestinationRequest build() {
            return new CreatePublishingDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
