/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterCondition implements SdkPojo, Serializable, ToCopyableBuilder<FilterCondition.Builder, FilterCondition> {
    private static final SdkField<String> EQUALS_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EqualsValue").getter(getter(FilterCondition::equalsValue)).setter(setter(Builder::equalsValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("equalsValue").build()).build();

    private static final SdkField<Long> GREATER_THAN_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("GreaterThan").getter(getter(FilterCondition::greaterThan)).setter(setter(Builder::greaterThan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greaterThan").build()).build();

    private static final SdkField<Long> LESS_THAN_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("LessThan")
            .getter(getter(FilterCondition::lessThan)).setter(setter(Builder::lessThan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lessThan").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQUALS_VALUE_FIELD,
            GREATER_THAN_FIELD, LESS_THAN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String equalsValue;

    private final Long greaterThan;

    private final Long lessThan;

    private FilterCondition(BuilderImpl builder) {
        this.equalsValue = builder.equalsValue;
        this.greaterThan = builder.greaterThan;
        this.lessThan = builder.lessThan;
    }

    /**
     * <p>
     * Represents an <i>equal</i> <b/> condition to be applied to a single field when querying for scan entries.
     * </p>
     * 
     * @return Represents an <i>equal</i> <b/> condition to be applied to a single field when querying for scan entries.
     */
    public final String equalsValue() {
        return equalsValue;
    }

    /**
     * <p>
     * Represents a <i>greater than</i> condition to be applied to a single field when querying for scan entries.
     * </p>
     * 
     * @return Represents a <i>greater than</i> condition to be applied to a single field when querying for scan
     *         entries.
     */
    public final Long greaterThan() {
        return greaterThan;
    }

    /**
     * <p>
     * Represents a <i>less than</i> condition to be applied to a single field when querying for scan entries.
     * </p>
     * 
     * @return Represents a <i>less than</i> condition to be applied to a single field when querying for scan entries.
     */
    public final Long lessThan() {
        return lessThan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(equalsValue());
        hashCode = 31 * hashCode + Objects.hashCode(greaterThan());
        hashCode = 31 * hashCode + Objects.hashCode(lessThan());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterCondition)) {
            return false;
        }
        FilterCondition other = (FilterCondition) obj;
        return Objects.equals(equalsValue(), other.equalsValue()) && Objects.equals(greaterThan(), other.greaterThan())
                && Objects.equals(lessThan(), other.lessThan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterCondition").add("EqualsValue", equalsValue()).add("GreaterThan", greaterThan())
                .add("LessThan", lessThan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EqualsValue":
            return Optional.ofNullable(clazz.cast(equalsValue()));
        case "GreaterThan":
            return Optional.ofNullable(clazz.cast(greaterThan()));
        case "LessThan":
            return Optional.ofNullable(clazz.cast(lessThan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("equalsValue", EQUALS_VALUE_FIELD);
        map.put("greaterThan", GREATER_THAN_FIELD);
        map.put("lessThan", LESS_THAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterCondition, T> g) {
        return obj -> g.apply((FilterCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterCondition> {
        /**
         * <p>
         * Represents an <i>equal</i> <b/> condition to be applied to a single field when querying for scan entries.
         * </p>
         * 
         * @param equalsValue
         *        Represents an <i>equal</i> <b/> condition to be applied to a single field when querying for scan
         *        entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalsValue(String equalsValue);

        /**
         * <p>
         * Represents a <i>greater than</i> condition to be applied to a single field when querying for scan entries.
         * </p>
         * 
         * @param greaterThan
         *        Represents a <i>greater than</i> condition to be applied to a single field when querying for scan
         *        entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greaterThan(Long greaterThan);

        /**
         * <p>
         * Represents a <i>less than</i> condition to be applied to a single field when querying for scan entries.
         * </p>
         * 
         * @param lessThan
         *        Represents a <i>less than</i> condition to be applied to a single field when querying for scan
         *        entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lessThan(Long lessThan);
    }

    static final class BuilderImpl implements Builder {
        private String equalsValue;

        private Long greaterThan;

        private Long lessThan;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterCondition model) {
            equalsValue(model.equalsValue);
            greaterThan(model.greaterThan);
            lessThan(model.lessThan);
        }

        public final String getEqualsValue() {
            return equalsValue;
        }

        public final void setEqualsValue(String equalsValue) {
            this.equalsValue = equalsValue;
        }

        @Override
        public final Builder equalsValue(String equalsValue) {
            this.equalsValue = equalsValue;
            return this;
        }

        public final Long getGreaterThan() {
            return greaterThan;
        }

        public final void setGreaterThan(Long greaterThan) {
            this.greaterThan = greaterThan;
        }

        @Override
        public final Builder greaterThan(Long greaterThan) {
            this.greaterThan = greaterThan;
            return this;
        }

        public final Long getLessThan() {
            return lessThan;
        }

        public final void setLessThan(Long lessThan) {
            this.lessThan = lessThan;
        }

        @Override
        public final Builder lessThan(Long lessThan) {
            this.lessThan = lessThan;
            return this;
        }

        @Override
        public FilterCondition build() {
            return new FilterCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
