/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about finding statistics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingStatistics.Builder, FindingStatistics> {
    private static final SdkField<Map<String, Integer>> COUNT_BY_SEVERITY_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("CountBySeverity")
            .getter(getter(FindingStatistics::countBySeverity))
            .setter(setter(Builder::countBySeverity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countBySeverity").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<AccountStatistics>> GROUPED_BY_ACCOUNT_FIELD = SdkField
            .<List<AccountStatistics>> builder(MarshallingType.LIST)
            .memberName("GroupedByAccount")
            .getter(getter(FindingStatistics::groupedByAccount))
            .setter(setter(Builder::groupedByAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupedByAccount").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountStatistics> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountStatistics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateStatistics>> GROUPED_BY_DATE_FIELD = SdkField
            .<List<DateStatistics>> builder(MarshallingType.LIST)
            .memberName("GroupedByDate")
            .getter(getter(FindingStatistics::groupedByDate))
            .setter(setter(Builder::groupedByDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupedByDate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateStatistics> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateStatistics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FindingTypeStatistics>> GROUPED_BY_FINDING_TYPE_FIELD = SdkField
            .<List<FindingTypeStatistics>> builder(MarshallingType.LIST)
            .memberName("GroupedByFindingType")
            .getter(getter(FindingStatistics::groupedByFindingType))
            .setter(setter(Builder::groupedByFindingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupedByFindingType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FindingTypeStatistics> builder(MarshallingType.SDK_POJO)
                                            .constructor(FindingTypeStatistics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceStatistics>> GROUPED_BY_RESOURCE_FIELD = SdkField
            .<List<ResourceStatistics>> builder(MarshallingType.LIST)
            .memberName("GroupedByResource")
            .getter(getter(FindingStatistics::groupedByResource))
            .setter(setter(Builder::groupedByResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupedByResource").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceStatistics> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceStatistics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SeverityStatistics>> GROUPED_BY_SEVERITY_FIELD = SdkField
            .<List<SeverityStatistics>> builder(MarshallingType.LIST)
            .memberName("GroupedBySeverity")
            .getter(getter(FindingStatistics::groupedBySeverity))
            .setter(setter(Builder::groupedBySeverity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupedBySeverity").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SeverityStatistics> builder(MarshallingType.SDK_POJO)
                                            .constructor(SeverityStatistics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_BY_SEVERITY_FIELD,
            GROUPED_BY_ACCOUNT_FIELD, GROUPED_BY_DATE_FIELD, GROUPED_BY_FINDING_TYPE_FIELD, GROUPED_BY_RESOURCE_FIELD,
            GROUPED_BY_SEVERITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, Integer> countBySeverity;

    private final List<AccountStatistics> groupedByAccount;

    private final List<DateStatistics> groupedByDate;

    private final List<FindingTypeStatistics> groupedByFindingType;

    private final List<ResourceStatistics> groupedByResource;

    private final List<SeverityStatistics> groupedBySeverity;

    private FindingStatistics(BuilderImpl builder) {
        this.countBySeverity = builder.countBySeverity;
        this.groupedByAccount = builder.groupedByAccount;
        this.groupedByDate = builder.groupedByDate;
        this.groupedByFindingType = builder.groupedByFindingType;
        this.groupedByResource = builder.groupedByResource;
        this.groupedBySeverity = builder.groupedBySeverity;
    }

    /**
     * For responses, this returns true if the service returned a value for the CountBySeverity property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     *
     * @deprecated This parameter is deprecated. Please set GroupBy to 'SEVERITY' to return GroupedBySeverity instead.
     */
    @Deprecated
    public final boolean hasCountBySeverity() {
        return countBySeverity != null && !(countBySeverity instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Represents a list of map of severity to count statistics for a set of findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCountBySeverity} method.
     * </p>
     * 
     * @return Represents a list of map of severity to count statistics for a set of findings.
     * @deprecated This parameter is deprecated. Please set GroupBy to 'SEVERITY' to return GroupedBySeverity instead.
     */
    @Deprecated
    public final Map<String, Integer> countBySeverity() {
        return countBySeverity;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupedByAccount property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupedByAccount() {
        return groupedByAccount != null && !(groupedByAccount instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents a list of map of accounts with a findings count associated with each account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupedByAccount} method.
     * </p>
     * 
     * @return Represents a list of map of accounts with a findings count associated with each account.
     */
    public final List<AccountStatistics> groupedByAccount() {
        return groupedByAccount;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupedByDate property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupedByDate() {
        return groupedByDate != null && !(groupedByDate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents a list of map of dates with a count of total findings generated on each date per severity level.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupedByDate} method.
     * </p>
     * 
     * @return Represents a list of map of dates with a count of total findings generated on each date per severity
     *         level.
     */
    public final List<DateStatistics> groupedByDate() {
        return groupedByDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupedByFindingType property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupedByFindingType() {
        return groupedByFindingType != null && !(groupedByFindingType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents a list of map of finding types with a count of total findings generated for each type.
     * </p>
     * <p>
     * Based on the <code>orderBy</code> parameter, this request returns either the most occurring finding types or the
     * least occurring finding types. If the <code>orderBy</code> parameter is <code>ASC</code>, this will represent the
     * least occurring finding types in your account; otherwise, this will represent the most occurring finding types.
     * The default value of <code>orderBy</code> is <code>DESC</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupedByFindingType} method.
     * </p>
     * 
     * @return Represents a list of map of finding types with a count of total findings generated for each type. </p>
     *         <p>
     *         Based on the <code>orderBy</code> parameter, this request returns either the most occurring finding types
     *         or the least occurring finding types. If the <code>orderBy</code> parameter is <code>ASC</code>, this
     *         will represent the least occurring finding types in your account; otherwise, this will represent the most
     *         occurring finding types. The default value of <code>orderBy</code> is <code>DESC</code>.
     */
    public final List<FindingTypeStatistics> groupedByFindingType() {
        return groupedByFindingType;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupedByResource property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupedByResource() {
        return groupedByResource != null && !(groupedByResource instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents a list of map of top resources with a count of total findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupedByResource} method.
     * </p>
     * 
     * @return Represents a list of map of top resources with a count of total findings.
     */
    public final List<ResourceStatistics> groupedByResource() {
        return groupedByResource;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupedBySeverity property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupedBySeverity() {
        return groupedBySeverity != null && !(groupedBySeverity instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents a list of map of total findings for each severity level.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupedBySeverity} method.
     * </p>
     * 
     * @return Represents a list of map of total findings for each severity level.
     */
    public final List<SeverityStatistics> groupedBySeverity() {
        return groupedBySeverity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCountBySeverity() ? countBySeverity() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupedByAccount() ? groupedByAccount() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupedByDate() ? groupedByDate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupedByFindingType() ? groupedByFindingType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupedByResource() ? groupedByResource() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupedBySeverity() ? groupedBySeverity() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingStatistics)) {
            return false;
        }
        FindingStatistics other = (FindingStatistics) obj;
        return hasCountBySeverity() == other.hasCountBySeverity() && Objects.equals(countBySeverity(), other.countBySeverity())
                && hasGroupedByAccount() == other.hasGroupedByAccount()
                && Objects.equals(groupedByAccount(), other.groupedByAccount()) && hasGroupedByDate() == other.hasGroupedByDate()
                && Objects.equals(groupedByDate(), other.groupedByDate())
                && hasGroupedByFindingType() == other.hasGroupedByFindingType()
                && Objects.equals(groupedByFindingType(), other.groupedByFindingType())
                && hasGroupedByResource() == other.hasGroupedByResource()
                && Objects.equals(groupedByResource(), other.groupedByResource())
                && hasGroupedBySeverity() == other.hasGroupedBySeverity()
                && Objects.equals(groupedBySeverity(), other.groupedBySeverity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingStatistics").add("CountBySeverity", hasCountBySeverity() ? countBySeverity() : null)
                .add("GroupedByAccount", hasGroupedByAccount() ? groupedByAccount() : null)
                .add("GroupedByDate", hasGroupedByDate() ? groupedByDate() : null)
                .add("GroupedByFindingType", hasGroupedByFindingType() ? groupedByFindingType() : null)
                .add("GroupedByResource", hasGroupedByResource() ? groupedByResource() : null)
                .add("GroupedBySeverity", hasGroupedBySeverity() ? groupedBySeverity() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CountBySeverity":
            return Optional.ofNullable(clazz.cast(countBySeverity()));
        case "GroupedByAccount":
            return Optional.ofNullable(clazz.cast(groupedByAccount()));
        case "GroupedByDate":
            return Optional.ofNullable(clazz.cast(groupedByDate()));
        case "GroupedByFindingType":
            return Optional.ofNullable(clazz.cast(groupedByFindingType()));
        case "GroupedByResource":
            return Optional.ofNullable(clazz.cast(groupedByResource()));
        case "GroupedBySeverity":
            return Optional.ofNullable(clazz.cast(groupedBySeverity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("countBySeverity", COUNT_BY_SEVERITY_FIELD);
        map.put("groupedByAccount", GROUPED_BY_ACCOUNT_FIELD);
        map.put("groupedByDate", GROUPED_BY_DATE_FIELD);
        map.put("groupedByFindingType", GROUPED_BY_FINDING_TYPE_FIELD);
        map.put("groupedByResource", GROUPED_BY_RESOURCE_FIELD);
        map.put("groupedBySeverity", GROUPED_BY_SEVERITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingStatistics, T> g) {
        return obj -> g.apply((FindingStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingStatistics> {
        /**
         * <p>
         * Represents a list of map of severity to count statistics for a set of findings.
         * </p>
         * 
         * @param countBySeverity
         *        Represents a list of map of severity to count statistics for a set of findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This parameter is deprecated. Please set GroupBy to 'SEVERITY' to return GroupedBySeverity
         *             instead.
         */
        @Deprecated
        Builder countBySeverity(Map<String, Integer> countBySeverity);

        /**
         * <p>
         * Represents a list of map of accounts with a findings count associated with each account.
         * </p>
         * 
         * @param groupedByAccount
         *        Represents a list of map of accounts with a findings count associated with each account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupedByAccount(Collection<AccountStatistics> groupedByAccount);

        /**
         * <p>
         * Represents a list of map of accounts with a findings count associated with each account.
         * </p>
         * 
         * @param groupedByAccount
         *        Represents a list of map of accounts with a findings count associated with each account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupedByAccount(AccountStatistics... groupedByAccount);

        /**
         * <p>
         * Represents a list of map of accounts with a findings count associated with each account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.AccountStatistics.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.guardduty.model.AccountStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.AccountStatistics.Builder#build()} is called
         * immediately and its result is passed to {@link #groupedByAccount(List<AccountStatistics>)}.
         * 
         * @param groupedByAccount
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.AccountStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupedByAccount(java.util.Collection<AccountStatistics>)
         */
        Builder groupedByAccount(Consumer<AccountStatistics.Builder>... groupedByAccount);

        /**
         * <p>
         * Represents a list of map of dates with a count of total findings generated on each date per severity level.
         * </p>
         * 
         * @param groupedByDate
         *        Represents a list of map of dates with a count of total findings generated on each date per severity
         *        level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupedByDate(Collection<DateStatistics> groupedByDate);

        /**
         * <p>
         * Represents a list of map of dates with a count of total findings generated on each date per severity level.
         * </p>
         * 
         * @param groupedByDate
         *        Represents a list of map of dates with a count of total findings generated on each date per severity
         *        level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupedByDate(DateStatistics... groupedByDate);

        /**
         * <p>
         * Represents a list of map of dates with a count of total findings generated on each date per severity level.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.DateStatistics.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.guardduty.model.DateStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.DateStatistics.Builder#build()} is called immediately
         * and its result is passed to {@link #groupedByDate(List<DateStatistics>)}.
         * 
         * @param groupedByDate
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.DateStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupedByDate(java.util.Collection<DateStatistics>)
         */
        Builder groupedByDate(Consumer<DateStatistics.Builder>... groupedByDate);

        /**
         * <p>
         * Represents a list of map of finding types with a count of total findings generated for each type.
         * </p>
         * <p>
         * Based on the <code>orderBy</code> parameter, this request returns either the most occurring finding types or
         * the least occurring finding types. If the <code>orderBy</code> parameter is <code>ASC</code>, this will
         * represent the least occurring finding types in your account; otherwise, this will represent the most
         * occurring finding types. The default value of <code>orderBy</code> is <code>DESC</code>.
         * </p>
         * 
         * @param groupedByFindingType
         *        Represents a list of map of finding types with a count of total findings generated for each type. </p>
         *        <p>
         *        Based on the <code>orderBy</code> parameter, this request returns either the most occurring finding
         *        types or the least occurring finding types. If the <code>orderBy</code> parameter is <code>ASC</code>,
         *        this will represent the least occurring finding types in your account; otherwise, this will represent
         *        the most occurring finding types. The default value of <code>orderBy</code> is <code>DESC</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupedByFindingType(Collection<FindingTypeStatistics> groupedByFindingType);

        /**
         * <p>
         * Represents a list of map of finding types with a count of total findings generated for each type.
         * </p>
         * <p>
         * Based on the <code>orderBy</code> parameter, this request returns either the most occurring finding types or
         * the least occurring finding types. If the <code>orderBy</code> parameter is <code>ASC</code>, this will
         * represent the least occurring finding types in your account; otherwise, this will represent the most
         * occurring finding types. The default value of <code>orderBy</code> is <code>DESC</code>.
         * </p>
         * 
         * @param groupedByFindingType
         *        Represents a list of map of finding types with a count of total findings generated for each type. </p>
         *        <p>
         *        Based on the <code>orderBy</code> parameter, this request returns either the most occurring finding
         *        types or the least occurring finding types. If the <code>orderBy</code> parameter is <code>ASC</code>,
         *        this will represent the least occurring finding types in your account; otherwise, this will represent
         *        the most occurring finding types. The default value of <code>orderBy</code> is <code>DESC</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupedByFindingType(FindingTypeStatistics... groupedByFindingType);

        /**
         * <p>
         * Represents a list of map of finding types with a count of total findings generated for each type.
         * </p>
         * <p>
         * Based on the <code>orderBy</code> parameter, this request returns either the most occurring finding types or
         * the least occurring finding types. If the <code>orderBy</code> parameter is <code>ASC</code>, this will
         * represent the least occurring finding types in your account; otherwise, this will represent the most
         * occurring finding types. The default value of <code>orderBy</code> is <code>DESC</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.FindingTypeStatistics.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.FindingTypeStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.FindingTypeStatistics.Builder#build()} is called
         * immediately and its result is passed to {@link #groupedByFindingType(List<FindingTypeStatistics>)}.
         * 
         * @param groupedByFindingType
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.FindingTypeStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupedByFindingType(java.util.Collection<FindingTypeStatistics>)
         */
        Builder groupedByFindingType(Consumer<FindingTypeStatistics.Builder>... groupedByFindingType);

        /**
         * <p>
         * Represents a list of map of top resources with a count of total findings.
         * </p>
         * 
         * @param groupedByResource
         *        Represents a list of map of top resources with a count of total findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupedByResource(Collection<ResourceStatistics> groupedByResource);

        /**
         * <p>
         * Represents a list of map of top resources with a count of total findings.
         * </p>
         * 
         * @param groupedByResource
         *        Represents a list of map of top resources with a count of total findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupedByResource(ResourceStatistics... groupedByResource);

        /**
         * <p>
         * Represents a list of map of top resources with a count of total findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.ResourceStatistics.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.guardduty.model.ResourceStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.ResourceStatistics.Builder#build()} is called
         * immediately and its result is passed to {@link #groupedByResource(List<ResourceStatistics>)}.
         * 
         * @param groupedByResource
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.ResourceStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupedByResource(java.util.Collection<ResourceStatistics>)
         */
        Builder groupedByResource(Consumer<ResourceStatistics.Builder>... groupedByResource);

        /**
         * <p>
         * Represents a list of map of total findings for each severity level.
         * </p>
         * 
         * @param groupedBySeverity
         *        Represents a list of map of total findings for each severity level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupedBySeverity(Collection<SeverityStatistics> groupedBySeverity);

        /**
         * <p>
         * Represents a list of map of total findings for each severity level.
         * </p>
         * 
         * @param groupedBySeverity
         *        Represents a list of map of total findings for each severity level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupedBySeverity(SeverityStatistics... groupedBySeverity);

        /**
         * <p>
         * Represents a list of map of total findings for each severity level.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.SeverityStatistics.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.guardduty.model.SeverityStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.SeverityStatistics.Builder#build()} is called
         * immediately and its result is passed to {@link #groupedBySeverity(List<SeverityStatistics>)}.
         * 
         * @param groupedBySeverity
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.SeverityStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupedBySeverity(java.util.Collection<SeverityStatistics>)
         */
        Builder groupedBySeverity(Consumer<SeverityStatistics.Builder>... groupedBySeverity);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Integer> countBySeverity = DefaultSdkAutoConstructMap.getInstance();

        private List<AccountStatistics> groupedByAccount = DefaultSdkAutoConstructList.getInstance();

        private List<DateStatistics> groupedByDate = DefaultSdkAutoConstructList.getInstance();

        private List<FindingTypeStatistics> groupedByFindingType = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceStatistics> groupedByResource = DefaultSdkAutoConstructList.getInstance();

        private List<SeverityStatistics> groupedBySeverity = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FindingStatistics model) {
            countBySeverity(model.countBySeverity);
            groupedByAccount(model.groupedByAccount);
            groupedByDate(model.groupedByDate);
            groupedByFindingType(model.groupedByFindingType);
            groupedByResource(model.groupedByResource);
            groupedBySeverity(model.groupedBySeverity);
        }

        @Deprecated
        public final Map<String, Integer> getCountBySeverity() {
            if (countBySeverity instanceof SdkAutoConstructMap) {
                return null;
            }
            return countBySeverity;
        }

        @Deprecated
        public final void setCountBySeverity(Map<String, Integer> countBySeverity) {
            this.countBySeverity = CountBySeverityCopier.copy(countBySeverity);
        }

        @Override
        @Deprecated
        public final Builder countBySeverity(Map<String, Integer> countBySeverity) {
            this.countBySeverity = CountBySeverityCopier.copy(countBySeverity);
            return this;
        }

        public final List<AccountStatistics.Builder> getGroupedByAccount() {
            List<AccountStatistics.Builder> result = GroupedByAccountCopier.copyToBuilder(this.groupedByAccount);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupedByAccount(Collection<AccountStatistics.BuilderImpl> groupedByAccount) {
            this.groupedByAccount = GroupedByAccountCopier.copyFromBuilder(groupedByAccount);
        }

        @Override
        public final Builder groupedByAccount(Collection<AccountStatistics> groupedByAccount) {
            this.groupedByAccount = GroupedByAccountCopier.copy(groupedByAccount);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedByAccount(AccountStatistics... groupedByAccount) {
            groupedByAccount(Arrays.asList(groupedByAccount));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedByAccount(Consumer<AccountStatistics.Builder>... groupedByAccount) {
            groupedByAccount(Stream.of(groupedByAccount).map(c -> AccountStatistics.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DateStatistics.Builder> getGroupedByDate() {
            List<DateStatistics.Builder> result = GroupedByDateCopier.copyToBuilder(this.groupedByDate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupedByDate(Collection<DateStatistics.BuilderImpl> groupedByDate) {
            this.groupedByDate = GroupedByDateCopier.copyFromBuilder(groupedByDate);
        }

        @Override
        public final Builder groupedByDate(Collection<DateStatistics> groupedByDate) {
            this.groupedByDate = GroupedByDateCopier.copy(groupedByDate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedByDate(DateStatistics... groupedByDate) {
            groupedByDate(Arrays.asList(groupedByDate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedByDate(Consumer<DateStatistics.Builder>... groupedByDate) {
            groupedByDate(Stream.of(groupedByDate).map(c -> DateStatistics.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FindingTypeStatistics.Builder> getGroupedByFindingType() {
            List<FindingTypeStatistics.Builder> result = GroupedByFindingTypeCopier.copyToBuilder(this.groupedByFindingType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupedByFindingType(Collection<FindingTypeStatistics.BuilderImpl> groupedByFindingType) {
            this.groupedByFindingType = GroupedByFindingTypeCopier.copyFromBuilder(groupedByFindingType);
        }

        @Override
        public final Builder groupedByFindingType(Collection<FindingTypeStatistics> groupedByFindingType) {
            this.groupedByFindingType = GroupedByFindingTypeCopier.copy(groupedByFindingType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedByFindingType(FindingTypeStatistics... groupedByFindingType) {
            groupedByFindingType(Arrays.asList(groupedByFindingType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedByFindingType(Consumer<FindingTypeStatistics.Builder>... groupedByFindingType) {
            groupedByFindingType(Stream.of(groupedByFindingType)
                    .map(c -> FindingTypeStatistics.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceStatistics.Builder> getGroupedByResource() {
            List<ResourceStatistics.Builder> result = GroupedByResourceCopier.copyToBuilder(this.groupedByResource);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupedByResource(Collection<ResourceStatistics.BuilderImpl> groupedByResource) {
            this.groupedByResource = GroupedByResourceCopier.copyFromBuilder(groupedByResource);
        }

        @Override
        public final Builder groupedByResource(Collection<ResourceStatistics> groupedByResource) {
            this.groupedByResource = GroupedByResourceCopier.copy(groupedByResource);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedByResource(ResourceStatistics... groupedByResource) {
            groupedByResource(Arrays.asList(groupedByResource));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedByResource(Consumer<ResourceStatistics.Builder>... groupedByResource) {
            groupedByResource(Stream.of(groupedByResource).map(c -> ResourceStatistics.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SeverityStatistics.Builder> getGroupedBySeverity() {
            List<SeverityStatistics.Builder> result = GroupedBySeverityCopier.copyToBuilder(this.groupedBySeverity);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupedBySeverity(Collection<SeverityStatistics.BuilderImpl> groupedBySeverity) {
            this.groupedBySeverity = GroupedBySeverityCopier.copyFromBuilder(groupedBySeverity);
        }

        @Override
        public final Builder groupedBySeverity(Collection<SeverityStatistics> groupedBySeverity) {
            this.groupedBySeverity = GroupedBySeverityCopier.copy(groupedBySeverity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedBySeverity(SeverityStatistics... groupedBySeverity) {
            groupedBySeverity(Arrays.asList(groupedBySeverity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedBySeverity(Consumer<SeverityStatistics.Builder>... groupedBySeverity) {
            groupedBySeverity(Stream.of(groupedBySeverity).map(c -> SeverityStatistics.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public FindingStatistics build() {
            return new FindingStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
