/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCoverageStatisticsRequest extends GuardDutyRequest implements
        ToCopyableBuilder<GetCoverageStatisticsRequest.Builder, GetCoverageStatisticsRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(GetCoverageStatisticsRequest::detectorId))
            .setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<CoverageFilterCriteria> FILTER_CRITERIA_FIELD = SdkField
            .<CoverageFilterCriteria> builder(MarshallingType.SDK_POJO).memberName("FilterCriteria")
            .getter(getter(GetCoverageStatisticsRequest::filterCriteria)).setter(setter(Builder::filterCriteria))
            .constructor(CoverageFilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()).build();

    private static final SdkField<List<String>> STATISTICS_TYPE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StatisticsType")
            .getter(getter(GetCoverageStatisticsRequest::statisticsTypeAsStrings))
            .setter(setter(Builder::statisticsTypeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statisticsType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            FILTER_CRITERIA_FIELD, STATISTICS_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String detectorId;

    private final CoverageFilterCriteria filterCriteria;

    private final List<String> statisticsType;

    private GetCoverageStatisticsRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.filterCriteria = builder.filterCriteria;
        this.statisticsType = builder.statisticsType;
    }

    /**
     * <p>
     * The unique ID of the GuardDuty detector.
     * </p>
     * <p>
     * To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty console, or run
     * the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
     * API.
     * </p>
     * 
     * @return The unique ID of the GuardDuty detector.</p>
     *         <p>
     *         To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty
     *         console, or run the <a
     *         href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
     *         API.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * Represents the criteria used to filter the coverage statistics.
     * </p>
     * 
     * @return Represents the criteria used to filter the coverage statistics.
     */
    public final CoverageFilterCriteria filterCriteria() {
        return filterCriteria;
    }

    /**
     * <p>
     * Represents the statistics type used to aggregate the coverage details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatisticsType} method.
     * </p>
     * 
     * @return Represents the statistics type used to aggregate the coverage details.
     */
    public final List<CoverageStatisticsType> statisticsType() {
        return CoverageStatisticsTypeListCopier.copyStringToEnum(statisticsType);
    }

    /**
     * For responses, this returns true if the service returned a value for the StatisticsType property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatisticsType() {
        return statisticsType != null && !(statisticsType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents the statistics type used to aggregate the coverage details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatisticsType} method.
     * </p>
     * 
     * @return Represents the statistics type used to aggregate the coverage details.
     */
    public final List<String> statisticsTypeAsStrings() {
        return statisticsType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatisticsType() ? statisticsTypeAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCoverageStatisticsRequest)) {
            return false;
        }
        GetCoverageStatisticsRequest other = (GetCoverageStatisticsRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(filterCriteria(), other.filterCriteria())
                && hasStatisticsType() == other.hasStatisticsType()
                && Objects.equals(statisticsTypeAsStrings(), other.statisticsTypeAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCoverageStatisticsRequest").add("DetectorId", detectorId())
                .add("FilterCriteria", filterCriteria())
                .add("StatisticsType", hasStatisticsType() ? statisticsTypeAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "FilterCriteria":
            return Optional.ofNullable(clazz.cast(filterCriteria()));
        case "StatisticsType":
            return Optional.ofNullable(clazz.cast(statisticsTypeAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("filterCriteria", FILTER_CRITERIA_FIELD);
        map.put("statisticsType", STATISTICS_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCoverageStatisticsRequest, T> g) {
        return obj -> g.apply((GetCoverageStatisticsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetCoverageStatisticsRequest> {
        /**
         * <p>
         * The unique ID of the GuardDuty detector.
         * </p>
         * <p>
         * To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty console, or
         * run the <a
         * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
         * API.
         * </p>
         * 
         * @param detectorId
         *        The unique ID of the GuardDuty detector.</p>
         *        <p>
         *        To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty
         *        console, or run the <a
         *        href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html"
         *        >ListDetectors</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * Represents the criteria used to filter the coverage statistics.
         * </p>
         * 
         * @param filterCriteria
         *        Represents the criteria used to filter the coverage statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCriteria(CoverageFilterCriteria filterCriteria);

        /**
         * <p>
         * Represents the criteria used to filter the coverage statistics.
         * </p>
         * This is a convenience method that creates an instance of the {@link CoverageFilterCriteria.Builder} avoiding
         * the need to create one manually via {@link CoverageFilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CoverageFilterCriteria.Builder#build()} is called immediately and
         * its result is passed to {@link #filterCriteria(CoverageFilterCriteria)}.
         * 
         * @param filterCriteria
         *        a consumer that will call methods on {@link CoverageFilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterCriteria(CoverageFilterCriteria)
         */
        default Builder filterCriteria(Consumer<CoverageFilterCriteria.Builder> filterCriteria) {
            return filterCriteria(CoverageFilterCriteria.builder().applyMutation(filterCriteria).build());
        }

        /**
         * <p>
         * Represents the statistics type used to aggregate the coverage details.
         * </p>
         * 
         * @param statisticsType
         *        Represents the statistics type used to aggregate the coverage details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsTypeWithStrings(Collection<String> statisticsType);

        /**
         * <p>
         * Represents the statistics type used to aggregate the coverage details.
         * </p>
         * 
         * @param statisticsType
         *        Represents the statistics type used to aggregate the coverage details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsTypeWithStrings(String... statisticsType);

        /**
         * <p>
         * Represents the statistics type used to aggregate the coverage details.
         * </p>
         * 
         * @param statisticsType
         *        Represents the statistics type used to aggregate the coverage details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsType(Collection<CoverageStatisticsType> statisticsType);

        /**
         * <p>
         * Represents the statistics type used to aggregate the coverage details.
         * </p>
         * 
         * @param statisticsType
         *        Represents the statistics type used to aggregate the coverage details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsType(CoverageStatisticsType... statisticsType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private CoverageFilterCriteria filterCriteria;

        private List<String> statisticsType = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCoverageStatisticsRequest model) {
            super(model);
            detectorId(model.detectorId);
            filterCriteria(model.filterCriteria);
            statisticsTypeWithStrings(model.statisticsType);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final CoverageFilterCriteria.Builder getFilterCriteria() {
            return filterCriteria != null ? filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(CoverageFilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(CoverageFilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final Collection<String> getStatisticsType() {
            if (statisticsType instanceof SdkAutoConstructList) {
                return null;
            }
            return statisticsType;
        }

        public final void setStatisticsType(Collection<String> statisticsType) {
            this.statisticsType = CoverageStatisticsTypeListCopier.copy(statisticsType);
        }

        @Override
        public final Builder statisticsTypeWithStrings(Collection<String> statisticsType) {
            this.statisticsType = CoverageStatisticsTypeListCopier.copy(statisticsType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsTypeWithStrings(String... statisticsType) {
            statisticsTypeWithStrings(Arrays.asList(statisticsType));
            return this;
        }

        @Override
        public final Builder statisticsType(Collection<CoverageStatisticsType> statisticsType) {
            this.statisticsType = CoverageStatisticsTypeListCopier.copyEnumToString(statisticsType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsType(CoverageStatisticsType... statisticsType) {
            statisticsType(Arrays.asList(statisticsType));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCoverageStatisticsRequest build() {
            return new GetCoverageStatisticsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
