/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFindingsStatisticsResponse extends GuardDutyResponse implements
        ToCopyableBuilder<GetFindingsStatisticsResponse.Builder, GetFindingsStatisticsResponse> {
    private static final SdkField<FindingStatistics> FINDING_STATISTICS_FIELD = SdkField
            .<FindingStatistics> builder(MarshallingType.SDK_POJO).memberName("FindingStatistics")
            .getter(getter(GetFindingsStatisticsResponse::findingStatistics)).setter(setter(Builder::findingStatistics))
            .constructor(FindingStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingStatistics").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetFindingsStatisticsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_STATISTICS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final FindingStatistics findingStatistics;

    private final String nextToken;

    private GetFindingsStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.findingStatistics = builder.findingStatistics;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The finding statistics object.
     * </p>
     * 
     * @return The finding statistics object.
     */
    public final FindingStatistics findingStatistics() {
        return findingStatistics;
    }

    /**
     * <p>
     * The pagination parameter to be used on the next list operation to retrieve more items.
     * </p>
     * <p>
     * This parameter is currently not supported.
     * </p>
     * 
     * @return The pagination parameter to be used on the next list operation to retrieve more items.</p>
     *         <p>
     *         This parameter is currently not supported.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(findingStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingsStatisticsResponse)) {
            return false;
        }
        GetFindingsStatisticsResponse other = (GetFindingsStatisticsResponse) obj;
        return Objects.equals(findingStatistics(), other.findingStatistics()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFindingsStatisticsResponse").add("FindingStatistics", findingStatistics())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FindingStatistics":
            return Optional.ofNullable(clazz.cast(findingStatistics()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("findingStatistics", FINDING_STATISTICS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFindingsStatisticsResponse, T> g) {
        return obj -> g.apply((GetFindingsStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFindingsStatisticsResponse> {
        /**
         * <p>
         * The finding statistics object.
         * </p>
         * 
         * @param findingStatistics
         *        The finding statistics object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingStatistics(FindingStatistics findingStatistics);

        /**
         * <p>
         * The finding statistics object.
         * </p>
         * This is a convenience method that creates an instance of the {@link FindingStatistics.Builder} avoiding the
         * need to create one manually via {@link FindingStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FindingStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #findingStatistics(FindingStatistics)}.
         * 
         * @param findingStatistics
         *        a consumer that will call methods on {@link FindingStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingStatistics(FindingStatistics)
         */
        default Builder findingStatistics(Consumer<FindingStatistics.Builder> findingStatistics) {
            return findingStatistics(FindingStatistics.builder().applyMutation(findingStatistics).build());
        }

        /**
         * <p>
         * The pagination parameter to be used on the next list operation to retrieve more items.
         * </p>
         * <p>
         * This parameter is currently not supported.
         * </p>
         * 
         * @param nextToken
         *        The pagination parameter to be used on the next list operation to retrieve more items.</p>
         *        <p>
         *        This parameter is currently not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private FindingStatistics findingStatistics;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingsStatisticsResponse model) {
            super(model);
            findingStatistics(model.findingStatistics);
            nextToken(model.nextToken);
        }

        public final FindingStatistics.Builder getFindingStatistics() {
            return findingStatistics != null ? findingStatistics.toBuilder() : null;
        }

        public final void setFindingStatistics(FindingStatistics.BuilderImpl findingStatistics) {
            this.findingStatistics = findingStatistics != null ? findingStatistics.build() : null;
        }

        @Override
        public final Builder findingStatistics(FindingStatistics findingStatistics) {
            this.findingStatistics = findingStatistics;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetFindingsStatisticsResponse build() {
            return new GetFindingsStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
