/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOrganizationStatisticsResponse extends GuardDutyResponse implements
        ToCopyableBuilder<GetOrganizationStatisticsResponse.Builder, GetOrganizationStatisticsResponse> {
    private static final SdkField<OrganizationDetails> ORGANIZATION_DETAILS_FIELD = SdkField
            .<OrganizationDetails> builder(MarshallingType.SDK_POJO).memberName("OrganizationDetails")
            .getter(getter(GetOrganizationStatisticsResponse::organizationDetails)).setter(setter(Builder::organizationDetails))
            .constructor(OrganizationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final OrganizationDetails organizationDetails;

    private GetOrganizationStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.organizationDetails = builder.organizationDetails;
    }

    /**
     * <p>
     * Information about the statistics report for your organization.
     * </p>
     * 
     * @return Information about the statistics report for your organization.
     */
    public final OrganizationDetails organizationDetails() {
        return organizationDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOrganizationStatisticsResponse)) {
            return false;
        }
        GetOrganizationStatisticsResponse other = (GetOrganizationStatisticsResponse) obj;
        return Objects.equals(organizationDetails(), other.organizationDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOrganizationStatisticsResponse").add("OrganizationDetails", organizationDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationDetails":
            return Optional.ofNullable(clazz.cast(organizationDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("organizationDetails", ORGANIZATION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOrganizationStatisticsResponse, T> g) {
        return obj -> g.apply((GetOrganizationStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOrganizationStatisticsResponse> {
        /**
         * <p>
         * Information about the statistics report for your organization.
         * </p>
         * 
         * @param organizationDetails
         *        Information about the statistics report for your organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationDetails(OrganizationDetails organizationDetails);

        /**
         * <p>
         * Information about the statistics report for your organization.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrganizationDetails.Builder} avoiding the
         * need to create one manually via {@link OrganizationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrganizationDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #organizationDetails(OrganizationDetails)}.
         * 
         * @param organizationDetails
         *        a consumer that will call methods on {@link OrganizationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationDetails(OrganizationDetails)
         */
        default Builder organizationDetails(Consumer<OrganizationDetails.Builder> organizationDetails) {
            return organizationDetails(OrganizationDetails.builder().applyMutation(organizationDetails).build());
        }
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private OrganizationDetails organizationDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOrganizationStatisticsResponse model) {
            super(model);
            organizationDetails(model.organizationDetails);
        }

        public final OrganizationDetails.Builder getOrganizationDetails() {
            return organizationDetails != null ? organizationDetails.toBuilder() : null;
        }

        public final void setOrganizationDetails(OrganizationDetails.BuilderImpl organizationDetails) {
            this.organizationDetails = organizationDetails != null ? organizationDetails.build() : null;
        }

        @Override
        public final Builder organizationDetails(OrganizationDetails organizationDetails) {
            this.organizationDetails = organizationDetails;
            return this;
        }

        @Override
        public GetOrganizationStatisticsResponse build() {
            return new GetOrganizationStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
