/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the details of an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceDetails implements SdkPojo, Serializable, ToCopyableBuilder<InstanceDetails.Builder, InstanceDetails> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(InstanceDetails::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<IamInstanceProfile> IAM_INSTANCE_PROFILE_FIELD = SdkField
            .<IamInstanceProfile> builder(MarshallingType.SDK_POJO).memberName("IamInstanceProfile")
            .getter(getter(InstanceDetails::iamInstanceProfile)).setter(setter(Builder::iamInstanceProfile))
            .constructor(IamInstanceProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamInstanceProfile").build())
            .build();

    private static final SdkField<String> IMAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageDescription").getter(getter(InstanceDetails::imageDescription))
            .setter(setter(Builder::imageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDescription").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageId").getter(getter(InstanceDetails::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(InstanceDetails::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()).build();

    private static final SdkField<String> INSTANCE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceState").getter(getter(InstanceDetails::instanceState)).setter(setter(Builder::instanceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceState").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(InstanceDetails::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn").getter(getter(InstanceDetails::outpostArn)).setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outpostArn").build()).build();

    private static final SdkField<String> LAUNCH_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchTime").getter(getter(InstanceDetails::launchTime)).setter(setter(Builder::launchTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTime").build()).build();

    private static final SdkField<List<NetworkInterface>> NETWORK_INTERFACES_FIELD = SdkField
            .<List<NetworkInterface>> builder(MarshallingType.LIST)
            .memberName("NetworkInterfaces")
            .getter(getter(InstanceDetails::networkInterfaces))
            .setter(setter(Builder::networkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkInterface> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkInterface::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Platform").getter(getter(InstanceDetails::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField
            .<List<ProductCode>> builder(MarshallingType.LIST)
            .memberName("ProductCodes")
            .getter(getter(InstanceDetails::productCodes))
            .setter(setter(Builder::productCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProductCode> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductCode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(InstanceDetails::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            IAM_INSTANCE_PROFILE_FIELD, IMAGE_DESCRIPTION_FIELD, IMAGE_ID_FIELD, INSTANCE_ID_FIELD, INSTANCE_STATE_FIELD,
            INSTANCE_TYPE_FIELD, OUTPOST_ARN_FIELD, LAUNCH_TIME_FIELD, NETWORK_INTERFACES_FIELD, PLATFORM_FIELD,
            PRODUCT_CODES_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final IamInstanceProfile iamInstanceProfile;

    private final String imageDescription;

    private final String imageId;

    private final String instanceId;

    private final String instanceState;

    private final String instanceType;

    private final String outpostArn;

    private final String launchTime;

    private final List<NetworkInterface> networkInterfaces;

    private final String platform;

    private final List<ProductCode> productCodes;

    private final List<Tag> tags;

    private InstanceDetails(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageDescription = builder.imageDescription;
        this.imageId = builder.imageId;
        this.instanceId = builder.instanceId;
        this.instanceState = builder.instanceState;
        this.instanceType = builder.instanceType;
        this.outpostArn = builder.outpostArn;
        this.launchTime = builder.launchTime;
        this.networkInterfaces = builder.networkInterfaces;
        this.platform = builder.platform;
        this.productCodes = builder.productCodes;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Availability Zone of the EC2 instance.
     * </p>
     * 
     * @return The Availability Zone of the EC2 instance.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The profile information of the EC2 instance.
     * </p>
     * 
     * @return The profile information of the EC2 instance.
     */
    public final IamInstanceProfile iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * The image description of the EC2 instance.
     * </p>
     * 
     * @return The image description of the EC2 instance.
     */
    public final String imageDescription() {
        return imageDescription;
    }

    /**
     * <p>
     * The image ID of the EC2 instance.
     * </p>
     * 
     * @return The image ID of the EC2 instance.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The ID of the EC2 instance.
     * </p>
     * 
     * @return The ID of the EC2 instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The state of the EC2 instance.
     * </p>
     * 
     * @return The state of the EC2 instance.
     */
    public final String instanceState() {
        return instanceState;
    }

    /**
     * <p>
     * The type of the EC2 instance.
     * </p>
     * 
     * @return The type of the EC2 instance.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services Outpost. Only applicable to Amazon Web Services
     * Outposts instances.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services Outpost. Only applicable to Amazon Web Services
     *         Outposts instances.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * The launch time of the EC2 instance.
     * </p>
     * 
     * @return The launch time of the EC2 instance.
     */
    public final String launchTime() {
        return launchTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInterfaces property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkInterfaces() {
        return networkInterfaces != null && !(networkInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The elastic network interface information of the EC2 instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInterfaces} method.
     * </p>
     * 
     * @return The elastic network interface information of the EC2 instance.
     */
    public final List<NetworkInterface> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * The platform of the EC2 instance.
     * </p>
     * 
     * @return The platform of the EC2 instance.
     */
    public final String platform() {
        return platform;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProductCodes() {
        return productCodes != null && !(productCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The product code of the EC2 instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductCodes} method.
     * </p>
     * 
     * @return The product code of the EC2 instance.
     */
    public final List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags of the EC2 instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags of the EC2 instance.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(imageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceState());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfaces() ? networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductCodes() ? productCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceDetails)) {
            return false;
        }
        InstanceDetails other = (InstanceDetails) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile())
                && Objects.equals(imageDescription(), other.imageDescription()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(instanceState(), other.instanceState())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(outpostArn(), other.outpostArn())
                && Objects.equals(launchTime(), other.launchTime()) && hasNetworkInterfaces() == other.hasNetworkInterfaces()
                && Objects.equals(networkInterfaces(), other.networkInterfaces()) && Objects.equals(platform(), other.platform())
                && hasProductCodes() == other.hasProductCodes() && Objects.equals(productCodes(), other.productCodes())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceDetails").add("AvailabilityZone", availabilityZone())
                .add("IamInstanceProfile", iamInstanceProfile()).add("ImageDescription", imageDescription())
                .add("ImageId", imageId()).add("InstanceId", instanceId()).add("InstanceState", instanceState())
                .add("InstanceType", instanceType()).add("OutpostArn", outpostArn()).add("LaunchTime", launchTime())
                .add("NetworkInterfaces", hasNetworkInterfaces() ? networkInterfaces() : null).add("Platform", platform())
                .add("ProductCodes", hasProductCodes() ? productCodes() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "IamInstanceProfile":
            return Optional.ofNullable(clazz.cast(iamInstanceProfile()));
        case "ImageDescription":
            return Optional.ofNullable(clazz.cast(imageDescription()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceState":
            return Optional.ofNullable(clazz.cast(instanceState()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "LaunchTime":
            return Optional.ofNullable(clazz.cast(launchTime()));
        case "NetworkInterfaces":
            return Optional.ofNullable(clazz.cast(networkInterfaces()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "ProductCodes":
            return Optional.ofNullable(clazz.cast(productCodes()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("iamInstanceProfile", IAM_INSTANCE_PROFILE_FIELD);
        map.put("imageDescription", IMAGE_DESCRIPTION_FIELD);
        map.put("imageId", IMAGE_ID_FIELD);
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("instanceState", INSTANCE_STATE_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("outpostArn", OUTPOST_ARN_FIELD);
        map.put("launchTime", LAUNCH_TIME_FIELD);
        map.put("networkInterfaces", NETWORK_INTERFACES_FIELD);
        map.put("platform", PLATFORM_FIELD);
        map.put("productCodes", PRODUCT_CODES_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceDetails, T> g) {
        return obj -> g.apply((InstanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceDetails> {
        /**
         * <p>
         * The Availability Zone of the EC2 instance.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The profile information of the EC2 instance.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The profile information of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(IamInstanceProfile iamInstanceProfile);

        /**
         * <p>
         * The profile information of the EC2 instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamInstanceProfile.Builder} avoiding the
         * need to create one manually via {@link IamInstanceProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamInstanceProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #iamInstanceProfile(IamInstanceProfile)}.
         * 
         * @param iamInstanceProfile
         *        a consumer that will call methods on {@link IamInstanceProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfile(IamInstanceProfile)
         */
        default Builder iamInstanceProfile(Consumer<IamInstanceProfile.Builder> iamInstanceProfile) {
            return iamInstanceProfile(IamInstanceProfile.builder().applyMutation(iamInstanceProfile).build());
        }

        /**
         * <p>
         * The image description of the EC2 instance.
         * </p>
         * 
         * @param imageDescription
         *        The image description of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageDescription(String imageDescription);

        /**
         * <p>
         * The image ID of the EC2 instance.
         * </p>
         * 
         * @param imageId
         *        The image ID of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The ID of the EC2 instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The state of the EC2 instance.
         * </p>
         * 
         * @param instanceState
         *        The state of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceState(String instanceState);

        /**
         * <p>
         * The type of the EC2 instance.
         * </p>
         * 
         * @param instanceType
         *        The type of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services Outpost. Only applicable to Amazon Web Services
         * Outposts instances.
         * </p>
         * 
         * @param outpostArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services Outpost. Only applicable to Amazon Web
         *        Services Outposts instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * The launch time of the EC2 instance.
         * </p>
         * 
         * @param launchTime
         *        The launch time of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTime(String launchTime);

        /**
         * <p>
         * The elastic network interface information of the EC2 instance.
         * </p>
         * 
         * @param networkInterfaces
         *        The elastic network interface information of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<NetworkInterface> networkInterfaces);

        /**
         * <p>
         * The elastic network interface information of the EC2 instance.
         * </p>
         * 
         * @param networkInterfaces
         *        The elastic network interface information of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(NetworkInterface... networkInterfaces);

        /**
         * <p>
         * The elastic network interface information of the EC2 instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.NetworkInterface.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.guardduty.model.NetworkInterface#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.NetworkInterface.Builder#build()} is called
         * immediately and its result is passed to {@link #networkInterfaces(List<NetworkInterface>)}.
         * 
         * @param networkInterfaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.NetworkInterface.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfaces(java.util.Collection<NetworkInterface>)
         */
        Builder networkInterfaces(Consumer<NetworkInterface.Builder>... networkInterfaces);

        /**
         * <p>
         * The platform of the EC2 instance.
         * </p>
         * 
         * @param platform
         *        The platform of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The product code of the EC2 instance.
         * </p>
         * 
         * @param productCodes
         *        The product code of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * The product code of the EC2 instance.
         * </p>
         * 
         * @param productCodes
         *        The product code of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * The product code of the EC2 instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.ProductCode.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.guardduty.model.ProductCode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.ProductCode.Builder#build()} is called immediately and
         * its result is passed to {@link #productCodes(List<ProductCode>)}.
         * 
         * @param productCodes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.ProductCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productCodes(java.util.Collection<ProductCode>)
         */
        Builder productCodes(Consumer<ProductCode.Builder>... productCodes);

        /**
         * <p>
         * The tags of the EC2 instance.
         * </p>
         * 
         * @param tags
         *        The tags of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags of the EC2 instance.
         * </p>
         * 
         * @param tags
         *        The tags of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags of the EC2 instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.guardduty.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private IamInstanceProfile iamInstanceProfile;

        private String imageDescription;

        private String imageId;

        private String instanceId;

        private String instanceState;

        private String instanceType;

        private String outpostArn;

        private String launchTime;

        private List<NetworkInterface> networkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private String platform;

        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceDetails model) {
            availabilityZone(model.availabilityZone);
            iamInstanceProfile(model.iamInstanceProfile);
            imageDescription(model.imageDescription);
            imageId(model.imageId);
            instanceId(model.instanceId);
            instanceState(model.instanceState);
            instanceType(model.instanceType);
            outpostArn(model.outpostArn);
            launchTime(model.launchTime);
            networkInterfaces(model.networkInterfaces);
            platform(model.platform);
            productCodes(model.productCodes);
            tags(model.tags);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final IamInstanceProfile.Builder getIamInstanceProfile() {
            return iamInstanceProfile != null ? iamInstanceProfile.toBuilder() : null;
        }

        public final void setIamInstanceProfile(IamInstanceProfile.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfile iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final String getImageDescription() {
            return imageDescription;
        }

        public final void setImageDescription(String imageDescription) {
            this.imageDescription = imageDescription;
        }

        @Override
        public final Builder imageDescription(String imageDescription) {
            this.imageDescription = imageDescription;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceState() {
            return instanceState;
        }

        public final void setInstanceState(String instanceState) {
            this.instanceState = instanceState;
        }

        @Override
        public final Builder instanceState(String instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getLaunchTime() {
            return launchTime;
        }

        public final void setLaunchTime(String launchTime) {
            this.launchTime = launchTime;
        }

        @Override
        public final Builder launchTime(String launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final List<NetworkInterface.Builder> getNetworkInterfaces() {
            List<NetworkInterface.Builder> result = NetworkInterfacesCopier.copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<NetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        public final Builder networkInterfaces(Collection<NetworkInterface> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(NetworkInterface... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<NetworkInterface.Builder>... networkInterfaces) {
            networkInterfaces(Stream.of(networkInterfaces).map(c -> NetworkInterface.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final List<ProductCode.Builder> getProductCodes() {
            List<ProductCode.Builder> result = ProductCodesCopier.copyToBuilder(this.productCodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodesCopier.copyFromBuilder(productCodes);
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodesCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder>... productCodes) {
            productCodes(Stream.of(productCodes).map(c -> ProductCode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public InstanceDetails build() {
            return new InstanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
