/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Kubernetes API call action described in this finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KubernetesApiCallAction implements SdkPojo, Serializable,
        ToCopyableBuilder<KubernetesApiCallAction.Builder, KubernetesApiCallAction> {
    private static final SdkField<String> REQUEST_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestUri").getter(getter(KubernetesApiCallAction::requestUri)).setter(setter(Builder::requestUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestUri").build()).build();

    private static final SdkField<String> VERB_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Verb")
            .getter(getter(KubernetesApiCallAction::verb)).setter(setter(Builder::verb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verb").build()).build();

    private static final SdkField<List<String>> SOURCE_IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SourceIps")
            .getter(getter(KubernetesApiCallAction::sourceIps))
            .setter(setter(Builder::sourceIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceIPs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_AGENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserAgent").getter(getter(KubernetesApiCallAction::userAgent)).setter(setter(Builder::userAgent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAgent").build()).build();

    private static final SdkField<RemoteIpDetails> REMOTE_IP_DETAILS_FIELD = SdkField
            .<RemoteIpDetails> builder(MarshallingType.SDK_POJO).memberName("RemoteIpDetails")
            .getter(getter(KubernetesApiCallAction::remoteIpDetails)).setter(setter(Builder::remoteIpDetails))
            .constructor(RemoteIpDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteIpDetails").build()).build();

    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StatusCode").getter(getter(KubernetesApiCallAction::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final SdkField<String> PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Parameters").getter(getter(KubernetesApiCallAction::parameters)).setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()).build();

    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Resource").getter(getter(KubernetesApiCallAction::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> SUBRESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Subresource").getter(getter(KubernetesApiCallAction::subresource)).setter(setter(Builder::subresource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subresource").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(KubernetesApiCallAction::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(KubernetesApiCallAction::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_URI_FIELD, VERB_FIELD,
            SOURCE_IPS_FIELD, USER_AGENT_FIELD, REMOTE_IP_DETAILS_FIELD, STATUS_CODE_FIELD, PARAMETERS_FIELD, RESOURCE_FIELD,
            SUBRESOURCE_FIELD, NAMESPACE_FIELD, RESOURCE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String requestUri;

    private final String verb;

    private final List<String> sourceIps;

    private final String userAgent;

    private final RemoteIpDetails remoteIpDetails;

    private final Integer statusCode;

    private final String parameters;

    private final String resource;

    private final String subresource;

    private final String namespace;

    private final String resourceName;

    private KubernetesApiCallAction(BuilderImpl builder) {
        this.requestUri = builder.requestUri;
        this.verb = builder.verb;
        this.sourceIps = builder.sourceIps;
        this.userAgent = builder.userAgent;
        this.remoteIpDetails = builder.remoteIpDetails;
        this.statusCode = builder.statusCode;
        this.parameters = builder.parameters;
        this.resource = builder.resource;
        this.subresource = builder.subresource;
        this.namespace = builder.namespace;
        this.resourceName = builder.resourceName;
    }

    /**
     * <p>
     * The Kubernetes API request URI.
     * </p>
     * 
     * @return The Kubernetes API request URI.
     */
    public final String requestUri() {
        return requestUri;
    }

    /**
     * <p>
     * The Kubernetes API request HTTP verb.
     * </p>
     * 
     * @return The Kubernetes API request HTTP verb.
     */
    public final String verb() {
        return verb;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceIps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSourceIps() {
        return sourceIps != null && !(sourceIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP of the Kubernetes API caller and the IPs of any proxies or load balancers between the caller and the API
     * endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceIps} method.
     * </p>
     * 
     * @return The IP of the Kubernetes API caller and the IPs of any proxies or load balancers between the caller and
     *         the API endpoint.
     */
    public final List<String> sourceIps() {
        return sourceIps;
    }

    /**
     * <p>
     * The user agent of the caller of the Kubernetes API.
     * </p>
     * 
     * @return The user agent of the caller of the Kubernetes API.
     */
    public final String userAgent() {
        return userAgent;
    }

    /**
     * Returns the value of the RemoteIpDetails property for this object.
     * 
     * @return The value of the RemoteIpDetails property for this object.
     */
    public final RemoteIpDetails remoteIpDetails() {
        return remoteIpDetails;
    }

    /**
     * <p>
     * The resulting HTTP response code of the Kubernetes API call action.
     * </p>
     * 
     * @return The resulting HTTP response code of the Kubernetes API call action.
     */
    public final Integer statusCode() {
        return statusCode;
    }

    /**
     * <p>
     * Parameters related to the Kubernetes API call action.
     * </p>
     * 
     * @return Parameters related to the Kubernetes API call action.
     */
    public final String parameters() {
        return parameters;
    }

    /**
     * <p>
     * The resource component in the Kubernetes API call action.
     * </p>
     * 
     * @return The resource component in the Kubernetes API call action.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * The name of the sub-resource in the Kubernetes API call action.
     * </p>
     * 
     * @return The name of the sub-resource in the Kubernetes API call action.
     */
    public final String subresource() {
        return subresource;
    }

    /**
     * <p>
     * The name of the namespace where the Kubernetes API call action takes place.
     * </p>
     * 
     * @return The name of the namespace where the Kubernetes API call action takes place.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the resource in the Kubernetes API call action.
     * </p>
     * 
     * @return The name of the resource in the Kubernetes API call action.
     */
    public final String resourceName() {
        return resourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(requestUri());
        hashCode = 31 * hashCode + Objects.hashCode(verb());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceIps() ? sourceIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userAgent());
        hashCode = 31 * hashCode + Objects.hashCode(remoteIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(subresource());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesApiCallAction)) {
            return false;
        }
        KubernetesApiCallAction other = (KubernetesApiCallAction) obj;
        return Objects.equals(requestUri(), other.requestUri()) && Objects.equals(verb(), other.verb())
                && hasSourceIps() == other.hasSourceIps() && Objects.equals(sourceIps(), other.sourceIps())
                && Objects.equals(userAgent(), other.userAgent()) && Objects.equals(remoteIpDetails(), other.remoteIpDetails())
                && Objects.equals(statusCode(), other.statusCode()) && Objects.equals(parameters(), other.parameters())
                && Objects.equals(resource(), other.resource()) && Objects.equals(subresource(), other.subresource())
                && Objects.equals(namespace(), other.namespace()) && Objects.equals(resourceName(), other.resourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KubernetesApiCallAction").add("RequestUri", requestUri()).add("Verb", verb())
                .add("SourceIps", hasSourceIps() ? sourceIps() : null).add("UserAgent", userAgent())
                .add("RemoteIpDetails", remoteIpDetails()).add("StatusCode", statusCode()).add("Parameters", parameters())
                .add("Resource", resource()).add("Subresource", subresource()).add("Namespace", namespace())
                .add("ResourceName", resourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestUri":
            return Optional.ofNullable(clazz.cast(requestUri()));
        case "Verb":
            return Optional.ofNullable(clazz.cast(verb()));
        case "SourceIps":
            return Optional.ofNullable(clazz.cast(sourceIps()));
        case "UserAgent":
            return Optional.ofNullable(clazz.cast(userAgent()));
        case "RemoteIpDetails":
            return Optional.ofNullable(clazz.cast(remoteIpDetails()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "Subresource":
            return Optional.ofNullable(clazz.cast(subresource()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("requestUri", REQUEST_URI_FIELD);
        map.put("verb", VERB_FIELD);
        map.put("sourceIPs", SOURCE_IPS_FIELD);
        map.put("userAgent", USER_AGENT_FIELD);
        map.put("remoteIpDetails", REMOTE_IP_DETAILS_FIELD);
        map.put("statusCode", STATUS_CODE_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("subresource", SUBRESOURCE_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("resourceName", RESOURCE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KubernetesApiCallAction, T> g) {
        return obj -> g.apply((KubernetesApiCallAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KubernetesApiCallAction> {
        /**
         * <p>
         * The Kubernetes API request URI.
         * </p>
         * 
         * @param requestUri
         *        The Kubernetes API request URI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestUri(String requestUri);

        /**
         * <p>
         * The Kubernetes API request HTTP verb.
         * </p>
         * 
         * @param verb
         *        The Kubernetes API request HTTP verb.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verb(String verb);

        /**
         * <p>
         * The IP of the Kubernetes API caller and the IPs of any proxies or load balancers between the caller and the
         * API endpoint.
         * </p>
         * 
         * @param sourceIps
         *        The IP of the Kubernetes API caller and the IPs of any proxies or load balancers between the caller
         *        and the API endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIps(Collection<String> sourceIps);

        /**
         * <p>
         * The IP of the Kubernetes API caller and the IPs of any proxies or load balancers between the caller and the
         * API endpoint.
         * </p>
         * 
         * @param sourceIps
         *        The IP of the Kubernetes API caller and the IPs of any proxies or load balancers between the caller
         *        and the API endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIps(String... sourceIps);

        /**
         * <p>
         * The user agent of the caller of the Kubernetes API.
         * </p>
         * 
         * @param userAgent
         *        The user agent of the caller of the Kubernetes API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAgent(String userAgent);

        /**
         * Sets the value of the RemoteIpDetails property for this object.
         *
         * @param remoteIpDetails
         *        The new value for the RemoteIpDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteIpDetails(RemoteIpDetails remoteIpDetails);

        /**
         * Sets the value of the RemoteIpDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RemoteIpDetails.Builder} avoiding the
         * need to create one manually via {@link RemoteIpDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RemoteIpDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #remoteIpDetails(RemoteIpDetails)}.
         * 
         * @param remoteIpDetails
         *        a consumer that will call methods on {@link RemoteIpDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteIpDetails(RemoteIpDetails)
         */
        default Builder remoteIpDetails(Consumer<RemoteIpDetails.Builder> remoteIpDetails) {
            return remoteIpDetails(RemoteIpDetails.builder().applyMutation(remoteIpDetails).build());
        }

        /**
         * <p>
         * The resulting HTTP response code of the Kubernetes API call action.
         * </p>
         * 
         * @param statusCode
         *        The resulting HTTP response code of the Kubernetes API call action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCode);

        /**
         * <p>
         * Parameters related to the Kubernetes API call action.
         * </p>
         * 
         * @param parameters
         *        Parameters related to the Kubernetes API call action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(String parameters);

        /**
         * <p>
         * The resource component in the Kubernetes API call action.
         * </p>
         * 
         * @param resource
         *        The resource component in the Kubernetes API call action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * The name of the sub-resource in the Kubernetes API call action.
         * </p>
         * 
         * @param subresource
         *        The name of the sub-resource in the Kubernetes API call action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subresource(String subresource);

        /**
         * <p>
         * The name of the namespace where the Kubernetes API call action takes place.
         * </p>
         * 
         * @param namespace
         *        The name of the namespace where the Kubernetes API call action takes place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the resource in the Kubernetes API call action.
         * </p>
         * 
         * @param resourceName
         *        The name of the resource in the Kubernetes API call action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);
    }

    static final class BuilderImpl implements Builder {
        private String requestUri;

        private String verb;

        private List<String> sourceIps = DefaultSdkAutoConstructList.getInstance();

        private String userAgent;

        private RemoteIpDetails remoteIpDetails;

        private Integer statusCode;

        private String parameters;

        private String resource;

        private String subresource;

        private String namespace;

        private String resourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesApiCallAction model) {
            requestUri(model.requestUri);
            verb(model.verb);
            sourceIps(model.sourceIps);
            userAgent(model.userAgent);
            remoteIpDetails(model.remoteIpDetails);
            statusCode(model.statusCode);
            parameters(model.parameters);
            resource(model.resource);
            subresource(model.subresource);
            namespace(model.namespace);
            resourceName(model.resourceName);
        }

        public final String getRequestUri() {
            return requestUri;
        }

        public final void setRequestUri(String requestUri) {
            this.requestUri = requestUri;
        }

        @Override
        public final Builder requestUri(String requestUri) {
            this.requestUri = requestUri;
            return this;
        }

        public final String getVerb() {
            return verb;
        }

        public final void setVerb(String verb) {
            this.verb = verb;
        }

        @Override
        public final Builder verb(String verb) {
            this.verb = verb;
            return this;
        }

        public final Collection<String> getSourceIps() {
            if (sourceIps instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceIps;
        }

        public final void setSourceIps(Collection<String> sourceIps) {
            this.sourceIps = SourceIpsCopier.copy(sourceIps);
        }

        @Override
        public final Builder sourceIps(Collection<String> sourceIps) {
            this.sourceIps = SourceIpsCopier.copy(sourceIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceIps(String... sourceIps) {
            sourceIps(Arrays.asList(sourceIps));
            return this;
        }

        public final String getUserAgent() {
            return userAgent;
        }

        public final void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        @Override
        public final Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public final RemoteIpDetails.Builder getRemoteIpDetails() {
            return remoteIpDetails != null ? remoteIpDetails.toBuilder() : null;
        }

        public final void setRemoteIpDetails(RemoteIpDetails.BuilderImpl remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails != null ? remoteIpDetails.build() : null;
        }

        @Override
        public final Builder remoteIpDetails(RemoteIpDetails remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails;
            return this;
        }

        public final Integer getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final String getParameters() {
            return parameters;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getSubresource() {
            return subresource;
        }

        public final void setSubresource(String subresource) {
            this.subresource = subresource;
        }

        @Override
        public final Builder subresource(String subresource) {
            this.subresource = subresource;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        @Override
        public KubernetesApiCallAction build() {
            return new KubernetesApiCallAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
