/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes whether any Kubernetes data sources are enabled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KubernetesConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KubernetesConfiguration.Builder, KubernetesConfiguration> {
    private static final SdkField<KubernetesAuditLogsConfiguration> AUDIT_LOGS_FIELD = SdkField
            .<KubernetesAuditLogsConfiguration> builder(MarshallingType.SDK_POJO).memberName("AuditLogs")
            .getter(getter(KubernetesConfiguration::auditLogs)).setter(setter(Builder::auditLogs))
            .constructor(KubernetesAuditLogsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditLogs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_LOGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final KubernetesAuditLogsConfiguration auditLogs;

    private KubernetesConfiguration(BuilderImpl builder) {
        this.auditLogs = builder.auditLogs;
    }

    /**
     * <p>
     * The status of Kubernetes audit logs as a data source.
     * </p>
     * 
     * @return The status of Kubernetes audit logs as a data source.
     */
    public final KubernetesAuditLogsConfiguration auditLogs() {
        return auditLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(auditLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesConfiguration)) {
            return false;
        }
        KubernetesConfiguration other = (KubernetesConfiguration) obj;
        return Objects.equals(auditLogs(), other.auditLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KubernetesConfiguration").add("AuditLogs", auditLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuditLogs":
            return Optional.ofNullable(clazz.cast(auditLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("auditLogs", AUDIT_LOGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KubernetesConfiguration, T> g) {
        return obj -> g.apply((KubernetesConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KubernetesConfiguration> {
        /**
         * <p>
         * The status of Kubernetes audit logs as a data source.
         * </p>
         * 
         * @param auditLogs
         *        The status of Kubernetes audit logs as a data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditLogs(KubernetesAuditLogsConfiguration auditLogs);

        /**
         * <p>
         * The status of Kubernetes audit logs as a data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link KubernetesAuditLogsConfiguration.Builder}
         * avoiding the need to create one manually via {@link KubernetesAuditLogsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KubernetesAuditLogsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #auditLogs(KubernetesAuditLogsConfiguration)}.
         * 
         * @param auditLogs
         *        a consumer that will call methods on {@link KubernetesAuditLogsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auditLogs(KubernetesAuditLogsConfiguration)
         */
        default Builder auditLogs(Consumer<KubernetesAuditLogsConfiguration.Builder> auditLogs) {
            return auditLogs(KubernetesAuditLogsConfiguration.builder().applyMutation(auditLogs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KubernetesAuditLogsConfiguration auditLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesConfiguration model) {
            auditLogs(model.auditLogs);
        }

        public final KubernetesAuditLogsConfiguration.Builder getAuditLogs() {
            return auditLogs != null ? auditLogs.toBuilder() : null;
        }

        public final void setAuditLogs(KubernetesAuditLogsConfiguration.BuilderImpl auditLogs) {
            this.auditLogs = auditLogs != null ? auditLogs.build() : null;
        }

        @Override
        public final Builder auditLogs(KubernetesAuditLogsConfiguration auditLogs) {
            this.auditLogs = auditLogs;
            return this;
        }

        @Override
        public KubernetesConfiguration build() {
            return new KubernetesConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
