/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information on the status of all Malware Protection data sources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MalwareProtectionConfigurationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<MalwareProtectionConfigurationResult.Builder, MalwareProtectionConfigurationResult> {
    private static final SdkField<ScanEc2InstanceWithFindingsResult> SCAN_EC2_INSTANCE_WITH_FINDINGS_FIELD = SdkField
            .<ScanEc2InstanceWithFindingsResult> builder(MarshallingType.SDK_POJO)
            .memberName("ScanEc2InstanceWithFindings")
            .getter(getter(MalwareProtectionConfigurationResult::scanEc2InstanceWithFindings))
            .setter(setter(Builder::scanEc2InstanceWithFindings))
            .constructor(ScanEc2InstanceWithFindingsResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanEc2InstanceWithFindings")
                    .build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRole").getter(getter(MalwareProtectionConfigurationResult::serviceRole))
            .setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SCAN_EC2_INSTANCE_WITH_FINDINGS_FIELD, SERVICE_ROLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ScanEc2InstanceWithFindingsResult scanEc2InstanceWithFindings;

    private final String serviceRole;

    private MalwareProtectionConfigurationResult(BuilderImpl builder) {
        this.scanEc2InstanceWithFindings = builder.scanEc2InstanceWithFindings;
        this.serviceRole = builder.serviceRole;
    }

    /**
     * <p>
     * Describes the configuration of Malware Protection for EC2 instances with findings.
     * </p>
     * 
     * @return Describes the configuration of Malware Protection for EC2 instances with findings.
     */
    public final ScanEc2InstanceWithFindingsResult scanEc2InstanceWithFindings() {
        return scanEc2InstanceWithFindings;
    }

    /**
     * <p>
     * The GuardDuty Malware Protection service role.
     * </p>
     * 
     * @return The GuardDuty Malware Protection service role.
     */
    public final String serviceRole() {
        return serviceRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scanEc2InstanceWithFindings());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MalwareProtectionConfigurationResult)) {
            return false;
        }
        MalwareProtectionConfigurationResult other = (MalwareProtectionConfigurationResult) obj;
        return Objects.equals(scanEc2InstanceWithFindings(), other.scanEc2InstanceWithFindings())
                && Objects.equals(serviceRole(), other.serviceRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MalwareProtectionConfigurationResult")
                .add("ScanEc2InstanceWithFindings", scanEc2InstanceWithFindings()).add("ServiceRole", serviceRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScanEc2InstanceWithFindings":
            return Optional.ofNullable(clazz.cast(scanEc2InstanceWithFindings()));
        case "ServiceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scanEc2InstanceWithFindings", SCAN_EC2_INSTANCE_WITH_FINDINGS_FIELD);
        map.put("serviceRole", SERVICE_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MalwareProtectionConfigurationResult, T> g) {
        return obj -> g.apply((MalwareProtectionConfigurationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MalwareProtectionConfigurationResult> {
        /**
         * <p>
         * Describes the configuration of Malware Protection for EC2 instances with findings.
         * </p>
         * 
         * @param scanEc2InstanceWithFindings
         *        Describes the configuration of Malware Protection for EC2 instances with findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanEc2InstanceWithFindings(ScanEc2InstanceWithFindingsResult scanEc2InstanceWithFindings);

        /**
         * <p>
         * Describes the configuration of Malware Protection for EC2 instances with findings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ScanEc2InstanceWithFindingsResult.Builder} avoiding the need to create one manually via
         * {@link ScanEc2InstanceWithFindingsResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScanEc2InstanceWithFindingsResult.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #scanEc2InstanceWithFindings(ScanEc2InstanceWithFindingsResult)}.
         * 
         * @param scanEc2InstanceWithFindings
         *        a consumer that will call methods on {@link ScanEc2InstanceWithFindingsResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanEc2InstanceWithFindings(ScanEc2InstanceWithFindingsResult)
         */
        default Builder scanEc2InstanceWithFindings(
                Consumer<ScanEc2InstanceWithFindingsResult.Builder> scanEc2InstanceWithFindings) {
            return scanEc2InstanceWithFindings(ScanEc2InstanceWithFindingsResult.builder()
                    .applyMutation(scanEc2InstanceWithFindings).build());
        }

        /**
         * <p>
         * The GuardDuty Malware Protection service role.
         * </p>
         * 
         * @param serviceRole
         *        The GuardDuty Malware Protection service role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);
    }

    static final class BuilderImpl implements Builder {
        private ScanEc2InstanceWithFindingsResult scanEc2InstanceWithFindings;

        private String serviceRole;

        private BuilderImpl() {
        }

        private BuilderImpl(MalwareProtectionConfigurationResult model) {
            scanEc2InstanceWithFindings(model.scanEc2InstanceWithFindings);
            serviceRole(model.serviceRole);
        }

        public final ScanEc2InstanceWithFindingsResult.Builder getScanEc2InstanceWithFindings() {
            return scanEc2InstanceWithFindings != null ? scanEc2InstanceWithFindings.toBuilder() : null;
        }

        public final void setScanEc2InstanceWithFindings(ScanEc2InstanceWithFindingsResult.BuilderImpl scanEc2InstanceWithFindings) {
            this.scanEc2InstanceWithFindings = scanEc2InstanceWithFindings != null ? scanEc2InstanceWithFindings.build() : null;
        }

        @Override
        public final Builder scanEc2InstanceWithFindings(ScanEc2InstanceWithFindingsResult scanEc2InstanceWithFindings) {
            this.scanEc2InstanceWithFindings = scanEc2InstanceWithFindings;
            return this;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        @Override
        public MalwareProtectionConfigurationResult build() {
            return new MalwareProtectionConfigurationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
