/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about Malware Protection when it is enabled as a data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MalwareProtectionDataSourceFreeTrial implements SdkPojo, Serializable,
        ToCopyableBuilder<MalwareProtectionDataSourceFreeTrial.Builder, MalwareProtectionDataSourceFreeTrial> {
    private static final SdkField<DataSourceFreeTrial> SCAN_EC2_INSTANCE_WITH_FINDINGS_FIELD = SdkField
            .<DataSourceFreeTrial> builder(MarshallingType.SDK_POJO)
            .memberName("ScanEc2InstanceWithFindings")
            .getter(getter(MalwareProtectionDataSourceFreeTrial::scanEc2InstanceWithFindings))
            .setter(setter(Builder::scanEc2InstanceWithFindings))
            .constructor(DataSourceFreeTrial::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanEc2InstanceWithFindings")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SCAN_EC2_INSTANCE_WITH_FINDINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataSourceFreeTrial scanEc2InstanceWithFindings;

    private MalwareProtectionDataSourceFreeTrial(BuilderImpl builder) {
        this.scanEc2InstanceWithFindings = builder.scanEc2InstanceWithFindings;
    }

    /**
     * <p>
     * Describes whether Malware Protection for EC2 instances with findings is enabled as a data source.
     * </p>
     * 
     * @return Describes whether Malware Protection for EC2 instances with findings is enabled as a data source.
     */
    public final DataSourceFreeTrial scanEc2InstanceWithFindings() {
        return scanEc2InstanceWithFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scanEc2InstanceWithFindings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MalwareProtectionDataSourceFreeTrial)) {
            return false;
        }
        MalwareProtectionDataSourceFreeTrial other = (MalwareProtectionDataSourceFreeTrial) obj;
        return Objects.equals(scanEc2InstanceWithFindings(), other.scanEc2InstanceWithFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MalwareProtectionDataSourceFreeTrial")
                .add("ScanEc2InstanceWithFindings", scanEc2InstanceWithFindings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScanEc2InstanceWithFindings":
            return Optional.ofNullable(clazz.cast(scanEc2InstanceWithFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scanEc2InstanceWithFindings", SCAN_EC2_INSTANCE_WITH_FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MalwareProtectionDataSourceFreeTrial, T> g) {
        return obj -> g.apply((MalwareProtectionDataSourceFreeTrial) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MalwareProtectionDataSourceFreeTrial> {
        /**
         * <p>
         * Describes whether Malware Protection for EC2 instances with findings is enabled as a data source.
         * </p>
         * 
         * @param scanEc2InstanceWithFindings
         *        Describes whether Malware Protection for EC2 instances with findings is enabled as a data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanEc2InstanceWithFindings(DataSourceFreeTrial scanEc2InstanceWithFindings);

        /**
         * <p>
         * Describes whether Malware Protection for EC2 instances with findings is enabled as a data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceFreeTrial.Builder} avoiding the
         * need to create one manually via {@link DataSourceFreeTrial#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceFreeTrial.Builder#build()} is called immediately and
         * its result is passed to {@link #scanEc2InstanceWithFindings(DataSourceFreeTrial)}.
         * 
         * @param scanEc2InstanceWithFindings
         *        a consumer that will call methods on {@link DataSourceFreeTrial.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanEc2InstanceWithFindings(DataSourceFreeTrial)
         */
        default Builder scanEc2InstanceWithFindings(Consumer<DataSourceFreeTrial.Builder> scanEc2InstanceWithFindings) {
            return scanEc2InstanceWithFindings(DataSourceFreeTrial.builder().applyMutation(scanEc2InstanceWithFindings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataSourceFreeTrial scanEc2InstanceWithFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(MalwareProtectionDataSourceFreeTrial model) {
            scanEc2InstanceWithFindings(model.scanEc2InstanceWithFindings);
        }

        public final DataSourceFreeTrial.Builder getScanEc2InstanceWithFindings() {
            return scanEc2InstanceWithFindings != null ? scanEc2InstanceWithFindings.toBuilder() : null;
        }

        public final void setScanEc2InstanceWithFindings(DataSourceFreeTrial.BuilderImpl scanEc2InstanceWithFindings) {
            this.scanEc2InstanceWithFindings = scanEc2InstanceWithFindings != null ? scanEc2InstanceWithFindings.build() : null;
        }

        @Override
        public final Builder scanEc2InstanceWithFindings(DataSourceFreeTrial scanEc2InstanceWithFindings) {
            this.scanEc2InstanceWithFindings = scanEc2InstanceWithFindings;
            return this;
        }

        @Override
        public MalwareProtectionDataSourceFreeTrial build() {
            return new MalwareProtectionDataSourceFreeTrial(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
