/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that a login attempt was made to the potentially compromised database from a remote IP address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RdsLoginAttemptAction implements SdkPojo, Serializable,
        ToCopyableBuilder<RdsLoginAttemptAction.Builder, RdsLoginAttemptAction> {
    private static final SdkField<RemoteIpDetails> REMOTE_IP_DETAILS_FIELD = SdkField
            .<RemoteIpDetails> builder(MarshallingType.SDK_POJO).memberName("RemoteIpDetails")
            .getter(getter(RdsLoginAttemptAction::remoteIpDetails)).setter(setter(Builder::remoteIpDetails))
            .constructor(RemoteIpDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteIpDetails").build()).build();

    private static final SdkField<List<LoginAttribute>> LOGIN_ATTRIBUTES_FIELD = SdkField
            .<List<LoginAttribute>> builder(MarshallingType.LIST)
            .memberName("LoginAttributes")
            .getter(getter(RdsLoginAttemptAction::loginAttributes))
            .setter(setter(Builder::loginAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoginAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoginAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoginAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMOTE_IP_DETAILS_FIELD,
            LOGIN_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RemoteIpDetails remoteIpDetails;

    private final List<LoginAttribute> loginAttributes;

    private RdsLoginAttemptAction(BuilderImpl builder) {
        this.remoteIpDetails = builder.remoteIpDetails;
        this.loginAttributes = builder.loginAttributes;
    }

    /**
     * Returns the value of the RemoteIpDetails property for this object.
     * 
     * @return The value of the RemoteIpDetails property for this object.
     */
    public final RemoteIpDetails remoteIpDetails() {
        return remoteIpDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoginAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLoginAttributes() {
        return loginAttributes != null && !(loginAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the login attributes used in the login attempt.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoginAttributes} method.
     * </p>
     * 
     * @return Indicates the login attributes used in the login attempt.
     */
    public final List<LoginAttribute> loginAttributes() {
        return loginAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(remoteIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasLoginAttributes() ? loginAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsLoginAttemptAction)) {
            return false;
        }
        RdsLoginAttemptAction other = (RdsLoginAttemptAction) obj;
        return Objects.equals(remoteIpDetails(), other.remoteIpDetails()) && hasLoginAttributes() == other.hasLoginAttributes()
                && Objects.equals(loginAttributes(), other.loginAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RdsLoginAttemptAction").add("RemoteIpDetails", remoteIpDetails())
                .add("LoginAttributes", hasLoginAttributes() ? loginAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RemoteIpDetails":
            return Optional.ofNullable(clazz.cast(remoteIpDetails()));
        case "LoginAttributes":
            return Optional.ofNullable(clazz.cast(loginAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("remoteIpDetails", REMOTE_IP_DETAILS_FIELD);
        map.put("LoginAttributes", LOGIN_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RdsLoginAttemptAction, T> g) {
        return obj -> g.apply((RdsLoginAttemptAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RdsLoginAttemptAction> {
        /**
         * Sets the value of the RemoteIpDetails property for this object.
         *
         * @param remoteIpDetails
         *        The new value for the RemoteIpDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteIpDetails(RemoteIpDetails remoteIpDetails);

        /**
         * Sets the value of the RemoteIpDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RemoteIpDetails.Builder} avoiding the
         * need to create one manually via {@link RemoteIpDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RemoteIpDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #remoteIpDetails(RemoteIpDetails)}.
         * 
         * @param remoteIpDetails
         *        a consumer that will call methods on {@link RemoteIpDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteIpDetails(RemoteIpDetails)
         */
        default Builder remoteIpDetails(Consumer<RemoteIpDetails.Builder> remoteIpDetails) {
            return remoteIpDetails(RemoteIpDetails.builder().applyMutation(remoteIpDetails).build());
        }

        /**
         * <p>
         * Indicates the login attributes used in the login attempt.
         * </p>
         * 
         * @param loginAttributes
         *        Indicates the login attributes used in the login attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loginAttributes(Collection<LoginAttribute> loginAttributes);

        /**
         * <p>
         * Indicates the login attributes used in the login attempt.
         * </p>
         * 
         * @param loginAttributes
         *        Indicates the login attributes used in the login attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loginAttributes(LoginAttribute... loginAttributes);

        /**
         * <p>
         * Indicates the login attributes used in the login attempt.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.LoginAttribute.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.guardduty.model.LoginAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.LoginAttribute.Builder#build()} is called immediately
         * and its result is passed to {@link #loginAttributes(List<LoginAttribute>)}.
         * 
         * @param loginAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.LoginAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loginAttributes(java.util.Collection<LoginAttribute>)
         */
        Builder loginAttributes(Consumer<LoginAttribute.Builder>... loginAttributes);
    }

    static final class BuilderImpl implements Builder {
        private RemoteIpDetails remoteIpDetails;

        private List<LoginAttribute> loginAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RdsLoginAttemptAction model) {
            remoteIpDetails(model.remoteIpDetails);
            loginAttributes(model.loginAttributes);
        }

        public final RemoteIpDetails.Builder getRemoteIpDetails() {
            return remoteIpDetails != null ? remoteIpDetails.toBuilder() : null;
        }

        public final void setRemoteIpDetails(RemoteIpDetails.BuilderImpl remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails != null ? remoteIpDetails.build() : null;
        }

        @Override
        public final Builder remoteIpDetails(RemoteIpDetails remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails;
            return this;
        }

        public final List<LoginAttribute.Builder> getLoginAttributes() {
            List<LoginAttribute.Builder> result = LoginAttributesCopier.copyToBuilder(this.loginAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoginAttributes(Collection<LoginAttribute.BuilderImpl> loginAttributes) {
            this.loginAttributes = LoginAttributesCopier.copyFromBuilder(loginAttributes);
        }

        @Override
        public final Builder loginAttributes(Collection<LoginAttribute> loginAttributes) {
            this.loginAttributes = LoginAttributesCopier.copy(loginAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loginAttributes(LoginAttribute... loginAttributes) {
            loginAttributes(Arrays.asList(loginAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loginAttributes(Consumer<LoginAttribute.Builder>... loginAttributes) {
            loginAttributes(Stream.of(loginAttributes).map(c -> LoginAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RdsLoginAttemptAction build() {
            return new RdsLoginAttemptAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
