/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the Amazon Web Services resource that is associated with the GuardDuty finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceV2 implements SdkPojo, Serializable, ToCopyableBuilder<ResourceV2.Builder, ResourceV2> {
    private static final SdkField<String> UID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Uid")
            .getter(getter(ResourceV2::uid)).setter(setter(Builder::uid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uid").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ResourceV2::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(ResourceV2::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ResourceV2::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(ResourceV2::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Service")
            .getter(getter(ResourceV2::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<String> CLOUD_PARTITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudPartition").getter(getter(ResourceV2::cloudPartition)).setter(setter(Builder::cloudPartition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudPartition").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ResourceV2::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ResourceData> DATA_FIELD = SdkField.<ResourceData> builder(MarshallingType.SDK_POJO)
            .memberName("Data").getter(getter(ResourceV2::data)).setter(setter(Builder::data)).constructor(ResourceData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UID_FIELD, NAME_FIELD,
            ACCOUNT_ID_FIELD, RESOURCE_TYPE_FIELD, REGION_FIELD, SERVICE_FIELD, CLOUD_PARTITION_FIELD, TAGS_FIELD, DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String uid;

    private final String name;

    private final String accountId;

    private final String resourceType;

    private final String region;

    private final String service;

    private final String cloudPartition;

    private final List<Tag> tags;

    private final ResourceData data;

    private ResourceV2(BuilderImpl builder) {
        this.uid = builder.uid;
        this.name = builder.name;
        this.accountId = builder.accountId;
        this.resourceType = builder.resourceType;
        this.region = builder.region;
        this.service = builder.service;
        this.cloudPartition = builder.cloudPartition;
        this.tags = builder.tags;
        this.data = builder.data;
    }

    /**
     * <p>
     * The unique identifier of the resource.
     * </p>
     * 
     * @return The unique identifier of the resource.
     */
    public final String uid() {
        return uid;
    }

    /**
     * <p>
     * The name of the resource.
     * </p>
     * 
     * @return The name of the resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Web Services account ID to which the resource belongs.
     * </p>
     * 
     * @return The Amazon Web Services account ID to which the resource belongs.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The type of the Amazon Web Services resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link FindingResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the Amazon Web Services resource.
     * @see FindingResourceType
     */
    public final FindingResourceType resourceType() {
        return FindingResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the Amazon Web Services resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link FindingResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the Amazon Web Services resource.
     * @see FindingResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the resource belongs.
     * </p>
     * 
     * @return The Amazon Web Services Region where the resource belongs.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The Amazon Web Services service of the resource.
     * </p>
     * 
     * @return The Amazon Web Services service of the resource.
     */
    public final String service() {
        return service;
    }

    /**
     * <p>
     * The cloud partition within the Amazon Web Services Region to which the resource belongs.
     * </p>
     * 
     * @return The cloud partition within the Amazon Web Services Region to which the resource belongs.
     */
    public final String cloudPartition() {
        return cloudPartition;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the tags associated with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Contains information about the tags associated with the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Contains information about the Amazon Web Services resource associated with the activity that prompted GuardDuty
     * to generate a finding.
     * </p>
     * 
     * @return Contains information about the Amazon Web Services resource associated with the activity that prompted
     *         GuardDuty to generate a finding.
     */
    public final ResourceData data() {
        return data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uid());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(cloudPartition());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(data());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceV2)) {
            return false;
        }
        ResourceV2 other = (ResourceV2) obj;
        return Objects.equals(uid(), other.uid()) && Objects.equals(name(), other.name())
                && Objects.equals(accountId(), other.accountId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(region(), other.region()) && Objects.equals(service(), other.service())
                && Objects.equals(cloudPartition(), other.cloudPartition()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(data(), other.data());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceV2").add("Uid", uid()).add("Name", name()).add("AccountId", accountId())
                .add("ResourceType", resourceTypeAsString()).add("Region", region()).add("Service", service())
                .add("CloudPartition", cloudPartition()).add("Tags", hasTags() ? tags() : null).add("Data", data()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Uid":
            return Optional.ofNullable(clazz.cast(uid()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        case "CloudPartition":
            return Optional.ofNullable(clazz.cast(cloudPartition()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("uid", UID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("region", REGION_FIELD);
        map.put("service", SERVICE_FIELD);
        map.put("cloudPartition", CLOUD_PARTITION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("data", DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceV2, T> g) {
        return obj -> g.apply((ResourceV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceV2> {
        /**
         * <p>
         * The unique identifier of the resource.
         * </p>
         * 
         * @param uid
         *        The unique identifier of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uid(String uid);

        /**
         * <p>
         * The name of the resource.
         * </p>
         * 
         * @param name
         *        The name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Web Services account ID to which the resource belongs.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID to which the resource belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The type of the Amazon Web Services resource.
         * </p>
         * 
         * @param resourceType
         *        The type of the Amazon Web Services resource.
         * @see FindingResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the Amazon Web Services resource.
         * </p>
         * 
         * @param resourceType
         *        The type of the Amazon Web Services resource.
         * @see FindingResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingResourceType
         */
        Builder resourceType(FindingResourceType resourceType);

        /**
         * <p>
         * The Amazon Web Services Region where the resource belongs.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region where the resource belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The Amazon Web Services service of the resource.
         * </p>
         * 
         * @param service
         *        The Amazon Web Services service of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * The cloud partition within the Amazon Web Services Region to which the resource belongs.
         * </p>
         * 
         * @param cloudPartition
         *        The cloud partition within the Amazon Web Services Region to which the resource belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudPartition(String cloudPartition);

        /**
         * <p>
         * Contains information about the tags associated with the resource.
         * </p>
         * 
         * @param tags
         *        Contains information about the tags associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Contains information about the tags associated with the resource.
         * </p>
         * 
         * @param tags
         *        Contains information about the tags associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Contains information about the tags associated with the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.guardduty.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Contains information about the Amazon Web Services resource associated with the activity that prompted
         * GuardDuty to generate a finding.
         * </p>
         * 
         * @param data
         *        Contains information about the Amazon Web Services resource associated with the activity that prompted
         *        GuardDuty to generate a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(ResourceData data);

        /**
         * <p>
         * Contains information about the Amazon Web Services resource associated with the activity that prompted
         * GuardDuty to generate a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceData.Builder} avoiding the need
         * to create one manually via {@link ResourceData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceData.Builder#build()} is called immediately and its
         * result is passed to {@link #data(ResourceData)}.
         * 
         * @param data
         *        a consumer that will call methods on {@link ResourceData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #data(ResourceData)
         */
        default Builder data(Consumer<ResourceData.Builder> data) {
            return data(ResourceData.builder().applyMutation(data).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String uid;

        private String name;

        private String accountId;

        private String resourceType;

        private String region;

        private String service;

        private String cloudPartition;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private ResourceData data;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceV2 model) {
            uid(model.uid);
            name(model.name);
            accountId(model.accountId);
            resourceType(model.resourceType);
            region(model.region);
            service(model.service);
            cloudPartition(model.cloudPartition);
            tags(model.tags);
            data(model.data);
        }

        public final String getUid() {
            return uid;
        }

        public final void setUid(String uid) {
            this.uid = uid;
        }

        @Override
        public final Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(FindingResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final String getCloudPartition() {
            return cloudPartition;
        }

        public final void setCloudPartition(String cloudPartition) {
            this.cloudPartition = cloudPartition;
        }

        @Override
        public final Builder cloudPartition(String cloudPartition) {
            this.cloudPartition = cloudPartition;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ResourceData.Builder getData() {
            return data != null ? data.toBuilder() : null;
        }

        public final void setData(ResourceData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(ResourceData data) {
            this.data = data;
            return this;
        }

        @Override
        public ResourceV2 build() {
            return new ResourceV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
