/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the process and any required context values for a specific finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuntimeDetails implements SdkPojo, Serializable, ToCopyableBuilder<RuntimeDetails.Builder, RuntimeDetails> {
    private static final SdkField<ProcessDetails> PROCESS_FIELD = SdkField.<ProcessDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Process").getter(getter(RuntimeDetails::process)).setter(setter(Builder::process))
            .constructor(ProcessDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("process").build()).build();

    private static final SdkField<RuntimeContext> CONTEXT_FIELD = SdkField.<RuntimeContext> builder(MarshallingType.SDK_POJO)
            .memberName("Context").getter(getter(RuntimeDetails::context)).setter(setter(Builder::context))
            .constructor(RuntimeContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESS_FIELD, CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ProcessDetails process;

    private final RuntimeContext context;

    private RuntimeDetails(BuilderImpl builder) {
        this.process = builder.process;
        this.context = builder.context;
    }

    /**
     * <p>
     * Information about the observed process.
     * </p>
     * 
     * @return Information about the observed process.
     */
    public final ProcessDetails process() {
        return process;
    }

    /**
     * <p>
     * Additional information about the suspicious activity.
     * </p>
     * 
     * @return Additional information about the suspicious activity.
     */
    public final RuntimeContext context() {
        return context;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(process());
        hashCode = 31 * hashCode + Objects.hashCode(context());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeDetails)) {
            return false;
        }
        RuntimeDetails other = (RuntimeDetails) obj;
        return Objects.equals(process(), other.process()) && Objects.equals(context(), other.context());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuntimeDetails").add("Process", process()).add("Context", context()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Process":
            return Optional.ofNullable(clazz.cast(process()));
        case "Context":
            return Optional.ofNullable(clazz.cast(context()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("process", PROCESS_FIELD);
        map.put("context", CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuntimeDetails, T> g) {
        return obj -> g.apply((RuntimeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuntimeDetails> {
        /**
         * <p>
         * Information about the observed process.
         * </p>
         * 
         * @param process
         *        Information about the observed process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder process(ProcessDetails process);

        /**
         * <p>
         * Information about the observed process.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProcessDetails.Builder} avoiding the need
         * to create one manually via {@link ProcessDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProcessDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #process(ProcessDetails)}.
         * 
         * @param process
         *        a consumer that will call methods on {@link ProcessDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #process(ProcessDetails)
         */
        default Builder process(Consumer<ProcessDetails.Builder> process) {
            return process(ProcessDetails.builder().applyMutation(process).build());
        }

        /**
         * <p>
         * Additional information about the suspicious activity.
         * </p>
         * 
         * @param context
         *        Additional information about the suspicious activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(RuntimeContext context);

        /**
         * <p>
         * Additional information about the suspicious activity.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuntimeContext.Builder} avoiding the need
         * to create one manually via {@link RuntimeContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuntimeContext.Builder#build()} is called immediately and its
         * result is passed to {@link #context(RuntimeContext)}.
         * 
         * @param context
         *        a consumer that will call methods on {@link RuntimeContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #context(RuntimeContext)
         */
        default Builder context(Consumer<RuntimeContext.Builder> context) {
            return context(RuntimeContext.builder().applyMutation(context).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProcessDetails process;

        private RuntimeContext context;

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeDetails model) {
            process(model.process);
            context(model.context);
        }

        public final ProcessDetails.Builder getProcess() {
            return process != null ? process.toBuilder() : null;
        }

        public final void setProcess(ProcessDetails.BuilderImpl process) {
            this.process = process != null ? process.build() : null;
        }

        @Override
        public final Builder process(ProcessDetails process) {
            this.process = process;
            return this;
        }

        public final RuntimeContext.Builder getContext() {
            return context != null ? context.toBuilder() : null;
        }

        public final void setContext(RuntimeContext.BuilderImpl context) {
            this.context = context != null ? context.build() : null;
        }

        @Override
        public final Builder context(RuntimeContext context) {
            this.context = context;
            return this;
        }

        @Override
        public RuntimeDetails build() {
            return new RuntimeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
