/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a complete view providing malware scan result details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScanDetections implements SdkPojo, Serializable, ToCopyableBuilder<ScanDetections.Builder, ScanDetections> {
    private static final SdkField<ScannedItemCount> SCANNED_ITEM_COUNT_FIELD = SdkField
            .<ScannedItemCount> builder(MarshallingType.SDK_POJO).memberName("ScannedItemCount")
            .getter(getter(ScanDetections::scannedItemCount)).setter(setter(Builder::scannedItemCount))
            .constructor(ScannedItemCount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scannedItemCount").build()).build();

    private static final SdkField<ThreatsDetectedItemCount> THREATS_DETECTED_ITEM_COUNT_FIELD = SdkField
            .<ThreatsDetectedItemCount> builder(MarshallingType.SDK_POJO).memberName("ThreatsDetectedItemCount")
            .getter(getter(ScanDetections::threatsDetectedItemCount)).setter(setter(Builder::threatsDetectedItemCount))
            .constructor(ThreatsDetectedItemCount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatsDetectedItemCount").build())
            .build();

    private static final SdkField<HighestSeverityThreatDetails> HIGHEST_SEVERITY_THREAT_DETAILS_FIELD = SdkField
            .<HighestSeverityThreatDetails> builder(MarshallingType.SDK_POJO)
            .memberName("HighestSeverityThreatDetails")
            .getter(getter(ScanDetections::highestSeverityThreatDetails))
            .setter(setter(Builder::highestSeverityThreatDetails))
            .constructor(HighestSeverityThreatDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("highestSeverityThreatDetails")
                    .build()).build();

    private static final SdkField<ThreatDetectedByName> THREAT_DETECTED_BY_NAME_FIELD = SdkField
            .<ThreatDetectedByName> builder(MarshallingType.SDK_POJO).memberName("ThreatDetectedByName")
            .getter(getter(ScanDetections::threatDetectedByName)).setter(setter(Builder::threatDetectedByName))
            .constructor(ThreatDetectedByName::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatDetectedByName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCANNED_ITEM_COUNT_FIELD,
            THREATS_DETECTED_ITEM_COUNT_FIELD, HIGHEST_SEVERITY_THREAT_DETAILS_FIELD, THREAT_DETECTED_BY_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ScannedItemCount scannedItemCount;

    private final ThreatsDetectedItemCount threatsDetectedItemCount;

    private final HighestSeverityThreatDetails highestSeverityThreatDetails;

    private final ThreatDetectedByName threatDetectedByName;

    private ScanDetections(BuilderImpl builder) {
        this.scannedItemCount = builder.scannedItemCount;
        this.threatsDetectedItemCount = builder.threatsDetectedItemCount;
        this.highestSeverityThreatDetails = builder.highestSeverityThreatDetails;
        this.threatDetectedByName = builder.threatDetectedByName;
    }

    /**
     * <p>
     * Total number of scanned files.
     * </p>
     * 
     * @return Total number of scanned files.
     */
    public final ScannedItemCount scannedItemCount() {
        return scannedItemCount;
    }

    /**
     * <p>
     * Total number of infected files.
     * </p>
     * 
     * @return Total number of infected files.
     */
    public final ThreatsDetectedItemCount threatsDetectedItemCount() {
        return threatsDetectedItemCount;
    }

    /**
     * <p>
     * Details of the highest severity threat detected during malware scan and number of infected files.
     * </p>
     * 
     * @return Details of the highest severity threat detected during malware scan and number of infected files.
     */
    public final HighestSeverityThreatDetails highestSeverityThreatDetails() {
        return highestSeverityThreatDetails;
    }

    /**
     * <p>
     * Contains details about identified threats organized by threat name.
     * </p>
     * 
     * @return Contains details about identified threats organized by threat name.
     */
    public final ThreatDetectedByName threatDetectedByName() {
        return threatDetectedByName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scannedItemCount());
        hashCode = 31 * hashCode + Objects.hashCode(threatsDetectedItemCount());
        hashCode = 31 * hashCode + Objects.hashCode(highestSeverityThreatDetails());
        hashCode = 31 * hashCode + Objects.hashCode(threatDetectedByName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanDetections)) {
            return false;
        }
        ScanDetections other = (ScanDetections) obj;
        return Objects.equals(scannedItemCount(), other.scannedItemCount())
                && Objects.equals(threatsDetectedItemCount(), other.threatsDetectedItemCount())
                && Objects.equals(highestSeverityThreatDetails(), other.highestSeverityThreatDetails())
                && Objects.equals(threatDetectedByName(), other.threatDetectedByName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScanDetections").add("ScannedItemCount", scannedItemCount())
                .add("ThreatsDetectedItemCount", threatsDetectedItemCount())
                .add("HighestSeverityThreatDetails", highestSeverityThreatDetails())
                .add("ThreatDetectedByName", threatDetectedByName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScannedItemCount":
            return Optional.ofNullable(clazz.cast(scannedItemCount()));
        case "ThreatsDetectedItemCount":
            return Optional.ofNullable(clazz.cast(threatsDetectedItemCount()));
        case "HighestSeverityThreatDetails":
            return Optional.ofNullable(clazz.cast(highestSeverityThreatDetails()));
        case "ThreatDetectedByName":
            return Optional.ofNullable(clazz.cast(threatDetectedByName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scannedItemCount", SCANNED_ITEM_COUNT_FIELD);
        map.put("threatsDetectedItemCount", THREATS_DETECTED_ITEM_COUNT_FIELD);
        map.put("highestSeverityThreatDetails", HIGHEST_SEVERITY_THREAT_DETAILS_FIELD);
        map.put("threatDetectedByName", THREAT_DETECTED_BY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScanDetections, T> g) {
        return obj -> g.apply((ScanDetections) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScanDetections> {
        /**
         * <p>
         * Total number of scanned files.
         * </p>
         * 
         * @param scannedItemCount
         *        Total number of scanned files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scannedItemCount(ScannedItemCount scannedItemCount);

        /**
         * <p>
         * Total number of scanned files.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScannedItemCount.Builder} avoiding the
         * need to create one manually via {@link ScannedItemCount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScannedItemCount.Builder#build()} is called immediately and its
         * result is passed to {@link #scannedItemCount(ScannedItemCount)}.
         * 
         * @param scannedItemCount
         *        a consumer that will call methods on {@link ScannedItemCount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scannedItemCount(ScannedItemCount)
         */
        default Builder scannedItemCount(Consumer<ScannedItemCount.Builder> scannedItemCount) {
            return scannedItemCount(ScannedItemCount.builder().applyMutation(scannedItemCount).build());
        }

        /**
         * <p>
         * Total number of infected files.
         * </p>
         * 
         * @param threatsDetectedItemCount
         *        Total number of infected files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatsDetectedItemCount(ThreatsDetectedItemCount threatsDetectedItemCount);

        /**
         * <p>
         * Total number of infected files.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThreatsDetectedItemCount.Builder}
         * avoiding the need to create one manually via {@link ThreatsDetectedItemCount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ThreatsDetectedItemCount.Builder#build()} is called immediately
         * and its result is passed to {@link #threatsDetectedItemCount(ThreatsDetectedItemCount)}.
         * 
         * @param threatsDetectedItemCount
         *        a consumer that will call methods on {@link ThreatsDetectedItemCount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threatsDetectedItemCount(ThreatsDetectedItemCount)
         */
        default Builder threatsDetectedItemCount(Consumer<ThreatsDetectedItemCount.Builder> threatsDetectedItemCount) {
            return threatsDetectedItemCount(ThreatsDetectedItemCount.builder().applyMutation(threatsDetectedItemCount).build());
        }

        /**
         * <p>
         * Details of the highest severity threat detected during malware scan and number of infected files.
         * </p>
         * 
         * @param highestSeverityThreatDetails
         *        Details of the highest severity threat detected during malware scan and number of infected files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder highestSeverityThreatDetails(HighestSeverityThreatDetails highestSeverityThreatDetails);

        /**
         * <p>
         * Details of the highest severity threat detected during malware scan and number of infected files.
         * </p>
         * This is a convenience method that creates an instance of the {@link HighestSeverityThreatDetails.Builder}
         * avoiding the need to create one manually via {@link HighestSeverityThreatDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HighestSeverityThreatDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #highestSeverityThreatDetails(HighestSeverityThreatDetails)}.
         * 
         * @param highestSeverityThreatDetails
         *        a consumer that will call methods on {@link HighestSeverityThreatDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #highestSeverityThreatDetails(HighestSeverityThreatDetails)
         */
        default Builder highestSeverityThreatDetails(Consumer<HighestSeverityThreatDetails.Builder> highestSeverityThreatDetails) {
            return highestSeverityThreatDetails(HighestSeverityThreatDetails.builder()
                    .applyMutation(highestSeverityThreatDetails).build());
        }

        /**
         * <p>
         * Contains details about identified threats organized by threat name.
         * </p>
         * 
         * @param threatDetectedByName
         *        Contains details about identified threats organized by threat name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatDetectedByName(ThreatDetectedByName threatDetectedByName);

        /**
         * <p>
         * Contains details about identified threats organized by threat name.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThreatDetectedByName.Builder} avoiding
         * the need to create one manually via {@link ThreatDetectedByName#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ThreatDetectedByName.Builder#build()} is called immediately and
         * its result is passed to {@link #threatDetectedByName(ThreatDetectedByName)}.
         * 
         * @param threatDetectedByName
         *        a consumer that will call methods on {@link ThreatDetectedByName.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threatDetectedByName(ThreatDetectedByName)
         */
        default Builder threatDetectedByName(Consumer<ThreatDetectedByName.Builder> threatDetectedByName) {
            return threatDetectedByName(ThreatDetectedByName.builder().applyMutation(threatDetectedByName).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ScannedItemCount scannedItemCount;

        private ThreatsDetectedItemCount threatsDetectedItemCount;

        private HighestSeverityThreatDetails highestSeverityThreatDetails;

        private ThreatDetectedByName threatDetectedByName;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanDetections model) {
            scannedItemCount(model.scannedItemCount);
            threatsDetectedItemCount(model.threatsDetectedItemCount);
            highestSeverityThreatDetails(model.highestSeverityThreatDetails);
            threatDetectedByName(model.threatDetectedByName);
        }

        public final ScannedItemCount.Builder getScannedItemCount() {
            return scannedItemCount != null ? scannedItemCount.toBuilder() : null;
        }

        public final void setScannedItemCount(ScannedItemCount.BuilderImpl scannedItemCount) {
            this.scannedItemCount = scannedItemCount != null ? scannedItemCount.build() : null;
        }

        @Override
        public final Builder scannedItemCount(ScannedItemCount scannedItemCount) {
            this.scannedItemCount = scannedItemCount;
            return this;
        }

        public final ThreatsDetectedItemCount.Builder getThreatsDetectedItemCount() {
            return threatsDetectedItemCount != null ? threatsDetectedItemCount.toBuilder() : null;
        }

        public final void setThreatsDetectedItemCount(ThreatsDetectedItemCount.BuilderImpl threatsDetectedItemCount) {
            this.threatsDetectedItemCount = threatsDetectedItemCount != null ? threatsDetectedItemCount.build() : null;
        }

        @Override
        public final Builder threatsDetectedItemCount(ThreatsDetectedItemCount threatsDetectedItemCount) {
            this.threatsDetectedItemCount = threatsDetectedItemCount;
            return this;
        }

        public final HighestSeverityThreatDetails.Builder getHighestSeverityThreatDetails() {
            return highestSeverityThreatDetails != null ? highestSeverityThreatDetails.toBuilder() : null;
        }

        public final void setHighestSeverityThreatDetails(HighestSeverityThreatDetails.BuilderImpl highestSeverityThreatDetails) {
            this.highestSeverityThreatDetails = highestSeverityThreatDetails != null ? highestSeverityThreatDetails.build()
                    : null;
        }

        @Override
        public final Builder highestSeverityThreatDetails(HighestSeverityThreatDetails highestSeverityThreatDetails) {
            this.highestSeverityThreatDetails = highestSeverityThreatDetails;
            return this;
        }

        public final ThreatDetectedByName.Builder getThreatDetectedByName() {
            return threatDetectedByName != null ? threatDetectedByName.toBuilder() : null;
        }

        public final void setThreatDetectedByName(ThreatDetectedByName.BuilderImpl threatDetectedByName) {
            this.threatDetectedByName = threatDetectedByName != null ? threatDetectedByName.build() : null;
        }

        @Override
        public final Builder threatDetectedByName(ThreatDetectedByName threatDetectedByName) {
            this.threatDetectedByName = threatDetectedByName;
            return this;
        }

        @Override
        public ScanDetections build() {
            return new ScanDetections(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
