/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains total number of infected files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThreatsDetectedItemCount implements SdkPojo, Serializable,
        ToCopyableBuilder<ThreatsDetectedItemCount.Builder, ThreatsDetectedItemCount> {
    private static final SdkField<Integer> FILES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Files")
            .getter(getter(ThreatsDetectedItemCount::files)).setter(setter(Builder::files))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer files;

    private ThreatsDetectedItemCount(BuilderImpl builder) {
        this.files = builder.files;
    }

    /**
     * <p>
     * Total number of infected files.
     * </p>
     * 
     * @return Total number of infected files.
     */
    public final Integer files() {
        return files;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(files());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThreatsDetectedItemCount)) {
            return false;
        }
        ThreatsDetectedItemCount other = (ThreatsDetectedItemCount) obj;
        return Objects.equals(files(), other.files());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThreatsDetectedItemCount").add("Files", files()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Files":
            return Optional.ofNullable(clazz.cast(files()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("files", FILES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThreatsDetectedItemCount, T> g) {
        return obj -> g.apply((ThreatsDetectedItemCount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThreatsDetectedItemCount> {
        /**
         * <p>
         * Total number of infected files.
         * </p>
         * 
         * @param files
         *        Total number of infected files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(Integer files);
    }

    static final class BuilderImpl implements Builder {
        private Integer files;

        private BuilderImpl() {
        }

        private BuilderImpl(ThreatsDetectedItemCount model) {
            files(model.files);
        }

        public final Integer getFiles() {
            return files;
        }

        public final void setFiles(Integer files) {
            this.files = files;
        }

        @Override
        public final Builder files(Integer files) {
            this.files = files;
            return this;
        }

        @Override
        public ThreatsDetectedItemCount build() {
            return new ThreatsDetectedItemCount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
