/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the names of the data sources that couldn't be enabled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnprocessedDataSourcesResult implements SdkPojo, Serializable,
        ToCopyableBuilder<UnprocessedDataSourcesResult.Builder, UnprocessedDataSourcesResult> {
    private static final SdkField<MalwareProtectionConfigurationResult> MALWARE_PROTECTION_FIELD = SdkField
            .<MalwareProtectionConfigurationResult> builder(MarshallingType.SDK_POJO).memberName("MalwareProtection")
            .getter(getter(UnprocessedDataSourcesResult::malwareProtection)).setter(setter(Builder::malwareProtection))
            .constructor(MalwareProtectionConfigurationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("malwareProtection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MALWARE_PROTECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MalwareProtectionConfigurationResult malwareProtection;

    private UnprocessedDataSourcesResult(BuilderImpl builder) {
        this.malwareProtection = builder.malwareProtection;
    }

    /**
     * Returns the value of the MalwareProtection property for this object.
     * 
     * @return The value of the MalwareProtection property for this object.
     */
    public final MalwareProtectionConfigurationResult malwareProtection() {
        return malwareProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(malwareProtection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnprocessedDataSourcesResult)) {
            return false;
        }
        UnprocessedDataSourcesResult other = (UnprocessedDataSourcesResult) obj;
        return Objects.equals(malwareProtection(), other.malwareProtection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnprocessedDataSourcesResult").add("MalwareProtection", malwareProtection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MalwareProtection":
            return Optional.ofNullable(clazz.cast(malwareProtection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("malwareProtection", MALWARE_PROTECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnprocessedDataSourcesResult, T> g) {
        return obj -> g.apply((UnprocessedDataSourcesResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnprocessedDataSourcesResult> {
        /**
         * Sets the value of the MalwareProtection property for this object.
         *
         * @param malwareProtection
         *        The new value for the MalwareProtection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malwareProtection(MalwareProtectionConfigurationResult malwareProtection);

        /**
         * Sets the value of the MalwareProtection property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link MalwareProtectionConfigurationResult.Builder} avoiding the need to create one manually via
         * {@link MalwareProtectionConfigurationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MalwareProtectionConfigurationResult.Builder#build()} is called
         * immediately and its result is passed to {@link #malwareProtection(MalwareProtectionConfigurationResult)}.
         * 
         * @param malwareProtection
         *        a consumer that will call methods on {@link MalwareProtectionConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #malwareProtection(MalwareProtectionConfigurationResult)
         */
        default Builder malwareProtection(Consumer<MalwareProtectionConfigurationResult.Builder> malwareProtection) {
            return malwareProtection(MalwareProtectionConfigurationResult.builder().applyMutation(malwareProtection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MalwareProtectionConfigurationResult malwareProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessedDataSourcesResult model) {
            malwareProtection(model.malwareProtection);
        }

        public final MalwareProtectionConfigurationResult.Builder getMalwareProtection() {
            return malwareProtection != null ? malwareProtection.toBuilder() : null;
        }

        public final void setMalwareProtection(MalwareProtectionConfigurationResult.BuilderImpl malwareProtection) {
            this.malwareProtection = malwareProtection != null ? malwareProtection.build() : null;
        }

        @Override
        public final Builder malwareProtection(MalwareProtectionConfigurationResult malwareProtection) {
            this.malwareProtection = malwareProtection;
            return this;
        }

        @Override
        public UnprocessedDataSourcesResult build() {
            return new UnprocessedDataSourcesResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
