/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMalwareScanSettingsRequest extends GuardDutyRequest implements
        ToCopyableBuilder<UpdateMalwareScanSettingsRequest.Builder, UpdateMalwareScanSettingsRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(UpdateMalwareScanSettingsRequest::detectorId))
            .setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<ScanResourceCriteria> SCAN_RESOURCE_CRITERIA_FIELD = SdkField
            .<ScanResourceCriteria> builder(MarshallingType.SDK_POJO).memberName("ScanResourceCriteria")
            .getter(getter(UpdateMalwareScanSettingsRequest::scanResourceCriteria)).setter(setter(Builder::scanResourceCriteria))
            .constructor(ScanResourceCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanResourceCriteria").build())
            .build();

    private static final SdkField<String> EBS_SNAPSHOT_PRESERVATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EbsSnapshotPreservation")
            .getter(getter(UpdateMalwareScanSettingsRequest::ebsSnapshotPreservationAsString))
            .setter(setter(Builder::ebsSnapshotPreservation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsSnapshotPreservation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            SCAN_RESOURCE_CRITERIA_FIELD, EBS_SNAPSHOT_PRESERVATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String detectorId;

    private final ScanResourceCriteria scanResourceCriteria;

    private final String ebsSnapshotPreservation;

    private UpdateMalwareScanSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.scanResourceCriteria = builder.scanResourceCriteria;
        this.ebsSnapshotPreservation = builder.ebsSnapshotPreservation;
    }

    /**
     * <p>
     * The unique ID of the detector that specifies the GuardDuty service where you want to update scan settings.
     * </p>
     * <p>
     * To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty console, or run
     * the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
     * API.
     * </p>
     * 
     * @return The unique ID of the detector that specifies the GuardDuty service where you want to update scan
     *         settings.</p>
     *         <p>
     *         To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty
     *         console, or run the <a
     *         href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
     *         API.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * Represents the criteria to be used in the filter for selecting resources to scan.
     * </p>
     * 
     * @return Represents the criteria to be used in the filter for selecting resources to scan.
     */
    public final ScanResourceCriteria scanResourceCriteria() {
        return scanResourceCriteria;
    }

    /**
     * <p>
     * An enum value representing possible snapshot preservation settings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ebsSnapshotPreservation} will return {@link EbsSnapshotPreservation#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #ebsSnapshotPreservationAsString}.
     * </p>
     * 
     * @return An enum value representing possible snapshot preservation settings.
     * @see EbsSnapshotPreservation
     */
    public final EbsSnapshotPreservation ebsSnapshotPreservation() {
        return EbsSnapshotPreservation.fromValue(ebsSnapshotPreservation);
    }

    /**
     * <p>
     * An enum value representing possible snapshot preservation settings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ebsSnapshotPreservation} will return {@link EbsSnapshotPreservation#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #ebsSnapshotPreservationAsString}.
     * </p>
     * 
     * @return An enum value representing possible snapshot preservation settings.
     * @see EbsSnapshotPreservation
     */
    public final String ebsSnapshotPreservationAsString() {
        return ebsSnapshotPreservation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(scanResourceCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(ebsSnapshotPreservationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMalwareScanSettingsRequest)) {
            return false;
        }
        UpdateMalwareScanSettingsRequest other = (UpdateMalwareScanSettingsRequest) obj;
        return Objects.equals(detectorId(), other.detectorId())
                && Objects.equals(scanResourceCriteria(), other.scanResourceCriteria())
                && Objects.equals(ebsSnapshotPreservationAsString(), other.ebsSnapshotPreservationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMalwareScanSettingsRequest").add("DetectorId", detectorId())
                .add("ScanResourceCriteria", scanResourceCriteria())
                .add("EbsSnapshotPreservation", ebsSnapshotPreservationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "ScanResourceCriteria":
            return Optional.ofNullable(clazz.cast(scanResourceCriteria()));
        case "EbsSnapshotPreservation":
            return Optional.ofNullable(clazz.cast(ebsSnapshotPreservationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("scanResourceCriteria", SCAN_RESOURCE_CRITERIA_FIELD);
        map.put("ebsSnapshotPreservation", EBS_SNAPSHOT_PRESERVATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMalwareScanSettingsRequest, T> g) {
        return obj -> g.apply((UpdateMalwareScanSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMalwareScanSettingsRequest> {
        /**
         * <p>
         * The unique ID of the detector that specifies the GuardDuty service where you want to update scan settings.
         * </p>
         * <p>
         * To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty console, or
         * run the <a
         * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
         * API.
         * </p>
         * 
         * @param detectorId
         *        The unique ID of the detector that specifies the GuardDuty service where you want to update scan
         *        settings.</p>
         *        <p>
         *        To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty
         *        console, or run the <a
         *        href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html"
         *        >ListDetectors</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * Represents the criteria to be used in the filter for selecting resources to scan.
         * </p>
         * 
         * @param scanResourceCriteria
         *        Represents the criteria to be used in the filter for selecting resources to scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanResourceCriteria(ScanResourceCriteria scanResourceCriteria);

        /**
         * <p>
         * Represents the criteria to be used in the filter for selecting resources to scan.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScanResourceCriteria.Builder} avoiding
         * the need to create one manually via {@link ScanResourceCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScanResourceCriteria.Builder#build()} is called immediately and
         * its result is passed to {@link #scanResourceCriteria(ScanResourceCriteria)}.
         * 
         * @param scanResourceCriteria
         *        a consumer that will call methods on {@link ScanResourceCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanResourceCriteria(ScanResourceCriteria)
         */
        default Builder scanResourceCriteria(Consumer<ScanResourceCriteria.Builder> scanResourceCriteria) {
            return scanResourceCriteria(ScanResourceCriteria.builder().applyMutation(scanResourceCriteria).build());
        }

        /**
         * <p>
         * An enum value representing possible snapshot preservation settings.
         * </p>
         * 
         * @param ebsSnapshotPreservation
         *        An enum value representing possible snapshot preservation settings.
         * @see EbsSnapshotPreservation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EbsSnapshotPreservation
         */
        Builder ebsSnapshotPreservation(String ebsSnapshotPreservation);

        /**
         * <p>
         * An enum value representing possible snapshot preservation settings.
         * </p>
         * 
         * @param ebsSnapshotPreservation
         *        An enum value representing possible snapshot preservation settings.
         * @see EbsSnapshotPreservation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EbsSnapshotPreservation
         */
        Builder ebsSnapshotPreservation(EbsSnapshotPreservation ebsSnapshotPreservation);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private ScanResourceCriteria scanResourceCriteria;

        private String ebsSnapshotPreservation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMalwareScanSettingsRequest model) {
            super(model);
            detectorId(model.detectorId);
            scanResourceCriteria(model.scanResourceCriteria);
            ebsSnapshotPreservation(model.ebsSnapshotPreservation);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final ScanResourceCriteria.Builder getScanResourceCriteria() {
            return scanResourceCriteria != null ? scanResourceCriteria.toBuilder() : null;
        }

        public final void setScanResourceCriteria(ScanResourceCriteria.BuilderImpl scanResourceCriteria) {
            this.scanResourceCriteria = scanResourceCriteria != null ? scanResourceCriteria.build() : null;
        }

        @Override
        public final Builder scanResourceCriteria(ScanResourceCriteria scanResourceCriteria) {
            this.scanResourceCriteria = scanResourceCriteria;
            return this;
        }

        public final String getEbsSnapshotPreservation() {
            return ebsSnapshotPreservation;
        }

        public final void setEbsSnapshotPreservation(String ebsSnapshotPreservation) {
            this.ebsSnapshotPreservation = ebsSnapshotPreservation;
        }

        @Override
        public final Builder ebsSnapshotPreservation(String ebsSnapshotPreservation) {
            this.ebsSnapshotPreservation = ebsSnapshotPreservation;
            return this;
        }

        @Override
        public final Builder ebsSnapshotPreservation(EbsSnapshotPreservation ebsSnapshotPreservation) {
            this.ebsSnapshotPreservation(ebsSnapshotPreservation == null ? null : ebsSnapshotPreservation.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMalwareScanSettingsRequest build() {
            return new UpdateMalwareScanSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
