/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateOrganizationConfigurationRequest extends GuardDutyRequest implements
        ToCopyableBuilder<UpdateOrganizationConfigurationRequest.Builder, UpdateOrganizationConfigurationRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(UpdateOrganizationConfigurationRequest::detectorId))
            .setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<Boolean> AUTO_ENABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoEnable").getter(getter(UpdateOrganizationConfigurationRequest::autoEnable))
            .setter(setter(Builder::autoEnable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnable").build()).build();

    private static final SdkField<OrganizationDataSourceConfigurations> DATA_SOURCES_FIELD = SdkField
            .<OrganizationDataSourceConfigurations> builder(MarshallingType.SDK_POJO).memberName("DataSources")
            .getter(getter(UpdateOrganizationConfigurationRequest::dataSources)).setter(setter(Builder::dataSources))
            .constructor(OrganizationDataSourceConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()).build();

    private static final SdkField<List<OrganizationFeatureConfiguration>> FEATURES_FIELD = SdkField
            .<List<OrganizationFeatureConfiguration>> builder(MarshallingType.LIST)
            .memberName("Features")
            .getter(getter(UpdateOrganizationConfigurationRequest::features))
            .setter(setter(Builder::features))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrganizationFeatureConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrganizationFeatureConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AUTO_ENABLE_ORGANIZATION_MEMBERS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoEnableOrganizationMembers")
            .getter(getter(UpdateOrganizationConfigurationRequest::autoEnableOrganizationMembersAsString))
            .setter(setter(Builder::autoEnableOrganizationMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnableOrganizationMembers")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            AUTO_ENABLE_FIELD, DATA_SOURCES_FIELD, FEATURES_FIELD, AUTO_ENABLE_ORGANIZATION_MEMBERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String detectorId;

    private final Boolean autoEnable;

    private final OrganizationDataSourceConfigurations dataSources;

    private final List<OrganizationFeatureConfiguration> features;

    private final String autoEnableOrganizationMembers;

    private UpdateOrganizationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.autoEnable = builder.autoEnable;
        this.dataSources = builder.dataSources;
        this.features = builder.features;
        this.autoEnableOrganizationMembers = builder.autoEnableOrganizationMembers;
    }

    /**
     * <p>
     * The ID of the detector that configures the delegated administrator.
     * </p>
     * <p>
     * To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty console, or run
     * the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
     * API.
     * </p>
     * 
     * @return The ID of the detector that configures the delegated administrator.</p>
     *         <p>
     *         To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty
     *         console, or run the <a
     *         href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
     *         API.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * Represents whether to automatically enable member accounts in the organization. This applies to only new member
     * accounts, not the existing member accounts. When a new account joins the organization, the chosen features will
     * be enabled for them by default.
     * </p>
     * <p>
     * Even though this is still supported, we recommend using <code>AutoEnableOrganizationMembers</code> to achieve the
     * similar results. You must provide a value for either <code>autoEnableOrganizationMembers</code> or
     * <code>autoEnable</code>.
     * </p>
     * 
     * @return Represents whether to automatically enable member accounts in the organization. This applies to only new
     *         member accounts, not the existing member accounts. When a new account joins the organization, the chosen
     *         features will be enabled for them by default.</p>
     *         <p>
     *         Even though this is still supported, we recommend using <code>AutoEnableOrganizationMembers</code> to
     *         achieve the similar results. You must provide a value for either
     *         <code>autoEnableOrganizationMembers</code> or <code>autoEnable</code>.
     * @deprecated This field is deprecated, use AutoEnableOrganizationMembers instead
     */
    @Deprecated
    public final Boolean autoEnable() {
        return autoEnable;
    }

    /**
     * <p>
     * Describes which data sources will be updated.
     * </p>
     * 
     * @return Describes which data sources will be updated.
     * @deprecated This parameter is deprecated, use Features instead
     */
    @Deprecated
    public final OrganizationDataSourceConfigurations dataSources() {
        return dataSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Features property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFeatures() {
        return features != null && !(features instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of features that will be configured for the organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatures} method.
     * </p>
     * 
     * @return A list of features that will be configured for the organization.
     */
    public final List<OrganizationFeatureConfiguration> features() {
        return features;
    }

    /**
     * <p>
     * Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization. You must
     * provide a value for either <code>autoEnableOrganizationMembers</code> or <code>autoEnable</code>.
     * </p>
     * <p>
     * Use one of the following configuration values for <code>autoEnableOrganizationMembers</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NEW</code>: Indicates that when a new account joins the organization, they will have GuardDuty enabled
     * automatically.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code>: Indicates that all accounts in the organization have GuardDuty enabled automatically. This
     * includes <code>NEW</code> accounts that join the organization and accounts that may have been suspended or
     * removed from the organization in GuardDuty.
     * </p>
     * <p>
     * It may take up to 24 hours to update the configuration for all the member accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>: Indicates that GuardDuty will not be automatically enabled for any account in the
     * organization. The administrator must manage GuardDuty for each account in the organization individually.
     * </p>
     * <p>
     * When you update the auto-enable setting from <code>ALL</code> or <code>NEW</code> to <code>NONE</code>, this
     * action doesn't disable the corresponding option for your existing accounts. This configuration will apply to the
     * new accounts that join the organization. After you update the auto-enable settings, no new account will have the
     * corresponding option as enabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoEnableOrganizationMembers} will return {@link AutoEnableMembers#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #autoEnableOrganizationMembersAsString}.
     * </p>
     * 
     * @return Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization. You
     *         must provide a value for either <code>autoEnableOrganizationMembers</code> or <code>autoEnable</code>.
     *         </p>
     *         <p>
     *         Use one of the following configuration values for <code>autoEnableOrganizationMembers</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NEW</code>: Indicates that when a new account joins the organization, they will have GuardDuty
     *         enabled automatically.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code>: Indicates that all accounts in the organization have GuardDuty enabled automatically.
     *         This includes <code>NEW</code> accounts that join the organization and accounts that may have been
     *         suspended or removed from the organization in GuardDuty.
     *         </p>
     *         <p>
     *         It may take up to 24 hours to update the configuration for all the member accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>: Indicates that GuardDuty will not be automatically enabled for any account in the
     *         organization. The administrator must manage GuardDuty for each account in the organization individually.
     *         </p>
     *         <p>
     *         When you update the auto-enable setting from <code>ALL</code> or <code>NEW</code> to <code>NONE</code>,
     *         this action doesn't disable the corresponding option for your existing accounts. This configuration will
     *         apply to the new accounts that join the organization. After you update the auto-enable settings, no new
     *         account will have the corresponding option as enabled.
     *         </p>
     *         </li>
     * @see AutoEnableMembers
     */
    public final AutoEnableMembers autoEnableOrganizationMembers() {
        return AutoEnableMembers.fromValue(autoEnableOrganizationMembers);
    }

    /**
     * <p>
     * Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization. You must
     * provide a value for either <code>autoEnableOrganizationMembers</code> or <code>autoEnable</code>.
     * </p>
     * <p>
     * Use one of the following configuration values for <code>autoEnableOrganizationMembers</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NEW</code>: Indicates that when a new account joins the organization, they will have GuardDuty enabled
     * automatically.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code>: Indicates that all accounts in the organization have GuardDuty enabled automatically. This
     * includes <code>NEW</code> accounts that join the organization and accounts that may have been suspended or
     * removed from the organization in GuardDuty.
     * </p>
     * <p>
     * It may take up to 24 hours to update the configuration for all the member accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>: Indicates that GuardDuty will not be automatically enabled for any account in the
     * organization. The administrator must manage GuardDuty for each account in the organization individually.
     * </p>
     * <p>
     * When you update the auto-enable setting from <code>ALL</code> or <code>NEW</code> to <code>NONE</code>, this
     * action doesn't disable the corresponding option for your existing accounts. This configuration will apply to the
     * new accounts that join the organization. After you update the auto-enable settings, no new account will have the
     * corresponding option as enabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoEnableOrganizationMembers} will return {@link AutoEnableMembers#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #autoEnableOrganizationMembersAsString}.
     * </p>
     * 
     * @return Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization. You
     *         must provide a value for either <code>autoEnableOrganizationMembers</code> or <code>autoEnable</code>.
     *         </p>
     *         <p>
     *         Use one of the following configuration values for <code>autoEnableOrganizationMembers</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NEW</code>: Indicates that when a new account joins the organization, they will have GuardDuty
     *         enabled automatically.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code>: Indicates that all accounts in the organization have GuardDuty enabled automatically.
     *         This includes <code>NEW</code> accounts that join the organization and accounts that may have been
     *         suspended or removed from the organization in GuardDuty.
     *         </p>
     *         <p>
     *         It may take up to 24 hours to update the configuration for all the member accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>: Indicates that GuardDuty will not be automatically enabled for any account in the
     *         organization. The administrator must manage GuardDuty for each account in the organization individually.
     *         </p>
     *         <p>
     *         When you update the auto-enable setting from <code>ALL</code> or <code>NEW</code> to <code>NONE</code>,
     *         this action doesn't disable the corresponding option for your existing accounts. This configuration will
     *         apply to the new accounts that join the organization. After you update the auto-enable settings, no new
     *         account will have the corresponding option as enabled.
     *         </p>
     *         </li>
     * @see AutoEnableMembers
     */
    public final String autoEnableOrganizationMembersAsString() {
        return autoEnableOrganizationMembers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(autoEnable());
        hashCode = 31 * hashCode + Objects.hashCode(dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatures() ? features() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoEnableOrganizationMembersAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOrganizationConfigurationRequest)) {
            return false;
        }
        UpdateOrganizationConfigurationRequest other = (UpdateOrganizationConfigurationRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(autoEnable(), other.autoEnable())
                && Objects.equals(dataSources(), other.dataSources()) && hasFeatures() == other.hasFeatures()
                && Objects.equals(features(), other.features())
                && Objects.equals(autoEnableOrganizationMembersAsString(), other.autoEnableOrganizationMembersAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateOrganizationConfigurationRequest").add("DetectorId", detectorId())
                .add("AutoEnable", autoEnable()).add("DataSources", dataSources())
                .add("Features", hasFeatures() ? features() : null)
                .add("AutoEnableOrganizationMembers", autoEnableOrganizationMembersAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "AutoEnable":
            return Optional.ofNullable(clazz.cast(autoEnable()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "Features":
            return Optional.ofNullable(clazz.cast(features()));
        case "AutoEnableOrganizationMembers":
            return Optional.ofNullable(clazz.cast(autoEnableOrganizationMembersAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("autoEnable", AUTO_ENABLE_FIELD);
        map.put("dataSources", DATA_SOURCES_FIELD);
        map.put("features", FEATURES_FIELD);
        map.put("autoEnableOrganizationMembers", AUTO_ENABLE_ORGANIZATION_MEMBERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateOrganizationConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateOrganizationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateOrganizationConfigurationRequest> {
        /**
         * <p>
         * The ID of the detector that configures the delegated administrator.
         * </p>
         * <p>
         * To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty console, or
         * run the <a
         * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
         * API.
         * </p>
         * 
         * @param detectorId
         *        The ID of the detector that configures the delegated administrator.</p>
         *        <p>
         *        To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty
         *        console, or run the <a
         *        href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html"
         *        >ListDetectors</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * Represents whether to automatically enable member accounts in the organization. This applies to only new
         * member accounts, not the existing member accounts. When a new account joins the organization, the chosen
         * features will be enabled for them by default.
         * </p>
         * <p>
         * Even though this is still supported, we recommend using <code>AutoEnableOrganizationMembers</code> to achieve
         * the similar results. You must provide a value for either <code>autoEnableOrganizationMembers</code> or
         * <code>autoEnable</code>.
         * </p>
         * 
         * @param autoEnable
         *        Represents whether to automatically enable member accounts in the organization. This applies to only
         *        new member accounts, not the existing member accounts. When a new account joins the organization, the
         *        chosen features will be enabled for them by default.</p>
         *        <p>
         *        Even though this is still supported, we recommend using <code>AutoEnableOrganizationMembers</code> to
         *        achieve the similar results. You must provide a value for either
         *        <code>autoEnableOrganizationMembers</code> or <code>autoEnable</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This field is deprecated, use AutoEnableOrganizationMembers instead
         */
        @Deprecated
        Builder autoEnable(Boolean autoEnable);

        /**
         * <p>
         * Describes which data sources will be updated.
         * </p>
         * 
         * @param dataSources
         *        Describes which data sources will be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This parameter is deprecated, use Features instead
         */
        @Deprecated
        Builder dataSources(OrganizationDataSourceConfigurations dataSources);

        /**
         * <p>
         * Describes which data sources will be updated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OrganizationDataSourceConfigurations.Builder} avoiding the need to create one manually via
         * {@link OrganizationDataSourceConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrganizationDataSourceConfigurations.Builder#build()} is called
         * immediately and its result is passed to {@link #dataSources(OrganizationDataSourceConfigurations)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link OrganizationDataSourceConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(OrganizationDataSourceConfigurations)
         * @deprecated This parameter is deprecated, use Features instead
         */
        @Deprecated
        default Builder dataSources(Consumer<OrganizationDataSourceConfigurations.Builder> dataSources) {
            return dataSources(OrganizationDataSourceConfigurations.builder().applyMutation(dataSources).build());
        }

        /**
         * <p>
         * A list of features that will be configured for the organization.
         * </p>
         * 
         * @param features
         *        A list of features that will be configured for the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(Collection<OrganizationFeatureConfiguration> features);

        /**
         * <p>
         * A list of features that will be configured for the organization.
         * </p>
         * 
         * @param features
         *        A list of features that will be configured for the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(OrganizationFeatureConfiguration... features);

        /**
         * <p>
         * A list of features that will be configured for the organization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link #features(List<OrganizationFeatureConfiguration>)}.
         * 
         * @param features
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #features(java.util.Collection<OrganizationFeatureConfiguration>)
         */
        Builder features(Consumer<OrganizationFeatureConfiguration.Builder>... features);

        /**
         * <p>
         * Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization. You
         * must provide a value for either <code>autoEnableOrganizationMembers</code> or <code>autoEnable</code>.
         * </p>
         * <p>
         * Use one of the following configuration values for <code>autoEnableOrganizationMembers</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NEW</code>: Indicates that when a new account joins the organization, they will have GuardDuty enabled
         * automatically.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code>: Indicates that all accounts in the organization have GuardDuty enabled automatically. This
         * includes <code>NEW</code> accounts that join the organization and accounts that may have been suspended or
         * removed from the organization in GuardDuty.
         * </p>
         * <p>
         * It may take up to 24 hours to update the configuration for all the member accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>: Indicates that GuardDuty will not be automatically enabled for any account in the
         * organization. The administrator must manage GuardDuty for each account in the organization individually.
         * </p>
         * <p>
         * When you update the auto-enable setting from <code>ALL</code> or <code>NEW</code> to <code>NONE</code>, this
         * action doesn't disable the corresponding option for your existing accounts. This configuration will apply to
         * the new accounts that join the organization. After you update the auto-enable settings, no new account will
         * have the corresponding option as enabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param autoEnableOrganizationMembers
         *        Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization.
         *        You must provide a value for either <code>autoEnableOrganizationMembers</code> or
         *        <code>autoEnable</code>. </p>
         *        <p>
         *        Use one of the following configuration values for <code>autoEnableOrganizationMembers</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NEW</code>: Indicates that when a new account joins the organization, they will have GuardDuty
         *        enabled automatically.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code>: Indicates that all accounts in the organization have GuardDuty enabled
         *        automatically. This includes <code>NEW</code> accounts that join the organization and accounts that
         *        may have been suspended or removed from the organization in GuardDuty.
         *        </p>
         *        <p>
         *        It may take up to 24 hours to update the configuration for all the member accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>: Indicates that GuardDuty will not be automatically enabled for any account in the
         *        organization. The administrator must manage GuardDuty for each account in the organization
         *        individually.
         *        </p>
         *        <p>
         *        When you update the auto-enable setting from <code>ALL</code> or <code>NEW</code> to <code>NONE</code>
         *        , this action doesn't disable the corresponding option for your existing accounts. This configuration
         *        will apply to the new accounts that join the organization. After you update the auto-enable settings,
         *        no new account will have the corresponding option as enabled.
         *        </p>
         *        </li>
         * @see AutoEnableMembers
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoEnableMembers
         */
        Builder autoEnableOrganizationMembers(String autoEnableOrganizationMembers);

        /**
         * <p>
         * Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization. You
         * must provide a value for either <code>autoEnableOrganizationMembers</code> or <code>autoEnable</code>.
         * </p>
         * <p>
         * Use one of the following configuration values for <code>autoEnableOrganizationMembers</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NEW</code>: Indicates that when a new account joins the organization, they will have GuardDuty enabled
         * automatically.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code>: Indicates that all accounts in the organization have GuardDuty enabled automatically. This
         * includes <code>NEW</code> accounts that join the organization and accounts that may have been suspended or
         * removed from the organization in GuardDuty.
         * </p>
         * <p>
         * It may take up to 24 hours to update the configuration for all the member accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>: Indicates that GuardDuty will not be automatically enabled for any account in the
         * organization. The administrator must manage GuardDuty for each account in the organization individually.
         * </p>
         * <p>
         * When you update the auto-enable setting from <code>ALL</code> or <code>NEW</code> to <code>NONE</code>, this
         * action doesn't disable the corresponding option for your existing accounts. This configuration will apply to
         * the new accounts that join the organization. After you update the auto-enable settings, no new account will
         * have the corresponding option as enabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param autoEnableOrganizationMembers
         *        Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization.
         *        You must provide a value for either <code>autoEnableOrganizationMembers</code> or
         *        <code>autoEnable</code>. </p>
         *        <p>
         *        Use one of the following configuration values for <code>autoEnableOrganizationMembers</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NEW</code>: Indicates that when a new account joins the organization, they will have GuardDuty
         *        enabled automatically.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code>: Indicates that all accounts in the organization have GuardDuty enabled
         *        automatically. This includes <code>NEW</code> accounts that join the organization and accounts that
         *        may have been suspended or removed from the organization in GuardDuty.
         *        </p>
         *        <p>
         *        It may take up to 24 hours to update the configuration for all the member accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>: Indicates that GuardDuty will not be automatically enabled for any account in the
         *        organization. The administrator must manage GuardDuty for each account in the organization
         *        individually.
         *        </p>
         *        <p>
         *        When you update the auto-enable setting from <code>ALL</code> or <code>NEW</code> to <code>NONE</code>
         *        , this action doesn't disable the corresponding option for your existing accounts. This configuration
         *        will apply to the new accounts that join the organization. After you update the auto-enable settings,
         *        no new account will have the corresponding option as enabled.
         *        </p>
         *        </li>
         * @see AutoEnableMembers
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoEnableMembers
         */
        Builder autoEnableOrganizationMembers(AutoEnableMembers autoEnableOrganizationMembers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private Boolean autoEnable;

        private OrganizationDataSourceConfigurations dataSources;

        private List<OrganizationFeatureConfiguration> features = DefaultSdkAutoConstructList.getInstance();

        private String autoEnableOrganizationMembers;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOrganizationConfigurationRequest model) {
            super(model);
            detectorId(model.detectorId);
            autoEnable(model.autoEnable);
            dataSources(model.dataSources);
            features(model.features);
            autoEnableOrganizationMembers(model.autoEnableOrganizationMembers);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        @Deprecated
        public final Boolean getAutoEnable() {
            return autoEnable;
        }

        @Deprecated
        public final void setAutoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
        }

        @Override
        @Deprecated
        public final Builder autoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        @Deprecated
        public final OrganizationDataSourceConfigurations.Builder getDataSources() {
            return dataSources != null ? dataSources.toBuilder() : null;
        }

        @Deprecated
        public final void setDataSources(OrganizationDataSourceConfigurations.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        @Deprecated
        public final Builder dataSources(OrganizationDataSourceConfigurations dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final List<OrganizationFeatureConfiguration.Builder> getFeatures() {
            List<OrganizationFeatureConfiguration.Builder> result = OrganizationFeaturesConfigurationsCopier
                    .copyToBuilder(this.features);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatures(Collection<OrganizationFeatureConfiguration.BuilderImpl> features) {
            this.features = OrganizationFeaturesConfigurationsCopier.copyFromBuilder(features);
        }

        @Override
        public final Builder features(Collection<OrganizationFeatureConfiguration> features) {
            this.features = OrganizationFeaturesConfigurationsCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(OrganizationFeatureConfiguration... features) {
            features(Arrays.asList(features));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(Consumer<OrganizationFeatureConfiguration.Builder>... features) {
            features(Stream.of(features).map(c -> OrganizationFeatureConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAutoEnableOrganizationMembers() {
            return autoEnableOrganizationMembers;
        }

        public final void setAutoEnableOrganizationMembers(String autoEnableOrganizationMembers) {
            this.autoEnableOrganizationMembers = autoEnableOrganizationMembers;
        }

        @Override
        public final Builder autoEnableOrganizationMembers(String autoEnableOrganizationMembers) {
            this.autoEnableOrganizationMembers = autoEnableOrganizationMembers;
            return this;
        }

        @Override
        public final Builder autoEnableOrganizationMembers(AutoEnableMembers autoEnableOrganizationMembers) {
            this.autoEnableOrganizationMembers(autoEnableOrganizationMembers == null ? null : autoEnableOrganizationMembers
                    .toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOrganizationConfigurationRequest build() {
            return new UpdateOrganizationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
