/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Volume used by the Kubernetes workload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Volume implements SdkPojo, Serializable, ToCopyableBuilder<Volume.Builder, Volume> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Volume::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<HostPath> HOST_PATH_FIELD = SdkField.<HostPath> builder(MarshallingType.SDK_POJO)
            .memberName("HostPath").getter(getter(Volume::hostPath)).setter(setter(Builder::hostPath))
            .constructor(HostPath::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, HOST_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final HostPath hostPath;

    private Volume(BuilderImpl builder) {
        this.name = builder.name;
        this.hostPath = builder.hostPath;
    }

    /**
     * <p>
     * Volume name.
     * </p>
     * 
     * @return Volume name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Represents a pre-existing file or directory on the host machine that the volume maps to.
     * </p>
     * 
     * @return Represents a pre-existing file or directory on the host machine that the volume maps to.
     */
    public final HostPath hostPath() {
        return hostPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hostPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(hostPath(), other.hostPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Volume").add("Name", name()).add("HostPath", hostPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "HostPath":
            return Optional.ofNullable(clazz.cast(hostPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("hostPath", HOST_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Volume, T> g) {
        return obj -> g.apply((Volume) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Volume> {
        /**
         * <p>
         * Volume name.
         * </p>
         * 
         * @param name
         *        Volume name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Represents a pre-existing file or directory on the host machine that the volume maps to.
         * </p>
         * 
         * @param hostPath
         *        Represents a pre-existing file or directory on the host machine that the volume maps to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostPath(HostPath hostPath);

        /**
         * <p>
         * Represents a pre-existing file or directory on the host machine that the volume maps to.
         * </p>
         * This is a convenience method that creates an instance of the {@link HostPath.Builder} avoiding the need to
         * create one manually via {@link HostPath#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HostPath.Builder#build()} is called immediately and its result is
         * passed to {@link #hostPath(HostPath)}.
         * 
         * @param hostPath
         *        a consumer that will call methods on {@link HostPath.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostPath(HostPath)
         */
        default Builder hostPath(Consumer<HostPath.Builder> hostPath) {
            return hostPath(HostPath.builder().applyMutation(hostPath).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private HostPath hostPath;

        private BuilderImpl() {
        }

        private BuilderImpl(Volume model) {
            name(model.name);
            hostPath(model.hostPath);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final HostPath.Builder getHostPath() {
            return hostPath != null ? hostPath.toBuilder() : null;
        }

        public final void setHostPath(HostPath.BuilderImpl hostPath) {
            this.hostPath = hostPath != null ? hostPath.build() : null;
        }

        @Override
        public final Builder hostPath(HostPath hostPath) {
            this.hostPath = hostPath;
            return this;
        }

        @Override
        public Volume build() {
            return new Volume(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
