/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PublishingStatus {
    PENDING_VERIFICATION("PENDING_VERIFICATION"),
    PUBLISHING("PUBLISHING"),
    UNABLE_TO_PUBLISH_FIX_DESTINATION_PROPERTY("UNABLE_TO_PUBLISH_FIX_DESTINATION_PROPERTY"),
    STOPPED("STOPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PublishingStatus> VALUE_MAP;
    private final String value;

    private PublishingStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PublishingStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PublishingStatus> knownValues() {
        EnumSet<PublishingStatus> knownValues = EnumSet.allOf(PublishingStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PublishingStatus.class, PublishingStatus::toString);
    }
}

