/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionPlanActions;
import software.amazon.awssdk.services.guardduty.model.UpdateProtectedResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMalwareProtectionPlanRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, UpdateMalwareProtectionPlanRequest> {
    private static final SdkField<String> MALWARE_PROTECTION_PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MalwareProtectionPlanId").getter(UpdateMalwareProtectionPlanRequest.getter(UpdateMalwareProtectionPlanRequest::malwareProtectionPlanId)).setter(UpdateMalwareProtectionPlanRequest.setter(Builder::malwareProtectionPlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("malwareProtectionPlanId").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(UpdateMalwareProtectionPlanRequest.getter(UpdateMalwareProtectionPlanRequest::role)).setter(UpdateMalwareProtectionPlanRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final SdkField<MalwareProtectionPlanActions> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Actions").getter(UpdateMalwareProtectionPlanRequest.getter(UpdateMalwareProtectionPlanRequest::actions)).setter(UpdateMalwareProtectionPlanRequest.setter(Builder::actions)).constructor(MalwareProtectionPlanActions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build()}).build();
    private static final SdkField<UpdateProtectedResource> PROTECTED_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProtectedResource").getter(UpdateMalwareProtectionPlanRequest.getter(UpdateMalwareProtectionPlanRequest::protectedResource)).setter(UpdateMalwareProtectionPlanRequest.setter(Builder::protectedResource)).constructor(UpdateProtectedResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protectedResource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MALWARE_PROTECTION_PLAN_ID_FIELD, ROLE_FIELD, ACTIONS_FIELD, PROTECTED_RESOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMalwareProtectionPlanRequest.memberNameToFieldInitializer();
    private final String malwareProtectionPlanId;
    private final String role;
    private final MalwareProtectionPlanActions actions;
    private final UpdateProtectedResource protectedResource;

    private UpdateMalwareProtectionPlanRequest(BuilderImpl builder) {
        super(builder);
        this.malwareProtectionPlanId = builder.malwareProtectionPlanId;
        this.role = builder.role;
        this.actions = builder.actions;
        this.protectedResource = builder.protectedResource;
    }

    public final String malwareProtectionPlanId() {
        return this.malwareProtectionPlanId;
    }

    public final String role() {
        return this.role;
    }

    public final MalwareProtectionPlanActions actions() {
        return this.actions;
    }

    public final UpdateProtectedResource protectedResource() {
        return this.protectedResource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.malwareProtectionPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectedResource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMalwareProtectionPlanRequest)) {
            return false;
        }
        UpdateMalwareProtectionPlanRequest other = (UpdateMalwareProtectionPlanRequest)((Object)obj);
        return Objects.equals(this.malwareProtectionPlanId(), other.malwareProtectionPlanId()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.protectedResource(), other.protectedResource());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMalwareProtectionPlanRequest").add("MalwareProtectionPlanId", (Object)this.malwareProtectionPlanId()).add("Role", (Object)this.role()).add("Actions", (Object)this.actions()).add("ProtectedResource", (Object)this.protectedResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MalwareProtectionPlanId": {
                return Optional.ofNullable(clazz.cast(this.malwareProtectionPlanId()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "ProtectedResource": {
                return Optional.ofNullable(clazz.cast(this.protectedResource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("malwareProtectionPlanId", MALWARE_PROTECTION_PLAN_ID_FIELD);
        map.put("role", ROLE_FIELD);
        map.put("actions", ACTIONS_FIELD);
        map.put("protectedResource", PROTECTED_RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMalwareProtectionPlanRequest, T> g) {
        return obj -> g.apply((UpdateMalwareProtectionPlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String malwareProtectionPlanId;
        private String role;
        private MalwareProtectionPlanActions actions;
        private UpdateProtectedResource protectedResource;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMalwareProtectionPlanRequest model) {
            super(model);
            this.malwareProtectionPlanId(model.malwareProtectionPlanId);
            this.role(model.role);
            this.actions(model.actions);
            this.protectedResource(model.protectedResource);
        }

        public final String getMalwareProtectionPlanId() {
            return this.malwareProtectionPlanId;
        }

        public final void setMalwareProtectionPlanId(String malwareProtectionPlanId) {
            this.malwareProtectionPlanId = malwareProtectionPlanId;
        }

        @Override
        public final Builder malwareProtectionPlanId(String malwareProtectionPlanId) {
            this.malwareProtectionPlanId = malwareProtectionPlanId;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final MalwareProtectionPlanActions.Builder getActions() {
            return this.actions != null ? this.actions.toBuilder() : null;
        }

        public final void setActions(MalwareProtectionPlanActions.BuilderImpl actions) {
            this.actions = actions != null ? actions.build() : null;
        }

        @Override
        public final Builder actions(MalwareProtectionPlanActions actions) {
            this.actions = actions;
            return this;
        }

        public final UpdateProtectedResource.Builder getProtectedResource() {
            return this.protectedResource != null ? this.protectedResource.toBuilder() : null;
        }

        public final void setProtectedResource(UpdateProtectedResource.BuilderImpl protectedResource) {
            this.protectedResource = protectedResource != null ? protectedResource.build() : null;
        }

        @Override
        public final Builder protectedResource(UpdateProtectedResource protectedResource) {
            this.protectedResource = protectedResource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMalwareProtectionPlanRequest build() {
            return new UpdateMalwareProtectionPlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMalwareProtectionPlanRequest> {
        public Builder malwareProtectionPlanId(String var1);

        public Builder role(String var1);

        public Builder actions(MalwareProtectionPlanActions var1);

        default public Builder actions(Consumer<MalwareProtectionPlanActions.Builder> actions) {
            return this.actions((MalwareProtectionPlanActions)((MalwareProtectionPlanActions.Builder)MalwareProtectionPlanActions.builder().applyMutation(actions)).build());
        }

        public Builder protectedResource(UpdateProtectedResource var1);

        default public Builder protectedResource(Consumer<UpdateProtectedResource.Builder> protectedResource) {
            return this.protectedResource((UpdateProtectedResource)((UpdateProtectedResource.Builder)UpdateProtectedResource.builder().applyMutation(protectedResource)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

