/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteThreatEntitySetRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, DeleteThreatEntitySetRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(DeleteThreatEntitySetRequest.getter(DeleteThreatEntitySetRequest::detectorId)).setter(DeleteThreatEntitySetRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<String> THREAT_ENTITY_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThreatEntitySetId").getter(DeleteThreatEntitySetRequest.getter(DeleteThreatEntitySetRequest::threatEntitySetId)).setter(DeleteThreatEntitySetRequest.setter(Builder::threatEntitySetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("threatEntitySetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, THREAT_ENTITY_SET_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteThreatEntitySetRequest.memberNameToFieldInitializer();
    private final String detectorId;
    private final String threatEntitySetId;

    private DeleteThreatEntitySetRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.threatEntitySetId = builder.threatEntitySetId;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final String threatEntitySetId() {
        return this.threatEntitySetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.threatEntitySetId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteThreatEntitySetRequest)) {
            return false;
        }
        DeleteThreatEntitySetRequest other = (DeleteThreatEntitySetRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.threatEntitySetId(), other.threatEntitySetId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteThreatEntitySetRequest").add("DetectorId", (Object)this.detectorId()).add("ThreatEntitySetId", (Object)this.threatEntitySetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "ThreatEntitySetId": {
                return Optional.ofNullable(clazz.cast(this.threatEntitySetId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("threatEntitySetId", THREAT_ENTITY_SET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteThreatEntitySetRequest, T> g) {
        return obj -> g.apply((DeleteThreatEntitySetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private String threatEntitySetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteThreatEntitySetRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.threatEntitySetId(model.threatEntitySetId);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getThreatEntitySetId() {
            return this.threatEntitySetId;
        }

        public final void setThreatEntitySetId(String threatEntitySetId) {
            this.threatEntitySetId = threatEntitySetId;
        }

        @Override
        public final Builder threatEntitySetId(String threatEntitySetId) {
            this.threatEntitySetId = threatEntitySetId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteThreatEntitySetRequest build() {
            return new DeleteThreatEntitySetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteThreatEntitySetRequest> {
        public Builder detectorId(String var1);

        public Builder threatEntitySetId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

