/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.LineageCopier;
import software.amazon.awssdk.services.guardduty.model.LineageObject;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProcessDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProcessDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ProcessDetails.getter(ProcessDetails::name)).setter(ProcessDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> EXECUTABLE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutablePath").getter(ProcessDetails.getter(ProcessDetails::executablePath)).setter(ProcessDetails.setter(Builder::executablePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executablePath").build()}).build();
    private static final SdkField<String> EXECUTABLE_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutableSha256").getter(ProcessDetails.getter(ProcessDetails::executableSha256)).setter(ProcessDetails.setter(Builder::executableSha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executableSha256").build()}).build();
    private static final SdkField<Integer> NAMESPACE_PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NamespacePid").getter(ProcessDetails.getter(ProcessDetails::namespacePid)).setter(ProcessDetails.setter(Builder::namespacePid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespacePid").build()}).build();
    private static final SdkField<String> PWD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Pwd").getter(ProcessDetails.getter(ProcessDetails::pwd)).setter(ProcessDetails.setter(Builder::pwd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pwd").build()}).build();
    private static final SdkField<Integer> PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Pid").getter(ProcessDetails.getter(ProcessDetails::pid)).setter(ProcessDetails.setter(Builder::pid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pid").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ProcessDetails.getter(ProcessDetails::startTime)).setter(ProcessDetails.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> UUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Uuid").getter(ProcessDetails.getter(ProcessDetails::uuid)).setter(ProcessDetails.setter(Builder::uuid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uuid").build()}).build();
    private static final SdkField<String> PARENT_UUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentUuid").getter(ProcessDetails.getter(ProcessDetails::parentUuid)).setter(ProcessDetails.setter(Builder::parentUuid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentUuid").build()}).build();
    private static final SdkField<String> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("User").getter(ProcessDetails.getter(ProcessDetails::user)).setter(ProcessDetails.setter(Builder::user)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()}).build();
    private static final SdkField<Integer> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UserId").getter(ProcessDetails.getter(ProcessDetails::userId)).setter(ProcessDetails.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<Integer> EUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Euid").getter(ProcessDetails.getter(ProcessDetails::euid)).setter(ProcessDetails.setter(Builder::euid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("euid").build()}).build();
    private static final SdkField<List<LineageObject>> LINEAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Lineage").getter(ProcessDetails.getter(ProcessDetails::lineage)).setter(ProcessDetails.setter(Builder::lineage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineage").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LineageObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EXECUTABLE_PATH_FIELD, EXECUTABLE_SHA256_FIELD, NAMESPACE_PID_FIELD, PWD_FIELD, PID_FIELD, START_TIME_FIELD, UUID_FIELD, PARENT_UUID_FIELD, USER_FIELD, USER_ID_FIELD, EUID_FIELD, LINEAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProcessDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String executablePath;
    private final String executableSha256;
    private final Integer namespacePid;
    private final String pwd;
    private final Integer pid;
    private final Instant startTime;
    private final String uuid;
    private final String parentUuid;
    private final String user;
    private final Integer userId;
    private final Integer euid;
    private final List<LineageObject> lineage;

    private ProcessDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.executablePath = builder.executablePath;
        this.executableSha256 = builder.executableSha256;
        this.namespacePid = builder.namespacePid;
        this.pwd = builder.pwd;
        this.pid = builder.pid;
        this.startTime = builder.startTime;
        this.uuid = builder.uuid;
        this.parentUuid = builder.parentUuid;
        this.user = builder.user;
        this.userId = builder.userId;
        this.euid = builder.euid;
        this.lineage = builder.lineage;
    }

    public final String name() {
        return this.name;
    }

    public final String executablePath() {
        return this.executablePath;
    }

    public final String executableSha256() {
        return this.executableSha256;
    }

    public final Integer namespacePid() {
        return this.namespacePid;
    }

    public final String pwd() {
        return this.pwd;
    }

    public final Integer pid() {
        return this.pid;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final String uuid() {
        return this.uuid;
    }

    public final String parentUuid() {
        return this.parentUuid;
    }

    public final String user() {
        return this.user;
    }

    public final Integer userId() {
        return this.userId;
    }

    public final Integer euid() {
        return this.euid;
    }

    public final boolean hasLineage() {
        return this.lineage != null && !(this.lineage instanceof SdkAutoConstructList);
    }

    public final List<LineageObject> lineage() {
        return this.lineage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.executablePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.executableSha256());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespacePid());
        hashCode = 31 * hashCode + Objects.hashCode(this.pwd());
        hashCode = 31 * hashCode + Objects.hashCode(this.pid());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.uuid());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentUuid());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.euid());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLineage() ? this.lineage() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessDetails)) {
            return false;
        }
        ProcessDetails other = (ProcessDetails)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.executablePath(), other.executablePath()) && Objects.equals(this.executableSha256(), other.executableSha256()) && Objects.equals(this.namespacePid(), other.namespacePid()) && Objects.equals(this.pwd(), other.pwd()) && Objects.equals(this.pid(), other.pid()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.uuid(), other.uuid()) && Objects.equals(this.parentUuid(), other.parentUuid()) && Objects.equals(this.user(), other.user()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.euid(), other.euid()) && this.hasLineage() == other.hasLineage() && Objects.equals(this.lineage(), other.lineage());
    }

    public final String toString() {
        return ToString.builder((String)"ProcessDetails").add("Name", (Object)this.name()).add("ExecutablePath", (Object)this.executablePath()).add("ExecutableSha256", (Object)this.executableSha256()).add("NamespacePid", (Object)this.namespacePid()).add("Pwd", (Object)this.pwd()).add("Pid", (Object)this.pid()).add("StartTime", (Object)this.startTime()).add("Uuid", (Object)this.uuid()).add("ParentUuid", (Object)this.parentUuid()).add("User", (Object)this.user()).add("UserId", (Object)this.userId()).add("Euid", (Object)this.euid()).add("Lineage", this.hasLineage() ? this.lineage() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ExecutablePath": {
                return Optional.ofNullable(clazz.cast(this.executablePath()));
            }
            case "ExecutableSha256": {
                return Optional.ofNullable(clazz.cast(this.executableSha256()));
            }
            case "NamespacePid": {
                return Optional.ofNullable(clazz.cast(this.namespacePid()));
            }
            case "Pwd": {
                return Optional.ofNullable(clazz.cast(this.pwd()));
            }
            case "Pid": {
                return Optional.ofNullable(clazz.cast(this.pid()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "Uuid": {
                return Optional.ofNullable(clazz.cast(this.uuid()));
            }
            case "ParentUuid": {
                return Optional.ofNullable(clazz.cast(this.parentUuid()));
            }
            case "User": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "Euid": {
                return Optional.ofNullable(clazz.cast(this.euid()));
            }
            case "Lineage": {
                return Optional.ofNullable(clazz.cast(this.lineage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("executablePath", EXECUTABLE_PATH_FIELD);
        map.put("executableSha256", EXECUTABLE_SHA256_FIELD);
        map.put("namespacePid", NAMESPACE_PID_FIELD);
        map.put("pwd", PWD_FIELD);
        map.put("pid", PID_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("uuid", UUID_FIELD);
        map.put("parentUuid", PARENT_UUID_FIELD);
        map.put("user", USER_FIELD);
        map.put("userId", USER_ID_FIELD);
        map.put("euid", EUID_FIELD);
        map.put("lineage", LINEAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProcessDetails, T> g) {
        return obj -> g.apply((ProcessDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String executablePath;
        private String executableSha256;
        private Integer namespacePid;
        private String pwd;
        private Integer pid;
        private Instant startTime;
        private String uuid;
        private String parentUuid;
        private String user;
        private Integer userId;
        private Integer euid;
        private List<LineageObject> lineage = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessDetails model) {
            this.name(model.name);
            this.executablePath(model.executablePath);
            this.executableSha256(model.executableSha256);
            this.namespacePid(model.namespacePid);
            this.pwd(model.pwd);
            this.pid(model.pid);
            this.startTime(model.startTime);
            this.uuid(model.uuid);
            this.parentUuid(model.parentUuid);
            this.user(model.user);
            this.userId(model.userId);
            this.euid(model.euid);
            this.lineage(model.lineage);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getExecutablePath() {
            return this.executablePath;
        }

        public final void setExecutablePath(String executablePath) {
            this.executablePath = executablePath;
        }

        @Override
        public final Builder executablePath(String executablePath) {
            this.executablePath = executablePath;
            return this;
        }

        public final String getExecutableSha256() {
            return this.executableSha256;
        }

        public final void setExecutableSha256(String executableSha256) {
            this.executableSha256 = executableSha256;
        }

        @Override
        public final Builder executableSha256(String executableSha256) {
            this.executableSha256 = executableSha256;
            return this;
        }

        public final Integer getNamespacePid() {
            return this.namespacePid;
        }

        public final void setNamespacePid(Integer namespacePid) {
            this.namespacePid = namespacePid;
        }

        @Override
        public final Builder namespacePid(Integer namespacePid) {
            this.namespacePid = namespacePid;
            return this;
        }

        public final String getPwd() {
            return this.pwd;
        }

        public final void setPwd(String pwd) {
            this.pwd = pwd;
        }

        @Override
        public final Builder pwd(String pwd) {
            this.pwd = pwd;
            return this;
        }

        public final Integer getPid() {
            return this.pid;
        }

        public final void setPid(Integer pid) {
            this.pid = pid;
        }

        @Override
        public final Builder pid(Integer pid) {
            this.pid = pid;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getUuid() {
            return this.uuid;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final String getParentUuid() {
            return this.parentUuid;
        }

        public final void setParentUuid(String parentUuid) {
            this.parentUuid = parentUuid;
        }

        @Override
        public final Builder parentUuid(String parentUuid) {
            this.parentUuid = parentUuid;
            return this;
        }

        public final String getUser() {
            return this.user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final Integer getUserId() {
            return this.userId;
        }

        public final void setUserId(Integer userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(Integer userId) {
            this.userId = userId;
            return this;
        }

        public final Integer getEuid() {
            return this.euid;
        }

        public final void setEuid(Integer euid) {
            this.euid = euid;
        }

        @Override
        public final Builder euid(Integer euid) {
            this.euid = euid;
            return this;
        }

        public final List<LineageObject.Builder> getLineage() {
            List<LineageObject.Builder> result = LineageCopier.copyToBuilder(this.lineage);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLineage(Collection<LineageObject.BuilderImpl> lineage) {
            this.lineage = LineageCopier.copyFromBuilder(lineage);
        }

        @Override
        public final Builder lineage(Collection<LineageObject> lineage) {
            this.lineage = LineageCopier.copy(lineage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineage(LineageObject ... lineage) {
            this.lineage(Arrays.asList(lineage));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineage(Consumer<LineageObject.Builder> ... lineage) {
            this.lineage(Stream.of(lineage).map(c -> (LineageObject)((LineageObject.Builder)LineageObject.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ProcessDetails build() {
            return new ProcessDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProcessDetails> {
        public Builder name(String var1);

        public Builder executablePath(String var1);

        public Builder executableSha256(String var1);

        public Builder namespacePid(Integer var1);

        public Builder pwd(String var1);

        public Builder pid(Integer var1);

        public Builder startTime(Instant var1);

        public Builder uuid(String var1);

        public Builder parentUuid(String var1);

        public Builder user(String var1);

        public Builder userId(Integer var1);

        public Builder euid(Integer var1);

        public Builder lineage(Collection<LineageObject> var1);

        public Builder lineage(LineageObject ... var1);

        public Builder lineage(Consumer<LineageObject.Builder> ... var1);
    }
}

