/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.AccessKeyDetails;
import software.amazon.awssdk.services.guardduty.model.Container;
import software.amazon.awssdk.services.guardduty.model.EbsVolumeDetails;
import software.amazon.awssdk.services.guardduty.model.EcsClusterDetails;
import software.amazon.awssdk.services.guardduty.model.EksClusterDetails;
import software.amazon.awssdk.services.guardduty.model.InstanceDetails;
import software.amazon.awssdk.services.guardduty.model.KubernetesDetails;
import software.amazon.awssdk.services.guardduty.model.LambdaDetails;
import software.amazon.awssdk.services.guardduty.model.RdsDbInstanceDetails;
import software.amazon.awssdk.services.guardduty.model.RdsDbUserDetails;
import software.amazon.awssdk.services.guardduty.model.RdsLimitlessDbDetails;
import software.amazon.awssdk.services.guardduty.model.S3BucketDetail;
import software.amazon.awssdk.services.guardduty.model.S3BucketDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Resource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Resource> {
    private static final SdkField<AccessKeyDetails> ACCESS_KEY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessKeyDetails").getter(Resource.getter(Resource::accessKeyDetails)).setter(Resource.setter(Builder::accessKeyDetails)).constructor(AccessKeyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKeyDetails").build()}).build();
    private static final SdkField<List<S3BucketDetail>> S3_BUCKET_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("S3BucketDetails").getter(Resource.getter(Resource::s3BucketDetails)).setter(Resource.setter(Builder::s3BucketDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3BucketDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InstanceDetails> INSTANCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceDetails").getter(Resource.getter(Resource::instanceDetails)).setter(Resource.setter(Builder::instanceDetails)).constructor(InstanceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceDetails").build()}).build();
    private static final SdkField<EksClusterDetails> EKS_CLUSTER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EksClusterDetails").getter(Resource.getter(Resource::eksClusterDetails)).setter(Resource.setter(Builder::eksClusterDetails)).constructor(EksClusterDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksClusterDetails").build()}).build();
    private static final SdkField<KubernetesDetails> KUBERNETES_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KubernetesDetails").getter(Resource.getter(Resource::kubernetesDetails)).setter(Resource.setter(Builder::kubernetesDetails)).constructor(KubernetesDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesDetails").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(Resource.getter(Resource::resourceType)).setter(Resource.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<EbsVolumeDetails> EBS_VOLUME_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EbsVolumeDetails").getter(Resource.getter(Resource::ebsVolumeDetails)).setter(Resource.setter(Builder::ebsVolumeDetails)).constructor(EbsVolumeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsVolumeDetails").build()}).build();
    private static final SdkField<EcsClusterDetails> ECS_CLUSTER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EcsClusterDetails").getter(Resource.getter(Resource::ecsClusterDetails)).setter(Resource.setter(Builder::ecsClusterDetails)).constructor(EcsClusterDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsClusterDetails").build()}).build();
    private static final SdkField<Container> CONTAINER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContainerDetails").getter(Resource.getter(Resource::containerDetails)).setter(Resource.setter(Builder::containerDetails)).constructor(Container::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerDetails").build()}).build();
    private static final SdkField<RdsDbInstanceDetails> RDS_DB_INSTANCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RdsDbInstanceDetails").getter(Resource.getter(Resource::rdsDbInstanceDetails)).setter(Resource.setter(Builder::rdsDbInstanceDetails)).constructor(RdsDbInstanceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsDbInstanceDetails").build()}).build();
    private static final SdkField<RdsLimitlessDbDetails> RDS_LIMITLESS_DB_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RdsLimitlessDbDetails").getter(Resource.getter(Resource::rdsLimitlessDbDetails)).setter(Resource.setter(Builder::rdsLimitlessDbDetails)).constructor(RdsLimitlessDbDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsLimitlessDbDetails").build()}).build();
    private static final SdkField<RdsDbUserDetails> RDS_DB_USER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RdsDbUserDetails").getter(Resource.getter(Resource::rdsDbUserDetails)).setter(Resource.setter(Builder::rdsDbUserDetails)).constructor(RdsDbUserDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsDbUserDetails").build()}).build();
    private static final SdkField<LambdaDetails> LAMBDA_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LambdaDetails").getter(Resource.getter(Resource::lambdaDetails)).setter(Resource.setter(Builder::lambdaDetails)).constructor(LambdaDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_DETAILS_FIELD, S3_BUCKET_DETAILS_FIELD, INSTANCE_DETAILS_FIELD, EKS_CLUSTER_DETAILS_FIELD, KUBERNETES_DETAILS_FIELD, RESOURCE_TYPE_FIELD, EBS_VOLUME_DETAILS_FIELD, ECS_CLUSTER_DETAILS_FIELD, CONTAINER_DETAILS_FIELD, RDS_DB_INSTANCE_DETAILS_FIELD, RDS_LIMITLESS_DB_DETAILS_FIELD, RDS_DB_USER_DETAILS_FIELD, LAMBDA_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Resource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AccessKeyDetails accessKeyDetails;
    private final List<S3BucketDetail> s3BucketDetails;
    private final InstanceDetails instanceDetails;
    private final EksClusterDetails eksClusterDetails;
    private final KubernetesDetails kubernetesDetails;
    private final String resourceType;
    private final EbsVolumeDetails ebsVolumeDetails;
    private final EcsClusterDetails ecsClusterDetails;
    private final Container containerDetails;
    private final RdsDbInstanceDetails rdsDbInstanceDetails;
    private final RdsLimitlessDbDetails rdsLimitlessDbDetails;
    private final RdsDbUserDetails rdsDbUserDetails;
    private final LambdaDetails lambdaDetails;

    private Resource(BuilderImpl builder) {
        this.accessKeyDetails = builder.accessKeyDetails;
        this.s3BucketDetails = builder.s3BucketDetails;
        this.instanceDetails = builder.instanceDetails;
        this.eksClusterDetails = builder.eksClusterDetails;
        this.kubernetesDetails = builder.kubernetesDetails;
        this.resourceType = builder.resourceType;
        this.ebsVolumeDetails = builder.ebsVolumeDetails;
        this.ecsClusterDetails = builder.ecsClusterDetails;
        this.containerDetails = builder.containerDetails;
        this.rdsDbInstanceDetails = builder.rdsDbInstanceDetails;
        this.rdsLimitlessDbDetails = builder.rdsLimitlessDbDetails;
        this.rdsDbUserDetails = builder.rdsDbUserDetails;
        this.lambdaDetails = builder.lambdaDetails;
    }

    public final AccessKeyDetails accessKeyDetails() {
        return this.accessKeyDetails;
    }

    public final boolean hasS3BucketDetails() {
        return this.s3BucketDetails != null && !(this.s3BucketDetails instanceof SdkAutoConstructList);
    }

    public final List<S3BucketDetail> s3BucketDetails() {
        return this.s3BucketDetails;
    }

    public final InstanceDetails instanceDetails() {
        return this.instanceDetails;
    }

    public final EksClusterDetails eksClusterDetails() {
        return this.eksClusterDetails;
    }

    public final KubernetesDetails kubernetesDetails() {
        return this.kubernetesDetails;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final EbsVolumeDetails ebsVolumeDetails() {
        return this.ebsVolumeDetails;
    }

    public final EcsClusterDetails ecsClusterDetails() {
        return this.ecsClusterDetails;
    }

    public final Container containerDetails() {
        return this.containerDetails;
    }

    public final RdsDbInstanceDetails rdsDbInstanceDetails() {
        return this.rdsDbInstanceDetails;
    }

    public final RdsLimitlessDbDetails rdsLimitlessDbDetails() {
        return this.rdsLimitlessDbDetails;
    }

    public final RdsDbUserDetails rdsDbUserDetails() {
        return this.rdsDbUserDetails;
    }

    public final LambdaDetails lambdaDetails() {
        return this.lambdaDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3BucketDetails() ? this.s3BucketDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.eksClusterDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.kubernetesDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsVolumeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsClusterDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsDbInstanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsLimitlessDbDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsDbUserDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return Objects.equals(this.accessKeyDetails(), other.accessKeyDetails()) && this.hasS3BucketDetails() == other.hasS3BucketDetails() && Objects.equals(this.s3BucketDetails(), other.s3BucketDetails()) && Objects.equals(this.instanceDetails(), other.instanceDetails()) && Objects.equals(this.eksClusterDetails(), other.eksClusterDetails()) && Objects.equals(this.kubernetesDetails(), other.kubernetesDetails()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.ebsVolumeDetails(), other.ebsVolumeDetails()) && Objects.equals(this.ecsClusterDetails(), other.ecsClusterDetails()) && Objects.equals(this.containerDetails(), other.containerDetails()) && Objects.equals(this.rdsDbInstanceDetails(), other.rdsDbInstanceDetails()) && Objects.equals(this.rdsLimitlessDbDetails(), other.rdsLimitlessDbDetails()) && Objects.equals(this.rdsDbUserDetails(), other.rdsDbUserDetails()) && Objects.equals(this.lambdaDetails(), other.lambdaDetails());
    }

    public final String toString() {
        return ToString.builder((String)"Resource").add("AccessKeyDetails", (Object)this.accessKeyDetails()).add("S3BucketDetails", this.hasS3BucketDetails() ? this.s3BucketDetails() : null).add("InstanceDetails", (Object)this.instanceDetails()).add("EksClusterDetails", (Object)this.eksClusterDetails()).add("KubernetesDetails", (Object)this.kubernetesDetails()).add("ResourceType", (Object)this.resourceType()).add("EbsVolumeDetails", (Object)this.ebsVolumeDetails()).add("EcsClusterDetails", (Object)this.ecsClusterDetails()).add("ContainerDetails", (Object)this.containerDetails()).add("RdsDbInstanceDetails", (Object)this.rdsDbInstanceDetails()).add("RdsLimitlessDbDetails", (Object)this.rdsLimitlessDbDetails()).add("RdsDbUserDetails", (Object)this.rdsDbUserDetails()).add("LambdaDetails", (Object)this.lambdaDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessKeyDetails": {
                return Optional.ofNullable(clazz.cast(this.accessKeyDetails()));
            }
            case "S3BucketDetails": {
                return Optional.ofNullable(clazz.cast(this.s3BucketDetails()));
            }
            case "InstanceDetails": {
                return Optional.ofNullable(clazz.cast(this.instanceDetails()));
            }
            case "EksClusterDetails": {
                return Optional.ofNullable(clazz.cast(this.eksClusterDetails()));
            }
            case "KubernetesDetails": {
                return Optional.ofNullable(clazz.cast(this.kubernetesDetails()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "EbsVolumeDetails": {
                return Optional.ofNullable(clazz.cast(this.ebsVolumeDetails()));
            }
            case "EcsClusterDetails": {
                return Optional.ofNullable(clazz.cast(this.ecsClusterDetails()));
            }
            case "ContainerDetails": {
                return Optional.ofNullable(clazz.cast(this.containerDetails()));
            }
            case "RdsDbInstanceDetails": {
                return Optional.ofNullable(clazz.cast(this.rdsDbInstanceDetails()));
            }
            case "RdsLimitlessDbDetails": {
                return Optional.ofNullable(clazz.cast(this.rdsLimitlessDbDetails()));
            }
            case "RdsDbUserDetails": {
                return Optional.ofNullable(clazz.cast(this.rdsDbUserDetails()));
            }
            case "LambdaDetails": {
                return Optional.ofNullable(clazz.cast(this.lambdaDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accessKeyDetails", ACCESS_KEY_DETAILS_FIELD);
        map.put("s3BucketDetails", S3_BUCKET_DETAILS_FIELD);
        map.put("instanceDetails", INSTANCE_DETAILS_FIELD);
        map.put("eksClusterDetails", EKS_CLUSTER_DETAILS_FIELD);
        map.put("kubernetesDetails", KUBERNETES_DETAILS_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("ebsVolumeDetails", EBS_VOLUME_DETAILS_FIELD);
        map.put("ecsClusterDetails", ECS_CLUSTER_DETAILS_FIELD);
        map.put("containerDetails", CONTAINER_DETAILS_FIELD);
        map.put("rdsDbInstanceDetails", RDS_DB_INSTANCE_DETAILS_FIELD);
        map.put("rdsLimitlessDbDetails", RDS_LIMITLESS_DB_DETAILS_FIELD);
        map.put("rdsDbUserDetails", RDS_DB_USER_DETAILS_FIELD);
        map.put("lambdaDetails", LAMBDA_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AccessKeyDetails accessKeyDetails;
        private List<S3BucketDetail> s3BucketDetails = DefaultSdkAutoConstructList.getInstance();
        private InstanceDetails instanceDetails;
        private EksClusterDetails eksClusterDetails;
        private KubernetesDetails kubernetesDetails;
        private String resourceType;
        private EbsVolumeDetails ebsVolumeDetails;
        private EcsClusterDetails ecsClusterDetails;
        private Container containerDetails;
        private RdsDbInstanceDetails rdsDbInstanceDetails;
        private RdsLimitlessDbDetails rdsLimitlessDbDetails;
        private RdsDbUserDetails rdsDbUserDetails;
        private LambdaDetails lambdaDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            this.accessKeyDetails(model.accessKeyDetails);
            this.s3BucketDetails(model.s3BucketDetails);
            this.instanceDetails(model.instanceDetails);
            this.eksClusterDetails(model.eksClusterDetails);
            this.kubernetesDetails(model.kubernetesDetails);
            this.resourceType(model.resourceType);
            this.ebsVolumeDetails(model.ebsVolumeDetails);
            this.ecsClusterDetails(model.ecsClusterDetails);
            this.containerDetails(model.containerDetails);
            this.rdsDbInstanceDetails(model.rdsDbInstanceDetails);
            this.rdsLimitlessDbDetails(model.rdsLimitlessDbDetails);
            this.rdsDbUserDetails(model.rdsDbUserDetails);
            this.lambdaDetails(model.lambdaDetails);
        }

        public final AccessKeyDetails.Builder getAccessKeyDetails() {
            return this.accessKeyDetails != null ? this.accessKeyDetails.toBuilder() : null;
        }

        public final void setAccessKeyDetails(AccessKeyDetails.BuilderImpl accessKeyDetails) {
            this.accessKeyDetails = accessKeyDetails != null ? accessKeyDetails.build() : null;
        }

        @Override
        public final Builder accessKeyDetails(AccessKeyDetails accessKeyDetails) {
            this.accessKeyDetails = accessKeyDetails;
            return this;
        }

        public final List<S3BucketDetail.Builder> getS3BucketDetails() {
            List<S3BucketDetail.Builder> result = S3BucketDetailsCopier.copyToBuilder(this.s3BucketDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3BucketDetails(Collection<S3BucketDetail.BuilderImpl> s3BucketDetails) {
            this.s3BucketDetails = S3BucketDetailsCopier.copyFromBuilder(s3BucketDetails);
        }

        @Override
        public final Builder s3BucketDetails(Collection<S3BucketDetail> s3BucketDetails) {
            this.s3BucketDetails = S3BucketDetailsCopier.copy(s3BucketDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3BucketDetails(S3BucketDetail ... s3BucketDetails) {
            this.s3BucketDetails(Arrays.asList(s3BucketDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3BucketDetails(Consumer<S3BucketDetail.Builder> ... s3BucketDetails) {
            this.s3BucketDetails(Stream.of(s3BucketDetails).map(c -> (S3BucketDetail)((S3BucketDetail.Builder)S3BucketDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InstanceDetails.Builder getInstanceDetails() {
            return this.instanceDetails != null ? this.instanceDetails.toBuilder() : null;
        }

        public final void setInstanceDetails(InstanceDetails.BuilderImpl instanceDetails) {
            this.instanceDetails = instanceDetails != null ? instanceDetails.build() : null;
        }

        @Override
        public final Builder instanceDetails(InstanceDetails instanceDetails) {
            this.instanceDetails = instanceDetails;
            return this;
        }

        public final EksClusterDetails.Builder getEksClusterDetails() {
            return this.eksClusterDetails != null ? this.eksClusterDetails.toBuilder() : null;
        }

        public final void setEksClusterDetails(EksClusterDetails.BuilderImpl eksClusterDetails) {
            this.eksClusterDetails = eksClusterDetails != null ? eksClusterDetails.build() : null;
        }

        @Override
        public final Builder eksClusterDetails(EksClusterDetails eksClusterDetails) {
            this.eksClusterDetails = eksClusterDetails;
            return this;
        }

        public final KubernetesDetails.Builder getKubernetesDetails() {
            return this.kubernetesDetails != null ? this.kubernetesDetails.toBuilder() : null;
        }

        public final void setKubernetesDetails(KubernetesDetails.BuilderImpl kubernetesDetails) {
            this.kubernetesDetails = kubernetesDetails != null ? kubernetesDetails.build() : null;
        }

        @Override
        public final Builder kubernetesDetails(KubernetesDetails kubernetesDetails) {
            this.kubernetesDetails = kubernetesDetails;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final EbsVolumeDetails.Builder getEbsVolumeDetails() {
            return this.ebsVolumeDetails != null ? this.ebsVolumeDetails.toBuilder() : null;
        }

        public final void setEbsVolumeDetails(EbsVolumeDetails.BuilderImpl ebsVolumeDetails) {
            this.ebsVolumeDetails = ebsVolumeDetails != null ? ebsVolumeDetails.build() : null;
        }

        @Override
        public final Builder ebsVolumeDetails(EbsVolumeDetails ebsVolumeDetails) {
            this.ebsVolumeDetails = ebsVolumeDetails;
            return this;
        }

        public final EcsClusterDetails.Builder getEcsClusterDetails() {
            return this.ecsClusterDetails != null ? this.ecsClusterDetails.toBuilder() : null;
        }

        public final void setEcsClusterDetails(EcsClusterDetails.BuilderImpl ecsClusterDetails) {
            this.ecsClusterDetails = ecsClusterDetails != null ? ecsClusterDetails.build() : null;
        }

        @Override
        public final Builder ecsClusterDetails(EcsClusterDetails ecsClusterDetails) {
            this.ecsClusterDetails = ecsClusterDetails;
            return this;
        }

        public final Container.Builder getContainerDetails() {
            return this.containerDetails != null ? this.containerDetails.toBuilder() : null;
        }

        public final void setContainerDetails(Container.BuilderImpl containerDetails) {
            this.containerDetails = containerDetails != null ? containerDetails.build() : null;
        }

        @Override
        public final Builder containerDetails(Container containerDetails) {
            this.containerDetails = containerDetails;
            return this;
        }

        public final RdsDbInstanceDetails.Builder getRdsDbInstanceDetails() {
            return this.rdsDbInstanceDetails != null ? this.rdsDbInstanceDetails.toBuilder() : null;
        }

        public final void setRdsDbInstanceDetails(RdsDbInstanceDetails.BuilderImpl rdsDbInstanceDetails) {
            this.rdsDbInstanceDetails = rdsDbInstanceDetails != null ? rdsDbInstanceDetails.build() : null;
        }

        @Override
        public final Builder rdsDbInstanceDetails(RdsDbInstanceDetails rdsDbInstanceDetails) {
            this.rdsDbInstanceDetails = rdsDbInstanceDetails;
            return this;
        }

        public final RdsLimitlessDbDetails.Builder getRdsLimitlessDbDetails() {
            return this.rdsLimitlessDbDetails != null ? this.rdsLimitlessDbDetails.toBuilder() : null;
        }

        public final void setRdsLimitlessDbDetails(RdsLimitlessDbDetails.BuilderImpl rdsLimitlessDbDetails) {
            this.rdsLimitlessDbDetails = rdsLimitlessDbDetails != null ? rdsLimitlessDbDetails.build() : null;
        }

        @Override
        public final Builder rdsLimitlessDbDetails(RdsLimitlessDbDetails rdsLimitlessDbDetails) {
            this.rdsLimitlessDbDetails = rdsLimitlessDbDetails;
            return this;
        }

        public final RdsDbUserDetails.Builder getRdsDbUserDetails() {
            return this.rdsDbUserDetails != null ? this.rdsDbUserDetails.toBuilder() : null;
        }

        public final void setRdsDbUserDetails(RdsDbUserDetails.BuilderImpl rdsDbUserDetails) {
            this.rdsDbUserDetails = rdsDbUserDetails != null ? rdsDbUserDetails.build() : null;
        }

        @Override
        public final Builder rdsDbUserDetails(RdsDbUserDetails rdsDbUserDetails) {
            this.rdsDbUserDetails = rdsDbUserDetails;
            return this;
        }

        public final LambdaDetails.Builder getLambdaDetails() {
            return this.lambdaDetails != null ? this.lambdaDetails.toBuilder() : null;
        }

        public final void setLambdaDetails(LambdaDetails.BuilderImpl lambdaDetails) {
            this.lambdaDetails = lambdaDetails != null ? lambdaDetails.build() : null;
        }

        @Override
        public final Builder lambdaDetails(LambdaDetails lambdaDetails) {
            this.lambdaDetails = lambdaDetails;
            return this;
        }

        public Resource build() {
            return new Resource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Resource> {
        public Builder accessKeyDetails(AccessKeyDetails var1);

        default public Builder accessKeyDetails(Consumer<AccessKeyDetails.Builder> accessKeyDetails) {
            return this.accessKeyDetails((AccessKeyDetails)((AccessKeyDetails.Builder)AccessKeyDetails.builder().applyMutation(accessKeyDetails)).build());
        }

        public Builder s3BucketDetails(Collection<S3BucketDetail> var1);

        public Builder s3BucketDetails(S3BucketDetail ... var1);

        public Builder s3BucketDetails(Consumer<S3BucketDetail.Builder> ... var1);

        public Builder instanceDetails(InstanceDetails var1);

        default public Builder instanceDetails(Consumer<InstanceDetails.Builder> instanceDetails) {
            return this.instanceDetails((InstanceDetails)((InstanceDetails.Builder)InstanceDetails.builder().applyMutation(instanceDetails)).build());
        }

        public Builder eksClusterDetails(EksClusterDetails var1);

        default public Builder eksClusterDetails(Consumer<EksClusterDetails.Builder> eksClusterDetails) {
            return this.eksClusterDetails((EksClusterDetails)((EksClusterDetails.Builder)EksClusterDetails.builder().applyMutation(eksClusterDetails)).build());
        }

        public Builder kubernetesDetails(KubernetesDetails var1);

        default public Builder kubernetesDetails(Consumer<KubernetesDetails.Builder> kubernetesDetails) {
            return this.kubernetesDetails((KubernetesDetails)((KubernetesDetails.Builder)KubernetesDetails.builder().applyMutation(kubernetesDetails)).build());
        }

        public Builder resourceType(String var1);

        public Builder ebsVolumeDetails(EbsVolumeDetails var1);

        default public Builder ebsVolumeDetails(Consumer<EbsVolumeDetails.Builder> ebsVolumeDetails) {
            return this.ebsVolumeDetails((EbsVolumeDetails)((EbsVolumeDetails.Builder)EbsVolumeDetails.builder().applyMutation(ebsVolumeDetails)).build());
        }

        public Builder ecsClusterDetails(EcsClusterDetails var1);

        default public Builder ecsClusterDetails(Consumer<EcsClusterDetails.Builder> ecsClusterDetails) {
            return this.ecsClusterDetails((EcsClusterDetails)((EcsClusterDetails.Builder)EcsClusterDetails.builder().applyMutation(ecsClusterDetails)).build());
        }

        public Builder containerDetails(Container var1);

        default public Builder containerDetails(Consumer<Container.Builder> containerDetails) {
            return this.containerDetails((Container)((Container.Builder)Container.builder().applyMutation(containerDetails)).build());
        }

        public Builder rdsDbInstanceDetails(RdsDbInstanceDetails var1);

        default public Builder rdsDbInstanceDetails(Consumer<RdsDbInstanceDetails.Builder> rdsDbInstanceDetails) {
            return this.rdsDbInstanceDetails((RdsDbInstanceDetails)((RdsDbInstanceDetails.Builder)RdsDbInstanceDetails.builder().applyMutation(rdsDbInstanceDetails)).build());
        }

        public Builder rdsLimitlessDbDetails(RdsLimitlessDbDetails var1);

        default public Builder rdsLimitlessDbDetails(Consumer<RdsLimitlessDbDetails.Builder> rdsLimitlessDbDetails) {
            return this.rdsLimitlessDbDetails((RdsLimitlessDbDetails)((RdsLimitlessDbDetails.Builder)RdsLimitlessDbDetails.builder().applyMutation(rdsLimitlessDbDetails)).build());
        }

        public Builder rdsDbUserDetails(RdsDbUserDetails var1);

        default public Builder rdsDbUserDetails(Consumer<RdsDbUserDetails.Builder> rdsDbUserDetails) {
            return this.rdsDbUserDetails((RdsDbUserDetails)((RdsDbUserDetails.Builder)RdsDbUserDetails.builder().applyMutation(rdsDbUserDetails)).build());
        }

        public Builder lambdaDetails(LambdaDetails var1);

        default public Builder lambdaDetails(Consumer<LambdaDetails.Builder> lambdaDetails) {
            return this.lambdaDetails((LambdaDetails)((LambdaDetails.Builder)LambdaDetails.builder().applyMutation(lambdaDetails)).build());
        }
    }
}

