/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTrustedEntitySetRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, UpdateTrustedEntitySetRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(UpdateTrustedEntitySetRequest.getter(UpdateTrustedEntitySetRequest::detectorId)).setter(UpdateTrustedEntitySetRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<String> TRUSTED_ENTITY_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustedEntitySetId").getter(UpdateTrustedEntitySetRequest.getter(UpdateTrustedEntitySetRequest::trustedEntitySetId)).setter(UpdateTrustedEntitySetRequest.setter(Builder::trustedEntitySetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("trustedEntitySetId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateTrustedEntitySetRequest.getter(UpdateTrustedEntitySetRequest::name)).setter(UpdateTrustedEntitySetRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(UpdateTrustedEntitySetRequest.getter(UpdateTrustedEntitySetRequest::location)).setter(UpdateTrustedEntitySetRequest.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> EXPECTED_BUCKET_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpectedBucketOwner").getter(UpdateTrustedEntitySetRequest.getter(UpdateTrustedEntitySetRequest::expectedBucketOwner)).setter(UpdateTrustedEntitySetRequest.setter(Builder::expectedBucketOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedBucketOwner").build()}).build();
    private static final SdkField<Boolean> ACTIVATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Activate").getter(UpdateTrustedEntitySetRequest.getter(UpdateTrustedEntitySetRequest::activate)).setter(UpdateTrustedEntitySetRequest.setter(Builder::activate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, TRUSTED_ENTITY_SET_ID_FIELD, NAME_FIELD, LOCATION_FIELD, EXPECTED_BUCKET_OWNER_FIELD, ACTIVATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateTrustedEntitySetRequest.memberNameToFieldInitializer();
    private final String detectorId;
    private final String trustedEntitySetId;
    private final String name;
    private final String location;
    private final String expectedBucketOwner;
    private final Boolean activate;

    private UpdateTrustedEntitySetRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.trustedEntitySetId = builder.trustedEntitySetId;
        this.name = builder.name;
        this.location = builder.location;
        this.expectedBucketOwner = builder.expectedBucketOwner;
        this.activate = builder.activate;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final String trustedEntitySetId() {
        return this.trustedEntitySetId;
    }

    public final String name() {
        return this.name;
    }

    public final String location() {
        return this.location;
    }

    public final String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    public final Boolean activate() {
        return this.activate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedEntitySetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedBucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.activate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrustedEntitySetRequest)) {
            return false;
        }
        UpdateTrustedEntitySetRequest other = (UpdateTrustedEntitySetRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.trustedEntitySetId(), other.trustedEntitySetId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.expectedBucketOwner(), other.expectedBucketOwner()) && Objects.equals(this.activate(), other.activate());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTrustedEntitySetRequest").add("DetectorId", (Object)this.detectorId()).add("TrustedEntitySetId", (Object)this.trustedEntitySetId()).add("Name", (Object)this.name()).add("Location", (Object)this.location()).add("ExpectedBucketOwner", (Object)this.expectedBucketOwner()).add("Activate", (Object)this.activate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "TrustedEntitySetId": {
                return Optional.ofNullable(clazz.cast(this.trustedEntitySetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "ExpectedBucketOwner": {
                return Optional.ofNullable(clazz.cast(this.expectedBucketOwner()));
            }
            case "Activate": {
                return Optional.ofNullable(clazz.cast(this.activate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("trustedEntitySetId", TRUSTED_ENTITY_SET_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("location", LOCATION_FIELD);
        map.put("expectedBucketOwner", EXPECTED_BUCKET_OWNER_FIELD);
        map.put("activate", ACTIVATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrustedEntitySetRequest, T> g) {
        return obj -> g.apply((UpdateTrustedEntitySetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private String trustedEntitySetId;
        private String name;
        private String location;
        private String expectedBucketOwner;
        private Boolean activate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrustedEntitySetRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.trustedEntitySetId(model.trustedEntitySetId);
            this.name(model.name);
            this.location(model.location);
            this.expectedBucketOwner(model.expectedBucketOwner);
            this.activate(model.activate);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getTrustedEntitySetId() {
            return this.trustedEntitySetId;
        }

        public final void setTrustedEntitySetId(String trustedEntitySetId) {
            this.trustedEntitySetId = trustedEntitySetId;
        }

        @Override
        public final Builder trustedEntitySetId(String trustedEntitySetId) {
            this.trustedEntitySetId = trustedEntitySetId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getExpectedBucketOwner() {
            return this.expectedBucketOwner;
        }

        public final void setExpectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public final Boolean getActivate() {
            return this.activate;
        }

        public final void setActivate(Boolean activate) {
            this.activate = activate;
        }

        @Override
        public final Builder activate(Boolean activate) {
            this.activate = activate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrustedEntitySetRequest build() {
            return new UpdateTrustedEntitySetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTrustedEntitySetRequest> {
        public Builder detectorId(String var1);

        public Builder trustedEntitySetId(String var1);

        public Builder name(String var1);

        public Builder location(String var1);

        public Builder expectedBucketOwner(String var1);

        public Builder activate(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

